/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractJavaRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTCastExpression;
import net.sourceforge.pmd.ast.ASTCatchStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTThrowStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import org.jaxen.JaxenException;

public class PreserveStackTrace
extends AbstractJavaRule {
    private List<ASTName> nameNodes = new ArrayList<ASTName>();
    private static final String FIND_THROWABLE_INSTANCE = "./VariableInitializer/Expression/PrimaryExpression/PrimaryPrefix/AllocationExpression[ClassOrInterfaceType[contains(@Image,'Exception')] and Arguments[count(*)=0]]";
    private static final String ILLEGAL_STATE_EXCEPTION = "IllegalStateException";
    private static final String FILL_IN_STACKTRACE = ".fillInStackTrace";

    public Object visit(ASTCatchStatement catchStmt, Object data) {
        String target = ((SimpleNode)catchStmt.jjtGetChild(0).jjtGetChild(1)).getImage();
        List<ASTThrowStatement> lstThrowStatements = catchStmt.findChildrenOfType(ASTThrowStatement.class);
        for (ASTThrowStatement throwStatement : lstThrowStatements) {
            SimpleNode child;
            Node n = throwStatement.jjtGetChild(0).jjtGetChild(0);
            if (n.getClass().equals(ASTCastExpression.class)) {
                ASTPrimaryExpression expr = (ASTPrimaryExpression)n.jjtGetChild(1);
                if (expr.jjtGetNumChildren() <= 1 || !expr.jjtGetChild(1).getClass().equals(ASTPrimaryPrefix.class)) continue;
                RuleContext ctx = (RuleContext)data;
                this.addViolation(ctx, throwStatement);
                continue;
            }
            if (this.isThrownExceptionOfType(throwStatement, ILLEGAL_STATE_EXCEPTION)) continue;
            ASTArgumentList args = throwStatement.getFirstChildOfType(ASTArgumentList.class);
            if (args != null) {
                this.ck(data, target, throwStatement, args);
                continue;
            }
            for (child = (SimpleNode)throwStatement.jjtGetChild(0); child != null && child.jjtGetNumChildren() > 0 && !child.getClass().equals(ASTName.class); child = (SimpleNode)child.jjtGetChild(0)) {
            }
            if (child == null) continue;
            if (child.getClass().equals(ASTName.class) && !target.equals(child.getImage()) && !child.hasImageEqualTo(target + FILL_IN_STACKTRACE)) {
                Map<VariableNameDeclaration, List<NameOccurrence>> vars = ((ASTName)child).getScope().getVariableDeclarations();
                for (VariableNameDeclaration decl : vars.keySet()) {
                    args = ((SimpleNode)decl.getNode().jjtGetParent()).getFirstChildOfType(ASTArgumentList.class);
                    if (args == null) continue;
                    this.ck(data, target, throwStatement, args);
                }
                continue;
            }
            if (!child.getClass().equals(ASTClassOrInterfaceType.class)) continue;
            this.addViolation(data, throwStatement);
        }
        return super.visit(catchStmt, data);
    }

    public Object visit(ASTVariableDeclarator node, Object data) {
        try {
            List nodes = node.findChildNodesWithXPath(FIND_THROWABLE_INSTANCE);
            if (nodes.size() > 0) {
                String variableName = ((SimpleNode)node.jjtGetChild(0)).getImage();
                for (ASTCatchStatement catchStmt = node.getFirstParentOfType(ASTCatchStatement.class); catchStmt != null; catchStmt = catchStmt.getFirstParentOfType(ASTCatchStatement.class)) {
                    List violations = catchStmt.findChildNodesWithXPath("//Expression/PrimaryExpression/PrimaryPrefix/Name[@Image = '" + variableName + "']");
                    if (violations == null || violations.size() <= 0 || this.useInitCause((SimpleNode)violations.get(0), catchStmt)) continue;
                    this.addViolation(data, node);
                }
            }
            return super.visit(node, data);
        }
        catch (JaxenException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean useInitCause(SimpleNode node, ASTCatchStatement catchStmt) throws JaxenException {
        List nodes;
        return node != null && node.getImage() != null && (nodes = catchStmt.findChildNodesWithXPath("./Block/BlockStatement/Statement/StatementExpression/PrimaryExpression/PrimaryPrefix/Name[@Image = '" + node.getImage() + ".initCause']")) != null && nodes.size() > 0;
    }

    private boolean isThrownExceptionOfType(ASTThrowStatement throwStatement, String type) {
        boolean status = false;
        try {
            List results = throwStatement.findChildNodesWithXPath("Expression/PrimaryExpression/PrimaryPrefix/AllocationExpression/ClassOrInterfaceType[@Image = '" + type + "']");
            if (results != null && results.size() == 1) {
                status = true;
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return status;
    }

    private void ck(Object data, String target, ASTThrowStatement throwStatement, ASTArgumentList args) {
        boolean match = false;
        this.nameNodes.clear();
        args.findChildrenOfType(ASTName.class, this.nameNodes);
        for (ASTName nameNode : this.nameNodes) {
            if (!target.equals(nameNode.getImage())) continue;
            match = true;
            break;
        }
        if (!match) {
            RuleContext ctx = (RuleContext)data;
            this.addViolation(ctx, throwStatement);
        }
    }
}

