/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTAndExpression;
import net.sourceforge.pmd.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.ast.ASTCastExpression;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.ast.ASTConditionalExpression;
import net.sourceforge.pmd.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTExclusiveOrExpression;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTInclusiveOrExpression;
import net.sourceforge.pmd.ast.ASTInstanceOfExpression;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMultiplicativeExpression;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.ast.ASTPostfixExpression;
import net.sourceforge.pmd.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTReferenceType;
import net.sourceforge.pmd.ast.ASTRelationalExpression;
import net.sourceforge.pmd.ast.ASTShiftExpression;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTType;
import net.sourceforge.pmd.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.ast.ASTUnaryExpression;
import net.sourceforge.pmd.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.ast.TypeNode;
import net.sourceforge.pmd.typeresolution.PMDASMClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTypeResolver
extends JavaParserVisitorAdapter {
    private static final Logger LOG = Logger.getLogger(ClassTypeResolver.class.getName());
    private static final Map<String, Class<?>> myPrimitiveTypes;
    private static final Map<String, String> myJavaLang;
    private final PMDASMClassLoader pmdClassLoader;
    private Map<String, String> importedClasses;
    private List<String> importedOnDemand;

    public ClassTypeResolver() {
        this(ClassTypeResolver.class.getClassLoader());
    }

    public ClassTypeResolver(ClassLoader classLoader) {
        this.pmdClassLoader = new PMDASMClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        String className = null;
        try {
            this.importedOnDemand = new ArrayList<String>();
            this.importedClasses = new HashMap<String, String>();
            className = this.getClassName(node);
            if (className != null) {
                this.populateClassName(node, className);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.FINE, "Could not find class " + className + ", due to: " + e.getClass().getName() + ": " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            LOG.log(Level.WARNING, "Could not find class " + className + ", due to: " + e.getClass().getName() + ": " + e.getMessage());
        }
        catch (ClassFormatError e) {
            LOG.log(Level.WARNING, "Could not find class " + className + ", due to: " + e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            this.populateImports(node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        ASTName importedType = (ASTName)node.jjtGetChild(0);
        if (importedType.getType() != null) {
            node.setType(importedType.getType());
        } else {
            this.populateType(node, importedType.getImage());
        }
        if (node.getType() != null) {
            node.setPackage(node.getType().getPackage());
        }
        return data;
    }

    @Override
    public Object visit(ASTTypeDeclaration node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.populateType(node, node.getImage());
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTName node, Object data) {
        if (node.getNameDeclaration() == null) {
            if (!(node.jjtGetParent() instanceof ASTPackageDeclaration) && !(node.jjtGetParent() instanceof ASTImportDeclaration)) {
                String name = node.getImage();
                if (name.indexOf(46) != -1) {
                    name = name.substring(0, name.indexOf(46));
                }
                this.populateType(node, name);
            }
        } else if (node.getNameDeclaration().getNode() instanceof TypeNode) {
            node.setType((Class)((TypeNode)((Object)node.getNameDeclaration().getNode())).getType());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclarator node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node == null || node.getNameDeclaration() == null) {
            return super.visit(node, data);
        }
        String name = node.getNameDeclaration().getTypeImage();
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.indexOf(46));
        }
        this.populateType(node, name);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTType node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTReferenceType node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTPrimitiveType node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        super.visit(node, data);
        if (!node.isTernary()) {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTConditionalOrExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalAndExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTInclusiveOrExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTExclusiveOrExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTAndExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTEqualityExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTInstanceOfExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTRelationalExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTShiftExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTAdditiveExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTMultiplicativeExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTUnaryExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTPreIncrementExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTPreDecrementExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTUnaryExpressionNotPlusMinus node, Object data) {
        super.visit(node, data);
        if ("!".equals(node.getImage())) {
            this.populateType(node, "boolean");
        } else {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTPostfixExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTCastExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        super.visit(node, data);
        if (node.jjtGetNumChildren() == 1) {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTPrimaryPrefix node, Object data) {
        super.visit(node, data);
        if (node.getImage() == null) {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTPrimarySuffix node, Object data) {
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTNullLiteral node, Object data) {
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTBooleanLiteral node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        super.visit(node, data);
        if (node.jjtGetNumChildren() != 0) {
            this.rollupTypeUnary(node);
        } else if (node.isIntLiteral()) {
            String image = node.getImage();
            if (image.endsWith("l") || image.endsWith("L")) {
                this.populateType(node, "long");
            } else {
                try {
                    Integer.decode(image);
                    this.populateType(node, "int");
                }
                catch (NumberFormatException e) {}
            }
        } else if (node.isFloatLiteral()) {
            String image = node.getImage();
            if (image.endsWith("f") || image.endsWith("F")) {
                this.populateType(node, "float");
            } else if (image.endsWith("d") || image.endsWith("D")) {
                this.populateType(node, "double");
            } else {
                try {
                    Double.parseDouble(image);
                    this.populateType(node, "double");
                }
                catch (NumberFormatException e) {}
            }
        } else if (node.isCharLiteral()) {
            this.populateType(node, "char");
        } else if (node.isStringLiteral()) {
            this.populateType(node, "java.lang.String");
        } else {
            throw new IllegalStateException("PMD error, unknown literal type!");
        }
        return data;
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        super.visit(node, data);
        if (!(node.jjtGetNumChildren() >= 2 && node.jjtGetChild(1) instanceof ASTArrayDimsAndInits || node.jjtGetNumChildren() >= 3 && node.jjtGetChild(2) instanceof ASTArrayDimsAndInits)) {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTStatementExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    private void rollupTypeUnary(TypeNode typeNode) {
        Node child;
        SimpleNode simpleNode;
        if (typeNode instanceof SimpleNode && (simpleNode = (SimpleNode)((Object)typeNode)).jjtGetNumChildren() >= 1 && (child = simpleNode.jjtGetChild(0)) instanceof TypeNode) {
            typeNode.setType(((TypeNode)((Object)child)).getType());
        }
    }

    private void rollupTypeUnaryNumericPromotion(TypeNode typeNode) {
        Class<?> type;
        Node child;
        SimpleNode simpleNode;
        if (typeNode instanceof SimpleNode && (simpleNode = (SimpleNode)((Object)typeNode)).jjtGetNumChildren() >= 1 && (child = simpleNode.jjtGetChild(0)) instanceof TypeNode && (type = ((TypeNode)((Object)child)).getType()) != null) {
            if ("byte".equals(type.getName()) || "short".equals(type.getName()) || "char".equals(type.getName())) {
                this.populateType(typeNode, "int");
            } else {
                typeNode.setType(((TypeNode)((Object)child)).getType());
            }
        }
    }

    private void rollupTypeBinaryNumericPromotion(TypeNode typeNode) {
        SimpleNode simpleNode;
        if (typeNode instanceof SimpleNode && (simpleNode = (SimpleNode)((Object)typeNode)).jjtGetNumChildren() >= 2) {
            Node child1 = simpleNode.jjtGetChild(0);
            Node child2 = simpleNode.jjtGetChild(1);
            if (child1 instanceof TypeNode && child2 instanceof TypeNode) {
                Class<?> type1 = ((TypeNode)((Object)child1)).getType();
                Class<?> type2 = ((TypeNode)((Object)child2)).getType();
                if (type1 != null && type2 != null) {
                    if ("java.lang.String".equals(type1.getName()) || "java.lang.String".equals(type2.getName())) {
                        this.populateType(typeNode, "java.lang.String");
                    } else if ("boolean".equals(type1.getName()) || "boolean".equals(type2.getName())) {
                        this.populateType(typeNode, "boolean");
                    } else if ("double".equals(type1.getName()) || "double".equals(type2.getName())) {
                        this.populateType(typeNode, "double");
                    } else if ("float".equals(type1.getName()) || "float".equals(type2.getName())) {
                        this.populateType(typeNode, "float");
                    } else if ("long".equals(type1.getName()) || "long".equals(type2.getName())) {
                        this.populateType(typeNode, "long");
                    } else {
                        this.populateType(typeNode, "int");
                    }
                } else if ((type1 != null || type2 != null) && (type1 != null && "java.lang.String".equals(type1.getName()) || type2 != null && "java.lang.String".equals(type2.getName()))) {
                    this.populateType(typeNode, "java.lang.String");
                }
            }
        }
    }

    private void populateType(TypeNode node, String className) {
        String qualifiedName = className;
        Class<?> myType = myPrimitiveTypes.get(className);
        if (myType == null && this.importedClasses != null) {
            if (this.importedClasses.containsKey(className)) {
                qualifiedName = this.importedClasses.get(className);
            } else if (this.importedClasses.containsValue(className)) {
                qualifiedName = className;
            }
            if (qualifiedName != null) {
                try {
                    myType = this.pmdClassLoader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException e) {
                    myType = this.processOnDemand(qualifiedName);
                }
                catch (NoClassDefFoundError e) {
                    myType = this.processOnDemand(qualifiedName);
                }
                catch (ClassFormatError e) {
                    myType = this.processOnDemand(qualifiedName);
                }
            }
        }
        if (myType != null) {
            node.setType(myType);
        }
    }

    public boolean classNameExists(String fullyQualifiedClassName) {
        try {
            this.pmdClassLoader.loadClass(fullyQualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Class<?> processOnDemand(String qualifiedName) {
        for (String entry : this.importedOnDemand) {
            try {
                return this.pmdClassLoader.loadClass(entry + "." + qualifiedName);
            }
            catch (Throwable e) {
            }
        }
        return null;
    }

    private String getClassName(ASTCompilationUnit node) {
        ASTClassOrInterfaceDeclaration classDecl = node.getFirstChildOfType(ASTClassOrInterfaceDeclaration.class);
        if (classDecl == null) {
            return null;
        }
        if (node.declarationsAreInDefaultPackage()) {
            return classDecl.getImage();
        }
        ASTPackageDeclaration pkgDecl = node.getPackageDeclaration();
        this.importedOnDemand.add(pkgDecl.getPackageNameImage());
        return pkgDecl.getPackageNameImage() + "." + classDecl.getImage();
    }

    private void populateImports(ASTCompilationUnit node) {
        List<ASTImportDeclaration> theImportDeclarations = node.findChildrenOfType(ASTImportDeclaration.class);
        this.importedClasses.putAll(myJavaLang);
        for (ASTImportDeclaration anImportDeclaration : theImportDeclarations) {
            String strPackage = anImportDeclaration.getPackageName();
            if (anImportDeclaration.isImportOnDemand()) {
                this.importedOnDemand.add(strPackage);
                continue;
            }
            if (anImportDeclaration.isImportOnDemand()) continue;
            String strName = anImportDeclaration.getImportedName();
            this.importedClasses.put(strName, strName);
            this.importedClasses.put(strName.substring(strPackage.length() + 1), strName);
        }
    }

    private void populateClassName(ASTCompilationUnit node, String className) throws ClassNotFoundException {
        node.setType((Class)this.pmdClassLoader.loadClass(className));
        this.importedClasses.putAll(this.pmdClassLoader.getImportedClasses(className));
    }

    static {
        HashMap<String, Class<Object>> thePrimitiveTypes = new HashMap<String, Class<Object>>();
        thePrimitiveTypes.put("void", Void.TYPE);
        thePrimitiveTypes.put("boolean", Boolean.TYPE);
        thePrimitiveTypes.put("byte", Byte.TYPE);
        thePrimitiveTypes.put("char", Character.TYPE);
        thePrimitiveTypes.put("short", Short.TYPE);
        thePrimitiveTypes.put("int", Integer.TYPE);
        thePrimitiveTypes.put("long", Long.TYPE);
        thePrimitiveTypes.put("float", Float.TYPE);
        thePrimitiveTypes.put("double", Double.TYPE);
        myPrimitiveTypes = Collections.unmodifiableMap(thePrimitiveTypes);
        HashMap<String, String> theJavaLang = new HashMap<String, String>();
        theJavaLang.put("Boolean", "java.lang.Boolean");
        theJavaLang.put("Byte", "java.lang.Byte");
        theJavaLang.put("Character", "java.lang.Character");
        theJavaLang.put("CharSequence", "java.lang.CharSequence");
        theJavaLang.put("Class", "java.lang.Class");
        theJavaLang.put("ClassLoader", "java.lang.ClassLoader");
        theJavaLang.put("Cloneable", "java.lang.Cloneable");
        theJavaLang.put("Comparable", "java.lang.Comparable");
        theJavaLang.put("Compiler", "java.lang.Compiler");
        theJavaLang.put("Double", "java.lang.Double");
        theJavaLang.put("Float", "java.lang.Float");
        theJavaLang.put("InheritableThreadLocal", "java.lang.InheritableThreadLocal");
        theJavaLang.put("Integer", "java.lang.Integer");
        theJavaLang.put("Long", "java.lang.Long");
        theJavaLang.put("Math", "java.lang.Math");
        theJavaLang.put("Number", "java.lang.Number");
        theJavaLang.put("Object", "java.lang.Object");
        theJavaLang.put("Package", "java.lang.Package");
        theJavaLang.put("Process", "java.lang.Process");
        theJavaLang.put("Runnable", "java.lang.Runnable");
        theJavaLang.put("Runtime", "java.lang.Runtime");
        theJavaLang.put("RuntimePermission", "java.lang.RuntimePermission");
        theJavaLang.put("SecurityManager", "java.lang.SecurityManager");
        theJavaLang.put("Short", "java.lang.Short");
        theJavaLang.put("StackTraceElement", "java.lang.StackTraceElement");
        theJavaLang.put("StrictMath", "java.lang.StrictMath");
        theJavaLang.put("String", "java.lang.String");
        theJavaLang.put("StringBuffer", "java.lang.StringBuffer");
        theJavaLang.put("System", "java.lang.System");
        theJavaLang.put("Thread", "java.lang.Thread");
        theJavaLang.put("ThreadGroup", "java.lang.ThreadGroup");
        theJavaLang.put("ThreadLocal", "java.lang.ThreadLocal");
        theJavaLang.put("Throwable", "java.lang.Throwable");
        theJavaLang.put("Void", "java.lang.Void");
        myJavaLang = Collections.unmodifiableMap(theJavaLang);
    }
}

