/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.jaxen.MatchesFunction;
import net.sourceforge.pmd.jaxen.TypeOfFunction;
import net.sourceforge.pmd.parsers.Parser;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandler;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandlerBroker;
import net.sourceforge.pmd.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.symboltable.ClassScope;
import net.sourceforge.pmd.symboltable.LocalScope;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.MethodScope;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.SourceFileScope;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.util.NumericConstants;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.designer.CodeEditorTextPane;
import net.sourceforge.pmd.util.designer.CreateXMLRulePanel;
import net.sourceforge.pmd.util.designer.DFAGraphRule;
import net.sourceforge.pmd.util.designer.DFAPanel;
import net.sourceforge.pmd.util.designer.MyPrintStream;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;

public class Designer
implements ClipboardOwner {
    private static final char LABEL_IMAGE_SEPARATOR = ':';
    private static final Object[][] sourceTypeSets = new Object[][]{{"JDK 1.3", SourceType.JAVA_13}, {"JDK 1.4", SourceType.JAVA_14}, {"JDK 1.5", SourceType.JAVA_15}, {"JDK 1.6", SourceType.JAVA_16}, {"JDK 1.7", SourceType.JAVA_17}, {"JSP", SourceType.JSP}};
    private static final int defaultSourceTypeSelectionIndex = 2;
    private boolean exitOnClose = true;
    private final CodeEditorTextPane codeEditorPane = new CodeEditorTextPane();
    private final TreeWidget astTreeWidget = new TreeWidget(new Object[0]);
    private DefaultListModel xpathResults = new DefaultListModel();
    private final JList xpathResultList = new JList(this.xpathResults);
    private final JTextArea xpathQueryArea = new JTextArea(15, 30);
    private final TreeWidget symbolTableTreeWidget = new TreeWidget(new Object[0]);
    private final JFrame frame = new JFrame("PMD Rule Designer (v 4.2.6)");
    private final DFAPanel dfaPanel = new DFAPanel();
    private final JRadioButtonMenuItem[] sourceTypeMenuItems = new JRadioButtonMenuItem[sourceTypeSets.length];

    private SimpleNode getCompilationUnit() {
        SourceTypeHandler handler = SourceTypeHandlerBroker.getVisitorsFactoryForSourceType(this.getSourceType());
        Parser parser = handler.getParser();
        parser.setExcludeMarker("NOPMD");
        SimpleNode simpleNode = (SimpleNode)parser.parse(new StringReader(this.codeEditorPane.getText()));
        handler.getSymbolFacade().start(simpleNode);
        handler.getTypeResolutionFacade(null).start(simpleNode);
        return simpleNode;
    }

    private SourceType getSourceType() {
        return (SourceType)sourceTypeSets[this.selectedSourceTypeIndex()][1];
    }

    private int selectedSourceTypeIndex() {
        for (int i = 0; i < this.sourceTypeMenuItems.length; ++i) {
            if (!this.sourceTypeMenuItems[i].isSelected()) continue;
            return i;
        }
        throw new RuntimeException("Initial default source type not specified");
    }

    private TreeCellRenderer createNoImageTreeCellRenderer() {
        DefaultTreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer();
        treeCellRenderer.setLeafIcon(null);
        treeCellRenderer.setOpenIcon(null);
        treeCellRenderer.setClosedIcon(null);
        return treeCellRenderer;
    }

    private void loadASTTreeData(TreeNode rootNode) {
        this.astTreeWidget.setModel(new DefaultTreeModel(rootNode));
        this.astTreeWidget.expandAll(true);
    }

    private void loadSymbolTableTreeData(TreeNode rootNode) {
        if (rootNode != null) {
            this.symbolTableTreeWidget.setModel(new DefaultTreeModel(rootNode));
            this.symbolTableTreeWidget.expandAll(true);
        } else {
            this.symbolTableTreeWidget.setModel(null);
        }
    }

    public Designer(String[] args) {
        if (args.length > 0) {
            this.exitOnClose = !args[0].equals("-noexitonclose");
        }
        MatchesFunction.registerSelfInSimpleContext();
        TypeOfFunction.registerSelfInSimpleContext();
        this.xpathQueryArea.setFont(new Font("Verdana", 0, 16));
        JSplitPane controlSplitPane = new JSplitPane(1, this.createCodeEditorPanel(), this.createXPathQueryPanel());
        JSplitPane astAndSymbolTablePane = new JSplitPane(0, this.createASTPanel(), this.createSymbolTableResultPanel());
        JSplitPane resultsSplitPane = new JSplitPane(1, astAndSymbolTablePane, this.createXPathResultPanel());
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.addTab("Abstract Syntax Tree / XPath / Symbol Table", resultsSplitPane);
        tabbed.addTab("Data Flow Analysis", this.dfaPanel);
        try {
            Method setMnemonicAt = JTabbedPane.class.getMethod("setMnemonicAt", Integer.TYPE, Integer.TYPE);
            if (setMnemonicAt != null) {
                setMnemonicAt.invoke((Object)tabbed, NumericConstants.ZERO, 65);
                setMnemonicAt.invoke((Object)tabbed, NumericConstants.ONE, 68);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new InternalError("Runtime reports to be >= JDK 1.4 yet String.split(java.lang.String) is broken.");
        }
        JSplitPane containerSplitPane = new JSplitPane(0, controlSplitPane, tabbed);
        containerSplitPane.setContinuousLayout(true);
        JMenuBar menuBar = this.createMenuBar();
        this.frame.setJMenuBar(menuBar);
        this.frame.getContentPane().add(containerSplitPane);
        this.frame.setDefaultCloseOperation(this.exitOnClose ? 3 : 2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.frame.pack();
        this.frame.setSize(screenWidth * 3 / 4, screenHeight * 3 / 4);
        this.frame.setLocation((screenWidth - this.frame.getWidth()) / 2, (screenHeight - this.frame.getHeight()) / 2);
        this.frame.setVisible(true);
        int horozontalMiddleLocation = controlSplitPane.getMaximumDividerLocation() * 3 / 5;
        controlSplitPane.setDividerLocation(horozontalMiddleLocation);
        containerSplitPane.setDividerLocation(containerSplitPane.getMaximumDividerLocation() / 2);
        astAndSymbolTablePane.setDividerLocation(astAndSymbolTablePane.getMaximumDividerLocation() / 3);
        resultsSplitPane.setDividerLocation(horozontalMiddleLocation);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("JDK");
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < sourceTypeSets.length; ++i) {
            JRadioButtonMenuItem button;
            this.sourceTypeMenuItems[i] = button = new JRadioButtonMenuItem(sourceTypeSets[i][0].toString());
            group.add(button);
            menu.add(button);
        }
        this.sourceTypeMenuItems[2].setSelected(true);
        menuBar.add(menu);
        JMenu actionsMenu = new JMenu("Actions");
        JMenuItem copyXMLItem = new JMenuItem("Copy xml to clipboard");
        copyXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.copyXmlToClipboard();
            }
        });
        actionsMenu.add(copyXMLItem);
        JMenuItem createRuleXMLItem = new JMenuItem("Create rule XML");
        createRuleXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.createRuleXML();
            }
        });
        actionsMenu.add(createRuleXMLItem);
        menuBar.add(actionsMenu);
        return menuBar;
    }

    private void createRuleXML() {
        CreateXMLRulePanel rulePanel = new CreateXMLRulePanel(this.xpathQueryArea, this.codeEditorPane);
        JFrame xmlframe = new JFrame("Create XML Rule");
        xmlframe.setContentPane(rulePanel);
        xmlframe.setDefaultCloseOperation(2);
        xmlframe.setSize(new Dimension(600, 700));
        xmlframe.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JFrame tmp = (JFrame)e.getSource();
                if (tmp.getWidth() < 600 || tmp.getHeight() < 700) {
                    tmp.setSize(600, 700);
                }
            }
        });
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        xmlframe.pack();
        xmlframe.setLocation((screenWidth - xmlframe.getWidth()) / 2, (screenHeight - xmlframe.getHeight()) / 2);
        xmlframe.setVisible(true);
    }

    private JComponent createCodeEditorPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.codeEditorPane.setBorder(BorderFactory.createLineBorder(Color.black));
        Designer.makeTextComponentUndoable(this.codeEditorPane);
        p.add((Component)new JLabel("Source code:"), "North");
        p.add((Component)new JScrollPane(this.codeEditorPane), "Center");
        return p;
    }

    private JComponent createASTPanel() {
        this.astTreeWidget.setCellRenderer(this.createNoImageTreeCellRenderer());
        TreeSelectionModel model = this.astTreeWidget.getSelectionModel();
        model.setSelectionMode(1);
        model.addTreeSelectionListener(new SymbolTableListener());
        model.addTreeSelectionListener(new CodeHighlightListener());
        return new JScrollPane(this.astTreeWidget);
    }

    private JComponent createXPathResultPanel() {
        this.xpathResults.addElement("No XPath results yet, run an XPath Query first.");
        this.xpathResultList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.xpathResultList.setFixedCellWidth(300);
        this.xpathResultList.setCellRenderer(new ASTListCellRenderer());
        this.xpathResultList.setSelectionMode(0);
        this.xpathResultList.getSelectionModel().addListSelectionListener(new ASTSelectionListener());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.xpathResultList);
        return scrollPane;
    }

    private JPanel createXPathQueryPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.xpathQueryArea.setBorder(BorderFactory.createLineBorder(Color.black));
        Designer.makeTextComponentUndoable(this.xpathQueryArea);
        JScrollPane scrollPane = new JScrollPane(this.xpathQueryArea);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        JButton b = this.createGoButton();
        p.add((Component)new JLabel("XPath Query (if any):"), "North");
        p.add((Component)scrollPane, "Center");
        p.add((Component)b, "South");
        return p;
    }

    private JComponent createSymbolTableResultPanel() {
        this.symbolTableTreeWidget.setCellRenderer(this.createNoImageTreeCellRenderer());
        return new JScrollPane(this.symbolTableTreeWidget);
    }

    private JButton createGoButton() {
        JButton b = new JButton("Go");
        b.setMnemonic('g');
        b.addActionListener(new ShowListener());
        b.addActionListener(this.codeEditorPane);
        b.addActionListener(new XPathListener());
        b.addActionListener(new DFAListener());
        return b;
    }

    private static void makeTextComponentUndoable(JTextComponent textConponent) {
        final UndoManager undoManager = new UndoManager();
        textConponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                undoManager.addEdit(evt.getEdit());
            }
        });
        ActionMap actionMap = textConponent.getActionMap();
        InputMap inputMap = textConponent.getInputMap();
        actionMap.put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control Z"), "Undo");
        actionMap.put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public static void main(String[] args) {
        new Designer(args);
    }

    private final void copyXmlToClipboard() {
        if (this.codeEditorPane.getText() != null && this.codeEditorPane.getText().trim().length() > 0) {
            String xml = "";
            SimpleNode cu = this.getCompilationUnit();
            if (cu != null) {
                try {
                    xml = this.getXmlString(cu);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    xml = "Error trying to construct XML representation";
                }
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(xml), this);
        }
    }

    private String getXmlString(SimpleNode node) throws TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(node.asXml());
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", 4);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Transformer xformer = transformerFactory.newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        xformer.transform(source, result);
        return writer.toString();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private class ASTSelectionListener
    implements ListSelectionListener {
        private ASTSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Object o;
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty() && (o = Designer.this.xpathResults.get(lsm.getMinSelectionIndex())) instanceof SimpleNode) {
                Designer.this.codeEditorPane.select((SimpleNode)o);
            }
        }
    }

    private class ASTListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ASTListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof SimpleNode) {
                SimpleNode node = (SimpleNode)value;
                StringBuffer sb = new StringBuffer();
                String name = node.getClass().getName().substring(node.getClass().getName().lastIndexOf(46) + 1);
                sb.append(name).append(" at line ").append(node.getBeginLine()).append(" column ").append(node.getBeginColumn()).append(PMD.EOL);
                text = sb.toString();
            } else {
                text = value.toString();
            }
            this.setText(text);
            return this;
        }
    }

    private class CodeHighlightListener
    implements TreeSelectionListener {
        private CodeHighlightListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            ASTTreeNode selected;
            if (e.getNewLeadSelectionPath() != null && (selected = (ASTTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()) != null && selected.node instanceof SimpleNode) {
                SimpleNode node = (SimpleNode)selected.node;
                Designer.this.codeEditorPane.select(node);
            }
        }
    }

    private class SymbolTableListener
    implements TreeSelectionListener {
        private SymbolTableListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (e.getNewLeadSelectionPath() != null) {
                Scope scope;
                ASTTreeNode astTreeNode = (ASTTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                DefaultMutableTreeNode symbolTableTreeNode = new DefaultMutableTreeNode();
                DefaultMutableTreeNode selectedAstTreeNode = new DefaultMutableTreeNode("AST Node: " + astTreeNode.label());
                symbolTableTreeNode.add(selectedAstTreeNode);
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                for (scope = astTreeNode.getScope(); scope != null; scope = scope.getParent()) {
                    scopes.add(scope);
                }
                Collections.reverse(scopes);
                for (int i = 0; i < scopes.size(); ++i) {
                    ClassScope classScope;
                    DefaultMutableTreeNode nameOccurenceTreeNode;
                    scope = (Scope)scopes.get(i);
                    DefaultMutableTreeNode scopeTreeNode = new DefaultMutableTreeNode("Scope: " + scope.getClass().getSimpleName());
                    selectedAstTreeNode.add(scopeTreeNode);
                    if (!(scope instanceof MethodScope || scope instanceof LocalScope || scope.getClassDeclarations().isEmpty())) {
                        for (ClassNameDeclaration classNameDeclaration : scope.getClassDeclarations().keySet()) {
                            DefaultMutableTreeNode classNameDeclarationTreeNode = new DefaultMutableTreeNode("Class name declaration: " + classNameDeclaration);
                            scopeTreeNode.add(classNameDeclarationTreeNode);
                            for (NameOccurrence nameOccurrence : scope.getClassDeclarations().get(classNameDeclaration)) {
                                nameOccurenceTreeNode = new DefaultMutableTreeNode("Name occurrence: " + nameOccurrence);
                                classNameDeclarationTreeNode.add(nameOccurenceTreeNode);
                            }
                        }
                    }
                    if (scope instanceof ClassScope && !(classScope = (ClassScope)scope).getMethodDeclarations().isEmpty()) {
                        for (MethodNameDeclaration methodNameDeclaration : classScope.getMethodDeclarations().keySet()) {
                            DefaultMutableTreeNode methodNameDeclarationTreeNode = new DefaultMutableTreeNode("Method name declaration: " + methodNameDeclaration);
                            scopeTreeNode.add(methodNameDeclarationTreeNode);
                            for (NameOccurrence nameOccurrence : classScope.getMethodDeclarations().get(methodNameDeclaration)) {
                                DefaultMutableTreeNode nameOccurenceTreeNode2 = new DefaultMutableTreeNode("Name occurrence: " + nameOccurrence);
                                methodNameDeclarationTreeNode.add(nameOccurenceTreeNode2);
                            }
                        }
                    }
                    if (scope instanceof SourceFileScope || scope.getVariableDeclarations().isEmpty()) continue;
                    for (VariableNameDeclaration variableNameDeclaration : scope.getVariableDeclarations().keySet()) {
                        DefaultMutableTreeNode variableNameDeclarationTreeNode = new DefaultMutableTreeNode("Variable name declaration: " + variableNameDeclaration);
                        scopeTreeNode.add(variableNameDeclarationTreeNode);
                        for (NameOccurrence nameOccurrence : scope.getVariableDeclarations().get(variableNameDeclaration)) {
                            nameOccurenceTreeNode = new DefaultMutableTreeNode("Name occurrence: " + nameOccurrence);
                            variableNameDeclarationTreeNode.add(nameOccurenceTreeNode);
                        }
                    }
                }
                Designer.this.loadSymbolTableTreeData(symbolTableTreeNode);
            }
        }
    }

    private class XPathListener
    implements ActionListener {
        private XPathListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            Designer.this.xpathResults.clear();
            if (Designer.this.xpathQueryArea.getText().length() == 0) {
                Designer.this.xpathResults.addElement("XPath query field is empty.");
                Designer.this.xpathResultList.repaint();
                Designer.this.codeEditorPane.requestFocus();
                return;
            }
            SimpleNode c = Designer.this.getCompilationUnit();
            try {
                BaseXPath xpath = new BaseXPath(Designer.this.xpathQueryArea.getText(), new DocumentNavigator());
                for (Object obj : xpath.selectNodes(c)) {
                    if (obj instanceof String) {
                        System.out.println("Result was a string: " + (String)obj);
                        continue;
                    }
                    if (obj instanceof Boolean) continue;
                    Designer.this.xpathResults.addElement(obj);
                }
                if (Designer.this.xpathResults.isEmpty()) {
                    Designer.this.xpathResults.addElement("No matching nodes " + System.currentTimeMillis());
                }
            }
            catch (ParseException pe) {
                Designer.this.xpathResults.addElement(pe.fillInStackTrace().getMessage());
            }
            catch (JaxenException je) {
                Designer.this.xpathResults.addElement(je.fillInStackTrace().getMessage());
            }
            Designer.this.xpathResultList.repaint();
            Designer.this.xpathQueryArea.requestFocus();
        }
    }

    private class DFAListener
    implements ActionListener {
        private DFAListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            DFAGraphRule dfaGraphRule = new DFAGraphRule();
            RuleSet rs = new RuleSet();
            SourceType sourceType = Designer.this.getSourceType();
            if (!sourceType.equals(SourceType.JSP)) {
                rs.addRule(dfaGraphRule);
            }
            RuleContext ctx = new RuleContext();
            ctx.setSourceCodeFilename("[no filename]");
            StringReader reader = new StringReader(Designer.this.codeEditorPane.getText());
            PMD pmd = new PMD();
            pmd.setJavaVersion(sourceType);
            try {
                pmd.processFile((Reader)reader, rs, ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List<ASTMethodDeclaration> methods = dfaGraphRule.getMethods();
            if (methods != null && !methods.isEmpty()) {
                Designer.this.dfaPanel.resetTo(methods, Designer.this.codeEditorPane);
                Designer.this.dfaPanel.repaint();
            }
        }
    }

    private class ShowListener
    implements ActionListener {
        private ShowListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            TreeNode tn;
            MyPrintStream ps = new MyPrintStream();
            System.setOut(ps);
            try {
                SimpleNode lastCompilationUnit = Designer.this.getCompilationUnit();
                tn = new ASTTreeNode(lastCompilationUnit);
            }
            catch (ParseException pe) {
                tn = new ExceptionNode(pe);
            }
            Designer.this.loadASTTreeData(tn);
            Designer.this.loadSymbolTableTreeData(null);
        }
    }

    private class TreeWidget
    extends JTree {
        private static final long serialVersionUID = 1L;

        public TreeWidget(Object[] items) {
            super(items);
            this.setToolTipText("");
        }

        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value == null) {
                return "";
            }
            if (value instanceof ASTTreeNode) {
                return ((ASTTreeNode)value).label();
            }
            if (value instanceof ExceptionNode) {
                return ((ExceptionNode)value).label();
            }
            return value.toString();
        }

        public String getToolTipText(MouseEvent e) {
            if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
                return null;
            }
            TreePath curPath = this.getPathForLocation(e.getX(), e.getY());
            if (curPath.getLastPathComponent() instanceof ASTTreeNode) {
                return ((ASTTreeNode)curPath.getLastPathComponent()).getToolTipText();
            }
            return super.getToolTipText(e);
        }

        public void expandAll(boolean expand) {
            TreeNode root = (TreeNode)this.getModel().getRoot();
            this.expandAll(new TreePath(root), expand);
        }

        private void expandAll(TreePath parent, boolean expand) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(path, expand);
                }
            }
            if (expand) {
                this.expandPath(parent);
            } else {
                this.collapsePath(parent);
            }
        }
    }

    private class ASTTreeNode
    implements TreeNode {
        private Node node;
        private ASTTreeNode parent;
        private ASTTreeNode[] kids;

        public ASTTreeNode(Node theNode) {
            this.node = theNode;
            Node prnt = this.node.jjtGetParent();
            if (prnt != null) {
                this.parent = new ASTTreeNode(prnt);
            }
        }

        public int getChildCount() {
            return this.node.jjtGetNumChildren();
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return this.node.jjtGetNumChildren() == 0;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public Scope getScope() {
            if (this.node instanceof SimpleNode) {
                return ((SimpleNode)this.node).getScope();
            }
            return null;
        }

        public Enumeration children() {
            if (this.getChildCount() > 0) {
                this.getChildAt(0);
            }
            Enumeration e = new Enumeration(){
                int i = 0;

                public boolean hasMoreElements() {
                    return ASTTreeNode.this.kids != null && this.i < ASTTreeNode.this.kids.length;
                }

                public Object nextElement() {
                    return ASTTreeNode.this.kids[this.i++];
                }
            };
            return e;
        }

        public TreeNode getChildAt(int childIndex) {
            if (this.kids == null) {
                this.kids = new ASTTreeNode[this.node.jjtGetNumChildren()];
                for (int i = 0; i < this.kids.length; ++i) {
                    this.kids[i] = new ASTTreeNode(this.node.jjtGetChild(i));
                }
            }
            return this.kids[childIndex];
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] != node) continue;
                return i;
            }
            return -1;
        }

        public String label() {
            if (this.node instanceof SimpleNode) {
                SimpleNode sn = (SimpleNode)this.node;
                if (sn.getLabel() != null) {
                    return this.node.toString() + ':' + sn.getLabel();
                }
                if (sn.getImage() == null) {
                    return this.node.toString();
                }
                return this.node.toString() + ':' + sn.getImage();
            }
            return this.node.toString();
        }

        public String getToolTipText() {
            String tooltip = "";
            if (this.node instanceof SimpleNode) {
                SimpleNode sn = (SimpleNode)this.node;
                tooltip = "Line: " + sn.getBeginLine() + " Column: " + sn.getBeginColumn();
            }
            if (this.node instanceof AccessNode) {
                AccessNode accessNode = (AccessNode)this.node;
                if (!"".equals(tooltip)) {
                    tooltip = tooltip + ",";
                }
                tooltip = tooltip + (accessNode.isAbstract() ? " Abstract" : "");
                tooltip = tooltip + (accessNode.isStatic() ? " Static" : "");
                tooltip = tooltip + (accessNode.isFinal() ? " Final" : "");
                tooltip = tooltip + (accessNode.isNative() ? " Native" : "");
                tooltip = tooltip + (accessNode.isPrivate() ? " Private" : "");
                tooltip = tooltip + (accessNode.isSynchronized() ? " Synchronised" : "");
                tooltip = tooltip + (accessNode.isTransient() ? " Transient" : "");
                tooltip = tooltip + (accessNode.isVolatile() ? " Volatile" : "");
                tooltip = tooltip + (accessNode.isStrictfp() ? " Strictfp" : "");
            }
            return tooltip;
        }
    }

    private class ExceptionNode
    implements TreeNode {
        private Object item;
        private ExceptionNode[] kids;

        public ExceptionNode(Object theItem) {
            this.item = theItem;
            if (this.item instanceof ParseException) {
                this.createKids();
            }
        }

        private void createKids() {
            String message = ((ParseException)this.item).getMessage();
            String[] lines = StringUtil.substringsOf(message, PMD.EOL);
            this.kids = new ExceptionNode[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                this.kids[i] = new ExceptionNode(lines[i]);
            }
        }

        public int getChildCount() {
            return this.kids == null ? 0 : this.kids.length;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public boolean isLeaf() {
            return this.kids == null;
        }

        public TreeNode getParent() {
            return null;
        }

        public TreeNode getChildAt(int childIndex) {
            return this.kids[childIndex];
        }

        public String label() {
            return this.item.toString();
        }

        public Enumeration children() {
            Enumeration e = new Enumeration(){
                int i = 0;

                public boolean hasMoreElements() {
                    return ExceptionNode.this.kids != null && this.i < ExceptionNode.this.kids.length;
                }

                public Object nextElement() {
                    return ExceptionNode.this.kids[this.i++];
                }
            };
            return e;
        }

        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] != node) continue;
                return i;
            }
            return -1;
        }
    }
}

