/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import alice.tuprolog.event.OutputEvent;
import alice.tuprolog.event.OutputListener;
import alice.util.Tools;
import java.io.InputStream;

public class Agent {
    private Prolog core;
    private String theoryText;
    private InputStream theoryInputStream;
    private String goalText;
    private OutputListener defaultOutputListener = new OutputListener(){

        public void onOutput(OutputEvent outputEvent) {
            System.out.print(outputEvent.getMsg());
        }
    };

    public Agent(String string) {
        this.theoryText = string;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public Agent(String string, String string2) {
        this.theoryText = string;
        this.goalText = string2;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public Agent(InputStream inputStream) {
        this.theoryInputStream = inputStream;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public Agent(InputStream inputStream, String string) {
        this.theoryInputStream = inputStream;
        this.goalText = string;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public final void spawn() {
        new AgentThread(this).start();
    }

    public synchronized void addOutputListener(OutputListener outputListener) {
        this.core.addOutputListener(outputListener);
    }

    public synchronized void removeOutputListener(OutputListener outputListener) {
        this.core.removeOutputListener(outputListener);
    }

    public void removeAllOutputListener() {
        this.core.removeAllOutputListeners();
    }

    private void body() {
        try {
            if (this.theoryText == null) {
                this.core.setTheory(new Theory(this.theoryInputStream));
            } else {
                this.core.setTheory(new Theory(this.theoryText));
            }
            if (this.goalText != null) {
                this.core.solve(this.goalText);
            }
        }
        catch (Exception exception) {
            System.err.println("invalid theory or goal.");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        block5: {
            if (stringArray.length == 1 || stringArray.length == 2) {
                try {
                    String string = Tools.loadText(stringArray[0]);
                    if (stringArray.length == 1) {
                        new Agent(string).spawn();
                        break block5;
                    }
                    new Agent(string, stringArray[1]).spawn();
                }
                catch (Exception exception) {
                    System.err.println("invalid theory.");
                }
            } else {
                System.err.println("args: <theory file> { goal }");
                System.exit(-1);
            }
        }
    }

    final class AgentThread
    extends Thread {
        Agent agent;

        AgentThread(Agent agent2) {
            this.agent = agent2;
        }

        public final void run() {
            this.agent.body();
        }
    }
}

