/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.EngineManager;
import alice.tuprolog.FlagManager;
import alice.tuprolog.Int;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.LibraryManager;
import alice.tuprolog.Number;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.PrologError;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.TheoryManager;
import alice.tuprolog.Var;
import alice.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class BuiltIn
extends Library {
    private EngineManager engineManager;
    private TheoryManager theoryManager;
    private LibraryManager libraryManager;
    private FlagManager flagManager;
    private PrimitiveManager primitiveManager;
    private OperatorManager operatorManager;

    public BuiltIn(Prolog prolog) {
        this.setEngine(prolog);
        this.engineManager = prolog.getEngineManager();
        this.theoryManager = prolog.getTheoryManager();
        this.libraryManager = prolog.getLibraryManager();
        this.flagManager = prolog.getFlagManager();
        this.primitiveManager = prolog.getPrimitiveManager();
        this.operatorManager = prolog.getOperatorManager();
    }

    @Override
    public String[][] getSynonymMap() {
        return new String[][]{{"!", "cut", "predicate"}, {"=", "unify", "predicate"}, {"\\=", "deunify", "predicate"}, {",", "comma", "predicate"}, {"op", "$op", "predicate"}, {"solve", "initialization", "directive"}, {"consult", "include", "directive"}, {"load_library", "$load_library", "directive"}};
    }

    public boolean fail_0() {
        return false;
    }

    public boolean true_0() {
        return true;
    }

    public boolean halt_0() {
        System.exit(0);
        return true;
    }

    public boolean cut_0() {
        this.engineManager.cut();
        return true;
    }

    public boolean asserta_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Struct) {
            if (((Struct)term).getName().equals(":-")) {
                for (int i = 0; i < ((Struct)term).toList().listSize() - 1; ++i) {
                    Term term2 = ((Struct)term).getArg(i);
                    if (term2 instanceof Struct) continue;
                    if (term2 instanceof Var) {
                        throw PrologError.instantiation_error(this.engineManager, 1);
                    }
                    throw PrologError.type_error(this.engineManager, 1, "clause", term);
                }
            }
            this.theoryManager.assertA((Struct)term, true, null, false);
            return true;
        }
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        throw PrologError.type_error(this.engineManager, 1, "clause", term);
    }

    public boolean assertz_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Struct) {
            if (((Struct)term).getName().equals(":-")) {
                for (int i = 0; i < ((Struct)term).toList().listSize() - 1; ++i) {
                    Term term2 = ((Struct)term).getArg(i);
                    if (term2 instanceof Struct) continue;
                    if (term2 instanceof Var) {
                        throw PrologError.instantiation_error(this.engineManager, 1);
                    }
                    throw PrologError.type_error(this.engineManager, 1, "clause", term);
                }
            }
            this.theoryManager.assertZ((Struct)term, true, null, false);
            return true;
        }
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        throw PrologError.type_error(this.engineManager, 1, "clause", term);
    }

    public boolean $retract_1(Term term) throws PrologError {
        if (!((term = term.getTerm()) instanceof Struct)) {
            if (term instanceof Var) {
                throw PrologError.instantiation_error(this.engineManager, 1);
            }
            throw PrologError.type_error(this.engineManager, 1, "clause", term);
        }
        Struct struct = (Struct)term;
        ClauseInfo clauseInfo = this.theoryManager.retract(struct);
        if (clauseInfo != null) {
            Struct struct2 = null;
            struct2 = !struct.isClause() ? new Struct(":-", term, new Struct("true")) : struct;
            this.unify(struct2, clauseInfo.getClause());
            return true;
        }
        return false;
    }

    public boolean abolish_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        if (!(term instanceof Struct) || !term.isGround()) {
            throw PrologError.type_error(this.engineManager, 1, "predicate_indicator", term);
        }
        if (((Struct)term).getArg(0).toString().equals("abolish")) {
            throw PrologError.permission_error(this.engineManager, "modify", "static_procedure", term, new Struct(""));
        }
        return this.theoryManager.abolish((Struct)term);
    }

    public boolean halt_1(Term term) throws PrologError {
        if (term instanceof Int) {
            System.exit(((Int)term).intValue());
        }
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        throw PrologError.type_error(this.engineManager, 1, "integer", term);
    }

    public boolean load_library_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom()) {
            if (term instanceof Var) {
                throw PrologError.instantiation_error(this.engineManager, 1);
            }
            throw PrologError.type_error(this.engineManager, 1, "atom", term);
        }
        try {
            this.libraryManager.loadLibrary(((Struct)term).getName());
            return true;
        }
        catch (Exception exception) {
            throw PrologError.existence_error(this.engineManager, 1, "class", term, new Struct(exception.getMessage()));
        }
    }

    public boolean load_library_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (!term.isAtom()) {
            if (term instanceof Var) {
                throw PrologError.instantiation_error(this.engineManager, 1);
            }
            throw PrologError.type_error(this.engineManager, 1, "atom", term);
        }
        if (!term2.isList()) {
            throw PrologError.type_error(this.engineManager, 2, "list", term2);
        }
        try {
            String[] stringArray = this.getStringArrayFromStruct((Struct)term2);
            if (stringArray == null || stringArray.length == 0) {
                throw PrologError.existence_error(this.engineManager, 2, "paths", term2, new Struct("Invalid paths' list."));
            }
            this.libraryManager.loadLibrary(((Struct)term).getName(), stringArray);
            return true;
        }
        catch (Exception exception) {
            throw PrologError.existence_error(this.engineManager, 1, "class", term, new Struct(exception.getMessage()));
        }
    }

    private String[] getStringArrayFromStruct(Struct struct) {
        String[] stringArray = new String[struct.listSize()];
        Iterator<? extends Term> iterator = struct.listIterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = Tools.removeApices(iterator.next().toString());
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public boolean unload_library_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom()) {
            if (term instanceof Var) {
                throw PrologError.instantiation_error(this.engineManager, 1);
            }
            throw PrologError.type_error(this.engineManager, 1, "atom", term);
        }
        try {
            this.libraryManager.unloadLibrary(((Struct)term).getName());
            return true;
        }
        catch (Exception exception) {
            throw PrologError.existence_error(this.engineManager, 1, "class", term, new Struct(exception.getMessage()));
        }
    }

    public boolean flag_list_1(Term term) {
        term = term.getTerm();
        Struct struct = this.flagManager.getPrologFlagList();
        return this.unify(term, struct);
    }

    public boolean comma_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        Struct struct = new Struct(",", term, term2);
        this.engineManager.pushSubGoal(ClauseInfo.extractBody(struct));
        return true;
    }

    public boolean $call_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        if (!this.isCallable(term)) {
            throw PrologError.type_error(this.engineManager, 1, "callable", term);
        }
        if ((term = BuiltIn.convertTermToGoal(term)) == null) {
            throw PrologError.type_error(this.engineManager, 1, "callable", term);
        }
        this.engineManager.identify(term);
        this.engineManager.pushSubGoal(ClauseInfo.extractBody(term));
        return true;
    }

    static Term convertTermToGoal(Term term) {
        Struct struct;
        String string;
        if (term instanceof Number) {
            return null;
        }
        if (term instanceof Var && ((Var)term).getLink() instanceof Number) {
            return null;
        }
        if ((term = term.getTerm()) instanceof Var) {
            return new Struct("call", term);
        }
        if (term instanceof Struct && ((string = (struct = (Struct)term).getPredicateIndicator()).equals(";/2") || string.equals(",/2") || string.equals("->/2"))) {
            for (int i = 0; i < struct.getArity(); ++i) {
                Term term2 = struct.getArg(i);
                Term term3 = BuiltIn.convertTermToGoal(term2);
                if (term3 == null) {
                    return null;
                }
                struct.setArg(i, term3);
            }
        }
        return term;
    }

    private boolean isCallable(Term term) {
        return term.isAtom() || term.isCompound();
    }

    private void handleError(Throwable throwable) throws PrologError {
        ArithmeticException arithmeticException;
        if (throwable instanceof ArithmeticException && (arithmeticException = (ArithmeticException)throwable).getMessage().equals("/ by zero")) {
            throw PrologError.evaluation_error(this.engineManager, 2, "zero_divisor");
        }
    }

    public boolean is_2(Term term, Term term2) throws PrologError {
        if (term2.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 2);
        }
        Term term3 = null;
        try {
            term3 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        if (term3 == null) {
            throw PrologError.type_error(this.engineManager, 2, "evaluable", term2.getTerm());
        }
        return this.unify(term.getTerm(), term3);
    }

    public boolean unify_2(Term term, Term term2) {
        return this.unify(term, term2);
    }

    public boolean deunify_2(Term term, Term term2) {
        return !this.unify(term, term2);
    }

    public boolean $tolist_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        if (term instanceof Struct) {
            Struct struct = ((Struct)term).toList();
            return struct != null && this.unify(term2, struct);
        }
        throw PrologError.type_error(this.engineManager, 1, "struct", term);
    }

    public boolean $fromlist_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        if ((term2 = term2.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 2);
        }
        if (!term2.isList()) {
            throw PrologError.type_error(this.engineManager, 2, "list", term2);
        }
        Struct struct = ((Struct)term2).fromList();
        if (struct == null) {
            return false;
        }
        return this.unify(term, struct);
    }

    public boolean copy_term_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        int n = this.engineManager.getEnv().nDemoSteps;
        return this.unify(term2, term.copy(new IdentityHashMap<Var, Var>(), n));
    }

    public boolean $append_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        if ((term2 = term2.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 2);
        }
        if (!term2.isList()) {
            throw PrologError.type_error(this.engineManager, 2, "list", term2);
        }
        ((Struct)term2).append(term);
        return true;
    }

    public boolean $find_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        if (!term2.isList()) {
            throw PrologError.type_error(this.engineManager, 2, "list", term2);
        }
        List<ClauseInfo> list = null;
        try {
            list = this.theoryManager.find(term);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        for (ClauseInfo clauseInfo : list) {
            if (!this.match(term, clauseInfo.getHead())) continue;
            clauseInfo.getClause().resolveTerm();
            ((Struct)term2).append(clauseInfo.getClause());
        }
        return true;
    }

    public boolean set_prolog_flag_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 2);
        }
        if (!term.isAtom() && !(term instanceof Struct)) {
            throw PrologError.type_error(this.engineManager, 1, "struct", term);
        }
        if (!term2.isGround()) {
            throw PrologError.type_error(this.engineManager, 2, "ground", term2);
        }
        String string = term.toString();
        if (this.flagManager.getFlag(string) == null) {
            throw PrologError.domain_error(this.engineManager, 1, "prolog_flag", term);
        }
        if (!this.flagManager.isValidValue(string, term2)) {
            throw PrologError.domain_error(this.engineManager, 2, "flag_value", term2);
        }
        if (!this.flagManager.isModifiable(string)) {
            throw PrologError.permission_error(this.engineManager, "modify", "flag", term, new Int(0));
        }
        return this.flagManager.setFlag(string, term2);
    }

    public boolean get_prolog_flag_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        if (!term.isAtom() && !(term instanceof Struct)) {
            throw PrologError.type_error(this.engineManager, 1, "struct", term);
        }
        String string = term.toString();
        Term term3 = this.flagManager.getFlag(string);
        if (term3 == null) {
            throw PrologError.domain_error(this.engineManager, 1, "prolog_flag", term);
        }
        return this.unify(term3, term2);
    }

    public boolean $op_3(Term term, Term term2, Term term3) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        term3 = term3.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 1);
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 2);
        }
        if (term3 instanceof Var) {
            throw PrologError.instantiation_error(this.engineManager, 3);
        }
        if (!(term instanceof Int)) {
            throw PrologError.type_error(this.engineManager, 1, "integer", term);
        }
        if (!term2.isAtom()) {
            throw PrologError.type_error(this.engineManager, 2, "atom", term2);
        }
        if (!term3.isAtom() && !term3.isList()) {
            throw PrologError.type_error(this.engineManager, 3, "atom_or_atom_list", term3);
        }
        int n = ((Int)term).intValue();
        if (n < 1 || n > 1200) {
            throw PrologError.domain_error(this.engineManager, 1, "operator_priority", term);
        }
        String string = ((Struct)term2).getName();
        if (!(string.equals("fx") || string.equals("fy") || string.equals("xf") || string.equals("yf") || string.equals("xfx") || string.equals("yfx") || string.equals("xfy"))) {
            throw PrologError.domain_error(this.engineManager, 2, "operator_specifier", term2);
        }
        if (term3.isList()) {
            Iterator<? extends Term> iterator = ((Struct)term3).listIterator();
            while (iterator.hasNext()) {
                Struct struct = (Struct)iterator.next();
                this.operatorManager.opNew(struct.getName(), string, n);
            }
        } else {
            this.operatorManager.opNew(((Struct)term3).getName(), string, n);
        }
        return true;
    }

    public void op_3(Term term, Term term2, Term term3) throws PrologError {
        this.$op_3(term, term2, term3);
    }

    public void flag_4(Term term, Term term2, Term term3, Term term4) {
        term = term.getTerm();
        term2 = term2.getTerm();
        term3 = term3.getTerm();
        term4 = term4.getTerm();
        if (term2.isList() && (term4.equals(Term.TRUE) || term4.equals(Term.FALSE))) {
            String string = "";
            this.flagManager.defineFlag(term.toString(), (Struct)term2, term3, term4.equals(Term.TRUE), string);
        }
    }

    public void initialization_1(Term term) {
        if ((term = term.getTerm()) instanceof Struct) {
            this.primitiveManager.identifyPredicate(term);
            this.theoryManager.addStartGoal((Struct)term);
        }
    }

    public void $load_library_1(Term term) throws InvalidLibraryException {
        if ((term = term.getTerm()).isAtom()) {
            this.libraryManager.loadLibrary(((Struct)term).getName());
        }
    }

    public void include_1(Term term) throws FileNotFoundException, InvalidTheoryException, IOException {
        String string = Tools.removeApices((term = term.getTerm()).toString());
        if (!new File(string).isAbsolute()) {
            string = this.engine.getCurrentDirectory() + File.separator + string;
        }
        this.engine.pushDirectoryToList(new File(string).getParent());
        this.engine.addTheory(new Theory(new FileInputStream(string)));
        this.engine.popDirectoryFromList();
    }
}

