/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.FamilyClausesList;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.util.ReadOnlyLinkedList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class ClauseDatabase
extends HashMap<String, FamilyClausesList>
implements Iterable<ClauseInfo> {
    ClauseDatabase() {
    }

    void addFirst(String string, ClauseInfo clauseInfo) {
        FamilyClausesList familyClausesList = (FamilyClausesList)this.get(string);
        if (familyClausesList == null) {
            familyClausesList = new FamilyClausesList();
            this.put(string, familyClausesList);
        }
        familyClausesList.addFirst(clauseInfo);
    }

    void addLast(String string, ClauseInfo clauseInfo) {
        FamilyClausesList familyClausesList = (FamilyClausesList)this.get(string);
        if (familyClausesList == null) {
            familyClausesList = new FamilyClausesList();
            this.put(string, familyClausesList);
        }
        familyClausesList.addLast(clauseInfo);
    }

    FamilyClausesList abolish(String string) {
        return (FamilyClausesList)this.remove(string);
    }

    List<ClauseInfo> getPredicates(Term term) {
        FamilyClausesList familyClausesList = (FamilyClausesList)this.get(((Struct)term).getPredicateIndicator());
        if (familyClausesList == null) {
            return new ReadOnlyLinkedList<ClauseInfo>();
        }
        return familyClausesList.get(term);
    }

    List<ClauseInfo> getPredicates(String string) {
        FamilyClausesList familyClausesList = (FamilyClausesList)this.get(string);
        if (familyClausesList == null) {
            return new ReadOnlyLinkedList<ClauseInfo>();
        }
        return new ReadOnlyLinkedList<ClauseInfo>(familyClausesList);
    }

    @Override
    public Iterator<ClauseInfo> iterator() {
        return new CompleteIterator(this);
    }

    private static class CompleteIterator
    implements Iterator<ClauseInfo> {
        Iterator<FamilyClausesList> values;
        Iterator<ClauseInfo> workingList;

        public CompleteIterator(ClauseDatabase clauseDatabase) {
            this.values = clauseDatabase.values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.workingList != null && this.workingList.hasNext()) {
                return true;
            }
            if (this.values.hasNext()) {
                this.workingList = this.values.next().iterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public synchronized ClauseInfo next() {
            if (this.workingList.hasNext()) {
                return this.workingList.next();
            }
            return null;
        }

        @Override
        public void remove() {
            this.workingList.remove();
        }
    }
}

