/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.OneWayList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ClauseStore {
    private OneWayList<ClauseInfo> clauses;
    private Term goal;
    private List<Var> vars;
    private boolean haveAlternatives;

    private ClauseStore(Term term, List<Var> list) {
        this.goal = term;
        this.vars = list;
        this.clauses = null;
    }

    public static ClauseStore build(Term term, List<Var> list, List<ClauseInfo> list2) {
        ClauseStore clauseStore = new ClauseStore(term, list);
        clauseStore.clauses = OneWayList.transform2(list2);
        if (clauseStore.clauses == null || !clauseStore.existCompatibleClause()) {
            return null;
        }
        return clauseStore;
    }

    public ClauseInfo fetch() {
        if (this.clauses == null) {
            return null;
        }
        this.deunify(this.vars);
        if (!this.checkCompatibility(this.goal)) {
            return null;
        }
        ClauseInfo clauseInfo = this.clauses.getHead();
        this.clauses = this.clauses.getTail();
        this.haveAlternatives = this.checkCompatibility(this.goal);
        return clauseInfo;
    }

    public boolean haveAlternatives() {
        return this.haveAlternatives;
    }

    protected boolean existCompatibleClause() {
        List<Term> list = this.deunify(this.vars);
        boolean bl = this.checkCompatibility(this.goal);
        this.reunify(this.vars, list);
        return bl;
    }

    private List<Term> deunify(List<Var> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Var var : list) {
            arrayList.add(var.getLink());
            var.free();
        }
        return arrayList;
    }

    private void reunify(List<Var> list, List<Term> list2) {
        int n = list.size();
        ListIterator<Var> listIterator = list.listIterator(n);
        ListIterator<Term> listIterator2 = list2.listIterator(n);
        while (listIterator.hasPrevious()) {
            listIterator.previous().setLink(listIterator2.previous());
        }
    }

    private boolean checkCompatibility(Term term) {
        if (this.clauses == null) {
            return false;
        }
        ClauseInfo clauseInfo = null;
        do {
            if (term.match((clauseInfo = this.clauses.getHead()).getHead())) {
                return true;
            }
            this.clauses = this.clauses.getTail();
        } while (this.clauses != null);
        return false;
    }

    public String toString() {
        return "clauses: " + this.clauses + "\n" + "goal: " + this.goal + "\n" + "vars: " + this.vars + "\n";
    }

    public List<ClauseInfo> getClauses() {
        ArrayList<ClauseInfo> arrayList = new ArrayList<ClauseInfo>();
        for (OneWayList<ClauseInfo> oneWayList = this.clauses; oneWayList != null; oneWayList = oneWayList.getTail()) {
            arrayList.add(oneWayList.getHead());
        }
        return arrayList;
    }

    public Term getMatchGoal() {
        return this.goal;
    }

    public List<Var> getVarsForMatch() {
        return this.vars;
    }
}

