/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.OneWayList;
import java.util.List;

class ClausesFilter {
    public static boolean OPTIMIZATION_ENABLED = true;

    ClausesFilter() {
    }

    public static OneWayList<ClauseInfo> filterClauses(List<ClauseInfo> list, Term term) {
        if (OPTIMIZATION_ENABLED && term instanceof Struct) {
            Struct struct = (Struct)term.getTerm();
            if (struct.getArity() < 2) {
                return ClausesFilter.returnAllClauses(list);
            }
            Term term2 = struct.getArg(1).getTerm();
            if (term2 instanceof Var) {
                return ClausesFilter.returnAllClauses(list);
            }
            if (term2.isAtomic()) {
                if (term2 instanceof Number) {
                    return ClausesFilter.selectNumeric(list, (Number)term2);
                }
                return ClausesFilter.selectConstant(list, term2);
            }
            if (term2 instanceof Struct) {
                if (ClausesFilter.isAList(term2)) {
                    return ClausesFilter.selectList(list);
                }
                return ClausesFilter.selectStruct(list, ((Struct)term2).getPredicateIndicator());
            }
        }
        return ClausesFilter.returnAllClauses(list);
    }

    private static OneWayList<ClauseInfo> returnAllClauses(List<ClauseInfo> list) {
        return OneWayList.transform2(list);
    }

    private static OneWayList<ClauseInfo> selectNumeric(List<ClauseInfo> list, Number number) {
        OneWayList<ClauseInfo> oneWayList = null;
        OneWayList<ClauseInfo> oneWayList2 = null;
        for (ClauseInfo clauseInfo : list) {
            ClauseInfo clauseInfo2 = clauseInfo;
            Term term = clauseInfo2.getHead().getArg(0).getTerm();
            if (!(term instanceof Var) && (!(term instanceof Number) || !((Number)term).isEqual(number))) continue;
            OneWayList<ClauseInfo> oneWayList3 = new OneWayList<ClauseInfo>(clauseInfo2, null);
            if (oneWayList == null) {
                oneWayList = oneWayList2 = oneWayList3;
                continue;
            }
            oneWayList2.setTail(oneWayList3);
            oneWayList2 = oneWayList3;
        }
        return oneWayList;
    }

    private static OneWayList<ClauseInfo> selectStruct(List<ClauseInfo> list, String string) {
        OneWayList<ClauseInfo> oneWayList = null;
        OneWayList<ClauseInfo> oneWayList2 = null;
        for (ClauseInfo clauseInfo : list) {
            ClauseInfo clauseInfo2 = clauseInfo;
            Term term = clauseInfo2.getHead().getArg(0).getTerm();
            if (!(term instanceof Var) && !((Struct)term).getPredicateIndicator().equals(string)) continue;
            OneWayList<ClauseInfo> oneWayList3 = new OneWayList<ClauseInfo>(clauseInfo2, null);
            if (oneWayList == null) {
                oneWayList = oneWayList2 = oneWayList3;
                continue;
            }
            oneWayList2.setTail(oneWayList3);
            oneWayList2 = oneWayList3;
        }
        return oneWayList;
    }

    private static boolean isAList(Term term) {
        if (term instanceof Struct) {
            Struct struct = (Struct)term;
            return struct.isEmptyList() || struct.getName().equals(".") && struct.getArity() == 2;
        }
        return false;
    }

    private static OneWayList<ClauseInfo> selectList(List<ClauseInfo> list) {
        OneWayList<ClauseInfo> oneWayList = null;
        OneWayList<ClauseInfo> oneWayList2 = null;
        for (ClauseInfo clauseInfo : list) {
            ClauseInfo clauseInfo2 = clauseInfo;
            Term term = clauseInfo2.getHead().getArg(0).getTerm();
            if (!(term instanceof Var) && !ClausesFilter.isAList(term)) continue;
            OneWayList<ClauseInfo> oneWayList3 = new OneWayList<ClauseInfo>(clauseInfo2, null);
            if (oneWayList == null) {
                oneWayList = oneWayList2 = oneWayList3;
                continue;
            }
            oneWayList2.setTail(oneWayList3);
            oneWayList2 = oneWayList3;
        }
        return oneWayList;
    }

    private static OneWayList<ClauseInfo> selectConstant(List<ClauseInfo> list, Term term) {
        OneWayList<ClauseInfo> oneWayList = null;
        OneWayList<ClauseInfo> oneWayList2 = null;
        for (ClauseInfo clauseInfo : list) {
            ClauseInfo clauseInfo2 = clauseInfo;
            Term term2 = clauseInfo2.getHead().getArg(0).getTerm();
            if (!(term2 instanceof Var) && !term2.isAtomic()) continue;
            OneWayList<ClauseInfo> oneWayList3 = new OneWayList<ClauseInfo>(clauseInfo2, null);
            if (oneWayList == null) {
                oneWayList = oneWayList2 = oneWayList3;
                continue;
            }
            oneWayList2.setTail(oneWayList3);
            oneWayList2 = oneWayList3;
        }
        return oneWayList;
    }
}

