/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.AbstractSocket;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;

public class Client_Socket
extends AbstractSocket {
    private Socket socket;

    public Client_Socket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public boolean isClientSocket() {
        return true;
    }

    @Override
    public boolean isServerSocket() {
        return false;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    boolean unify(List<Var> list, List<Var> list2, Term term) {
        if ((term = term.getTerm()) instanceof Var) {
            return term.unify(list, list2, this);
        }
        if (term instanceof AbstractSocket && ((AbstractSocket)term).isServerSocket()) {
            InetAddress inetAddress = ((AbstractSocket)term).getAddress();
            return this.socket.getInetAddress().toString().equals(inetAddress.toString());
        }
        return false;
    }

    @Override
    public InetAddress getAddress() {
        if (this.socket.isBound()) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    @Override
    public boolean isDatagramSocket() {
        return false;
    }

    public String toString() {
        return this.socket.toString();
    }
}

