/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import java.util.List;

public class Double
extends Number {
    private double value;

    public Double(double d) {
        this.value = d;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final float floatValue() {
        return (float)this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return (long)this.value;
    }

    @Override
    public final boolean isInteger() {
        return false;
    }

    @Override
    public final boolean isReal() {
        return true;
    }

    @Override
    public final boolean isTypeInt() {
        return false;
    }

    @Override
    public final boolean isInt() {
        return false;
    }

    @Override
    public final boolean isTypeFloat() {
        return false;
    }

    @Override
    public final boolean isFloat() {
        return false;
    }

    @Override
    public final boolean isTypeDouble() {
        return true;
    }

    @Override
    public final boolean isDouble() {
        return true;
    }

    @Override
    public final boolean isTypeLong() {
        return false;
    }

    @Override
    public final boolean isLong() {
        return false;
    }

    @Override
    public boolean isGreater(Term term) {
        if ((term = term.getTerm()) instanceof Number) {
            return this.value > ((Number)term).doubleValue();
        }
        if (term instanceof Struct) {
            return false;
        }
        return term instanceof Var;
    }

    @Override
    public boolean isEqual(Term term) {
        if ((term = term.getTerm()) instanceof Number) {
            Number number = (Number)term;
            if (!number.isReal()) {
                return false;
            }
            return this.value == number.doubleValue();
        }
        return false;
    }

    @Override
    boolean unify(List<Var> list, List<Var> list2, Term term) {
        if ((term = term.getTerm()) instanceof Var) {
            return term.unify(list2, list, this);
        }
        if (term instanceof Number && ((Number)term).isReal()) {
            return this.value == ((Number)term).doubleValue();
        }
        return false;
    }

    public String toString() {
        return java.lang.Double.toString(this.value);
    }

    public int resolveVariables(int n) {
        return n;
    }

    @Override
    public int compareTo(Number number) {
        return new java.lang.Double(this.value).compareTo(number.doubleValue());
    }
}

