/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ChoicePointContext;
import alice.tuprolog.ChoicePointStore;
import alice.tuprolog.EngineRunner;
import alice.tuprolog.ExecutionContext;
import alice.tuprolog.State;
import alice.tuprolog.StateEnd;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.tuprolog.interfaces.IEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class Engine
implements IEngine {
    State nextState;
    Term query;
    Struct startGoal;
    Collection<Var> goalVars;
    int nDemoSteps;
    ExecutionContext currentContext;
    ChoicePointContext currentAlternative;
    ChoicePointStore choicePointSelector;
    boolean mustStop;
    EngineRunner manager;

    public Engine(EngineRunner engineRunner, Term term) {
        this.manager = engineRunner;
        this.nextState = engineRunner.INIT;
        this.query = term;
        this.mustStop = false;
    }

    public String toString() {
        try {
            return "ExecutionStack: \n" + this.currentContext + "\n" + "ChoicePointStore: \n" + this.choicePointSelector + "\n\n";
        }
        catch (Exception exception) {
            return "";
        }
    }

    void mustStop() {
        this.mustStop = true;
    }

    StateEnd run() {
        do {
            if (this.mustStop) {
                this.nextState = this.manager.END_FALSE;
                break;
            }
            String string = this.nextState.toString();
            this.nextState.doJob(this);
            this.manager.spy(string, this);
        } while (!(this.nextState instanceof StateEnd));
        this.nextState.doJob(this);
        return (StateEnd)this.nextState;
    }

    public Term getQuery() {
        return this.query;
    }

    public int getNumDemoSteps() {
        return this.nDemoSteps;
    }

    public List<ExecutionContext> getExecutionStack() {
        ArrayList<ExecutionContext> arrayList = new ArrayList<ExecutionContext>();
        ExecutionContext executionContext = this.currentContext;
        while (executionContext != null) {
            arrayList.add(executionContext);
            executionContext = executionContext.fatherCtx;
        }
        return arrayList;
    }

    public ChoicePointStore getChoicePointStore() {
        return this.choicePointSelector;
    }

    void prepareGoal() {
        LinkedHashMap<Var, Var> linkedHashMap = new LinkedHashMap<Var, Var>();
        this.startGoal = (Struct)this.query.copyGoal(linkedHashMap, 0);
        this.goalVars = linkedHashMap.values();
    }

    void initialize(ExecutionContext executionContext) {
        this.currentContext = executionContext;
        this.choicePointSelector = new ChoicePointStore();
        this.nDemoSteps = 1;
        this.currentAlternative = null;
    }

    public String getNextStateName() {
        return this.nextState.stateName;
    }
}

