/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Engine;
import alice.tuprolog.EngineRunner;
import alice.tuprolog.ExecutionContext;
import alice.tuprolog.Int;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.SubGoalTree;
import alice.tuprolog.Term;
import alice.tuprolog.TermQueue;
import alice.tuprolog.Var;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class EngineManager
implements Serializable {
    private Prolog vm;
    private Hashtable<Integer, EngineRunner> runners;
    private Hashtable<Integer, Integer> threads;
    private int rootID = 0;
    private EngineRunner er1;
    private int id = 0;
    private Hashtable<String, TermQueue> queues;
    private Hashtable<String, ReentrantLock> locks;

    public void initialize(Prolog prolog) {
        this.vm = prolog;
        this.runners = new Hashtable();
        this.threads = new Hashtable();
        this.queues = new Hashtable();
        this.locks = new Hashtable();
        this.er1 = new EngineRunner(this.rootID);
        this.er1.initialize(prolog);
    }

    public synchronized boolean threadCreate(Term term, Term term2) {
        ++this.id;
        if (term2 == null) {
            return false;
        }
        if (term2 instanceof Var) {
            term2 = term2.getTerm();
        }
        EngineRunner engineRunner = new EngineRunner(this.id);
        engineRunner.initialize(this.vm);
        if (!this.vm.unify(term, new Int(this.id))) {
            return false;
        }
        engineRunner.setGoal(term2);
        this.addRunner(engineRunner, this.id);
        Thread thread = new Thread(engineRunner);
        this.addThread(thread.getId(), this.id);
        thread.start();
        return true;
    }

    public SolveInfo join(int n) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null || engineRunner.isDetached()) {
            return null;
        }
        SolveInfo solveInfo = engineRunner.read();
        this.removeRunner(n);
        return solveInfo;
    }

    public SolveInfo read(int n) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null || engineRunner.isDetached()) {
            return null;
        }
        SolveInfo solveInfo = engineRunner.read();
        return solveInfo;
    }

    public boolean hasNext(int n) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null || engineRunner.isDetached()) {
            return false;
        }
        return engineRunner.hasOpenAlternatives();
    }

    public boolean nextSolution(int n) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null || engineRunner.isDetached()) {
            return false;
        }
        boolean bl = engineRunner.nextSolution();
        return bl;
    }

    public void detach(int n) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null) {
            return;
        }
        engineRunner.detach();
    }

    public boolean sendMsg(int n, Term term) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null) {
            return false;
        }
        Term term2 = term.copy(new LinkedHashMap<Var, Var>(), 0);
        engineRunner.sendMsg(term2);
        return true;
    }

    public boolean sendMsg(String string, Term term) {
        TermQueue termQueue = this.queues.get(string);
        if (termQueue == null) {
            return false;
        }
        Term term2 = term.copy(new LinkedHashMap<Var, Var>(), 0);
        termQueue.store(term2);
        return true;
    }

    public boolean getMsg(int n, Term term) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null) {
            return false;
        }
        return engineRunner.getMsg(term);
    }

    public boolean getMsg(String string, Term term) {
        EngineRunner engineRunner = this.findRunner();
        if (engineRunner == null) {
            return false;
        }
        TermQueue termQueue = this.queues.get(string);
        if (termQueue == null) {
            return false;
        }
        return termQueue.get(term, this.vm, engineRunner);
    }

    public boolean waitMsg(int n, Term term) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null) {
            return false;
        }
        return engineRunner.waitMsg(term);
    }

    public boolean waitMsg(String string, Term term) {
        EngineRunner engineRunner = this.findRunner();
        if (engineRunner == null) {
            return false;
        }
        TermQueue termQueue = this.queues.get(string);
        if (termQueue == null) {
            return false;
        }
        return termQueue.wait(term, this.vm, engineRunner);
    }

    public boolean peekMsg(int n, Term term) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null) {
            return false;
        }
        return engineRunner.peekMsg(term);
    }

    public boolean peekMsg(String string, Term term) {
        TermQueue termQueue = this.queues.get(string);
        if (termQueue == null) {
            return false;
        }
        return termQueue.peek(term, this.vm);
    }

    public boolean removeMsg(int n, Term term) {
        EngineRunner engineRunner = this.findRunner(n);
        if (engineRunner == null) {
            return false;
        }
        return engineRunner.removeMsg(term);
    }

    public boolean removeMsg(String string, Term term) {
        TermQueue termQueue = this.queues.get(string);
        if (termQueue == null) {
            return false;
        }
        return termQueue.remove(term, this.vm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRunner(int n) {
        EngineRunner engineRunner = this.runners.get(n);
        if (engineRunner == null) {
            return;
        }
        Hashtable<Integer, EngineRunner> hashtable = this.runners;
        synchronized (hashtable) {
            this.runners.remove(n);
        }
        int n2 = engineRunner.getPid();
        Hashtable<Integer, Integer> hashtable2 = this.threads;
        synchronized (hashtable2) {
            this.threads.remove(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunner(EngineRunner engineRunner, int n) {
        Hashtable<Integer, EngineRunner> hashtable = this.runners;
        synchronized (hashtable) {
            this.runners.put(n, engineRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThread(long l, int n) {
        Hashtable<Integer, Integer> hashtable = this.threads;
        synchronized (hashtable) {
            this.threads.put((int)l, n);
        }
    }

    void cut() {
        this.findRunner().cut();
    }

    ExecutionContext getCurrentContext() {
        EngineRunner engineRunner = this.findRunner();
        return engineRunner.getCurrentContext();
    }

    boolean hasOpenAlternatives() {
        EngineRunner engineRunner = this.findRunner();
        return engineRunner.hasOpenAlternatives();
    }

    boolean isHalted() {
        EngineRunner engineRunner = this.findRunner();
        return engineRunner.isHalted();
    }

    void pushSubGoal(SubGoalTree subGoalTree) {
        EngineRunner engineRunner = this.findRunner();
        engineRunner.pushSubGoal(subGoalTree);
    }

    public synchronized SolveInfo solve(Term term) {
        this.er1.setGoal(term);
        return this.er1.solve();
    }

    public void solveEnd() {
        this.er1.solveEnd();
        if (this.runners.size() != 0) {
            Enumeration<EngineRunner> enumeration = this.runners.elements();
            while (enumeration.hasMoreElements()) {
                EngineRunner engineRunner = enumeration.nextElement();
                engineRunner.solveEnd();
            }
            this.runners = new Hashtable();
            this.threads = new Hashtable();
            this.queues = new Hashtable();
            this.locks = new Hashtable();
            this.id = 0;
        }
    }

    public void solveHalt() {
        this.er1.solveHalt();
        if (this.runners.size() != 0) {
            Enumeration<EngineRunner> enumeration = this.runners.elements();
            while (enumeration.hasMoreElements()) {
                EngineRunner engineRunner = enumeration.nextElement();
                engineRunner.solveHalt();
            }
        }
    }

    public synchronized SolveInfo solveNext() throws NoMoreSolutionException {
        return this.er1.solveNext();
    }

    void spy(String string, Engine engine) {
        EngineRunner engineRunner = this.findRunner();
        engineRunner.spy(string, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineRunner findRunner(int n) {
        if (!this.runners.containsKey(n)) {
            return null;
        }
        Hashtable<Integer, EngineRunner> hashtable = this.runners;
        synchronized (hashtable) {
            return this.runners.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineRunner findRunner() {
        int n = (int)Thread.currentThread().getId();
        if (!this.threads.containsKey(n)) {
            return this.er1;
        }
        Hashtable<Integer, Integer> hashtable = this.threads;
        synchronized (hashtable) {
            Hashtable<Integer, EngineRunner> hashtable2 = this.runners;
            synchronized (hashtable2) {
                int n2 = this.threads.get(n);
                return this.runners.get(n2);
            }
        }
    }

    public int runnerId() {
        EngineRunner engineRunner = this.findRunner();
        return engineRunner.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createQueue(String string) {
        Hashtable<String, TermQueue> hashtable = this.queues;
        synchronized (hashtable) {
            if (this.queues.containsKey(string)) {
                return true;
            }
            TermQueue termQueue = new TermQueue();
            this.queues.put(string, termQueue);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyQueue(String string) {
        Hashtable<String, TermQueue> hashtable = this.queues;
        synchronized (hashtable) {
            this.queues.remove(string);
        }
    }

    public int queueSize(int n) {
        EngineRunner engineRunner = this.findRunner(n);
        return engineRunner.msgQSize();
    }

    public int queueSize(String string) {
        TermQueue termQueue = this.queues.get(string);
        if (termQueue == null) {
            return -1;
        }
        return termQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createLock(String string) {
        Hashtable<String, ReentrantLock> hashtable = this.locks;
        synchronized (hashtable) {
            if (this.locks.containsKey(string)) {
                return true;
            }
            ReentrantLock reentrantLock = new ReentrantLock();
            this.locks.put(string, reentrantLock);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyLock(String string) {
        Hashtable<String, ReentrantLock> hashtable = this.locks;
        synchronized (hashtable) {
            this.locks.remove(string);
        }
    }

    public boolean mutexLock(String string) {
        ReentrantLock reentrantLock = this.locks.get(string);
        if (reentrantLock == null) {
            this.createLock(string);
            return this.mutexLock(string);
        }
        reentrantLock.lock();
        return true;
    }

    public boolean mutexTryLock(String string) {
        ReentrantLock reentrantLock = this.locks.get(string);
        if (reentrantLock == null) {
            return false;
        }
        return reentrantLock.tryLock();
    }

    public boolean mutexUnlock(String string) {
        ReentrantLock reentrantLock = this.locks.get(string);
        if (reentrantLock == null) {
            return false;
        }
        try {
            reentrantLock.unlock();
            return true;
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            return false;
        }
    }

    public boolean isLocked(String string) {
        ReentrantLock reentrantLock = this.locks.get(string);
        if (reentrantLock == null) {
            return false;
        }
        return reentrantLock.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll() {
        Hashtable<String, ReentrantLock> hashtable = this.locks;
        synchronized (hashtable) {
            Set<String> set = this.locks.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                ReentrantLock reentrantLock = this.locks.get(iterator.next());
                boolean bl = false;
                while (!bl) {
                    try {
                        reentrantLock.unlock();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        bl = true;
                    }
                }
            }
        }
    }

    Engine getEnv() {
        EngineRunner engineRunner = this.findRunner();
        return engineRunner.env;
    }

    public void identify(Term term) {
        EngineRunner engineRunner = this.findRunner();
        engineRunner.identify(term);
    }
}

