/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.Engine;
import alice.tuprolog.ExecutionContext;
import alice.tuprolog.LibraryManager;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.State;
import alice.tuprolog.StateBacktrack;
import alice.tuprolog.StateEnd;
import alice.tuprolog.StateException;
import alice.tuprolog.StateGoalEvaluation;
import alice.tuprolog.StateGoalSelection;
import alice.tuprolog.StateInit;
import alice.tuprolog.StateRuleSelection;
import alice.tuprolog.SubGoalTree;
import alice.tuprolog.Term;
import alice.tuprolog.TermQueue;
import alice.tuprolog.TheoryManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EngineRunner
implements Serializable,
Runnable {
    private Prolog mediator;
    private TheoryManager theoryManager;
    private PrimitiveManager primitiveManager;
    private LibraryManager libraryManager;
    private int id;
    private int pid;
    private boolean detached;
    private boolean solving;
    private Term query;
    private TermQueue msgs;
    private ArrayList<Boolean> next;
    private int countNext;
    private Lock lockVar;
    private Condition cond;
    private Object semaphore;
    Engine env;
    private Engine last_env;
    private LinkedList<Engine> stackEnv = new LinkedList();
    private SolveInfo sinfo;
    final State INIT = new StateInit(this);
    final State GOAL_EVALUATION = new StateGoalEvaluation(this);
    final State EXCEPTION = new StateException(this);
    final State RULE_SELECTION = new StateRuleSelection(this);
    final State GOAL_SELECTION = new StateGoalSelection(this);
    final State BACKTRACK = new StateBacktrack(this);
    final State END_FALSE = new StateEnd(this, 0);
    final State END_TRUE = new StateEnd(this, 1);
    final State END_TRUE_CP = new StateEnd(this, 2);
    final State END_HALT = new StateEnd(this, -1);
    public static final int HALT = -1;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int TRUE_CP = 2;

    public EngineRunner(int n) {
        this.id = n;
    }

    void initialize(Prolog prolog) {
        this.mediator = prolog;
        this.theoryManager = prolog.getTheoryManager();
        this.primitiveManager = prolog.getPrimitiveManager();
        this.libraryManager = prolog.getLibraryManager();
        this.detached = false;
        this.solving = false;
        this.sinfo = null;
        this.msgs = new TermQueue();
        this.next = new ArrayList();
        this.countNext = 0;
        this.lockVar = new ReentrantLock();
        this.cond = this.lockVar.newCondition();
        this.semaphore = new Object();
    }

    void spy(String string, Engine engine) {
        this.mediator.spy(string, engine);
    }

    void warn(String string) {
        this.mediator.warn(string);
    }

    void exception(String string) {
        this.mediator.exception(string);
    }

    public void detach() {
        this.detached = true;
    }

    public boolean isDetached() {
        return this.detached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadSolve() {
        this.sinfo = this.solve();
        this.solving = false;
        this.lockVar.lock();
        try {
            this.cond.signalAll();
        }
        finally {
            this.lockVar.unlock();
        }
        if (this.sinfo.hasOpenAlternatives() && (this.next.isEmpty() || !this.next.get(this.countNext).booleanValue())) {
            Object object = this.semaphore;
            synchronized (object) {
                try {
                    this.semaphore.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public SolveInfo solve() {
        try {
            this.query.resolveTerm();
            this.libraryManager.onSolveBegin(this.query);
            this.primitiveManager.identifyPredicate(this.query);
            this.freeze();
            this.env = new Engine(this, this.query);
            StateEnd stateEnd = this.env.run();
            this.defreeze();
            this.sinfo = new SolveInfo(this.query, stateEnd.getResultGoal(), stateEnd.getResultDemo(), stateEnd.getResultVars());
            if (!this.sinfo.hasOpenAlternatives()) {
                this.solveEnd();
            }
            return this.sinfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SolveInfo(this.query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadSolveNext() throws NoMoreSolutionException {
        this.solving = true;
        this.next.set(this.countNext, false);
        ++this.countNext;
        this.sinfo = this.solveNext();
        this.solving = false;
        this.lockVar.lock();
        try {
            this.cond.signalAll();
        }
        finally {
            this.lockVar.unlock();
        }
        if (this.sinfo.hasOpenAlternatives() && (this.countNext > this.next.size() - 1 || !this.next.get(this.countNext).booleanValue())) {
            try {
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public SolveInfo solveNext() throws NoMoreSolutionException {
        if (this.hasOpenAlternatives()) {
            this.refreeze();
            this.env.nextState = this.BACKTRACK;
            StateEnd stateEnd = this.env.run();
            this.defreeze();
            this.sinfo = new SolveInfo(this.env.query, stateEnd.getResultGoal(), stateEnd.getResultDemo(), stateEnd.getResultVars());
            if (!this.sinfo.hasOpenAlternatives()) {
                this.solveEnd();
            }
            return this.sinfo;
        }
        throw new NoMoreSolutionException();
    }

    public void solveHalt() {
        this.env.mustStop();
        this.libraryManager.onSolveHalt();
    }

    public void solveEnd() {
        this.libraryManager.onSolveEnd();
    }

    private void freeze() {
        if (this.env == null) {
            return;
        }
        try {
            if (this.stackEnv.getLast() == this.env) {
                return;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.stackEnv.addLast(this.env);
    }

    private void refreeze() {
        this.freeze();
        this.env = this.last_env;
    }

    private void defreeze() {
        this.last_env = this.env;
        if (this.stackEnv.isEmpty()) {
            return;
        }
        this.env = this.stackEnv.removeLast();
    }

    List<ClauseInfo> find(Term term) {
        return this.theoryManager.find(term);
    }

    void identify(Term term) {
        this.primitiveManager.identifyPredicate(term);
    }

    void pushSubGoal(SubGoalTree subGoalTree) {
        this.env.currentContext.goalsToEval.pushSubGoal(subGoalTree);
    }

    void cut() {
        this.env.choicePointSelector.cut(this.env.currentContext.choicePointAfterCut);
    }

    ExecutionContext getCurrentContext() {
        return this.env == null ? null : this.env.currentContext;
    }

    boolean hasOpenAlternatives() {
        if (this.sinfo == null) {
            return false;
        }
        return this.sinfo.hasOpenAlternatives();
    }

    boolean isHalted() {
        if (this.sinfo == null) {
            return false;
        }
        return this.sinfo.isHalted();
    }

    @Override
    public void run() {
        this.solving = true;
        this.pid = (int)Thread.currentThread().getId();
        if (this.sinfo == null) {
            this.threadSolve();
        }
        try {
            while (this.hasOpenAlternatives()) {
                if (!this.next.get(this.countNext).booleanValue()) continue;
                this.threadSolveNext();
            }
        }
        catch (NoMoreSolutionException noMoreSolutionException) {
            noMoreSolutionException.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }

    public int getPid() {
        return this.pid;
    }

    public SolveInfo getSolution() {
        return this.sinfo;
    }

    public void setGoal(Term term) {
        this.query = term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextSolution() {
        this.solving = true;
        this.next.add(true);
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolveInfo read() {
        this.lockVar.lock();
        try {
            while (this.solving || this.sinfo == null) {
                try {
                    this.cond.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        finally {
            this.lockVar.unlock();
        }
        return this.sinfo;
    }

    public void setSolving(boolean bl) {
        this.solving = bl;
    }

    public void sendMsg(Term term) {
        this.msgs.store(term);
    }

    public boolean getMsg(Term term) {
        this.msgs.get(term, this.mediator, this);
        return true;
    }

    public boolean peekMsg(Term term) {
        return this.msgs.peek(term, this.mediator);
    }

    public boolean removeMsg(Term term) {
        return this.msgs.remove(term, this.mediator);
    }

    public boolean waitMsg(Term term) {
        this.msgs.wait(term, this.mediator, this);
        return true;
    }

    public int msgQSize() {
        return this.msgs.size();
    }
}

