/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ChoicePointContext;
import alice.tuprolog.Engine;
import alice.tuprolog.Struct;
import alice.tuprolog.SubGoalId;
import alice.tuprolog.SubGoalStore;
import alice.tuprolog.Var;
import alice.util.OneWayList;
import java.util.ArrayList;
import java.util.List;

public class ExecutionContext {
    private int id;
    int depth;
    Struct currentGoal;
    ExecutionContext fatherCtx;
    SubGoalId fatherGoalId;
    Struct clause;
    Struct headClause;
    SubGoalStore goalsToEval;
    OneWayList<List<Var>> trailingVars;
    OneWayList<List<Var>> fatherVarsList;
    ChoicePointContext choicePointAfterCut;
    boolean haveAlternatives;

    ExecutionContext(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "         id: " + this.id + "\n" + "     currentGoal:  " + this.currentGoal + "\n" + "     clause:       " + this.clause + "\n" + "     subGoalStore: " + this.goalsToEval + "\n" + "     trailingVars: " + this.trailingVars + "\n" + "";
    }

    public int getDepth() {
        return this.depth;
    }

    public Struct getCurrentGoal() {
        return this.currentGoal;
    }

    public SubGoalId getFatherGoalId() {
        return this.fatherGoalId;
    }

    public Struct getClause() {
        return this.clause;
    }

    public Struct getHeadClause() {
        return this.headClause;
    }

    public SubGoalStore getSubGoalStore() {
        return this.goalsToEval;
    }

    public List<List<Var>> getTrailingVars() {
        ArrayList<List<Var>> arrayList = new ArrayList<List<Var>>();
        for (OneWayList<List<Var>> oneWayList = this.trailingVars; oneWayList != null; oneWayList = oneWayList.getTail()) {
            arrayList.add(oneWayList.getHead());
        }
        return arrayList;
    }

    void saveParentState() {
        if (this.fatherCtx != null) {
            this.fatherGoalId = this.fatherCtx.goalsToEval.getCurrentGoalId();
            this.fatherVarsList = this.fatherCtx.trailingVars;
        }
    }

    void performTailRecursionOptimization(Engine engine) {
        if (!(this.haveAlternatives || engine.currentContext.goalsToEval.haveSubGoals() || engine.currentContext.currentGoal.getName().equalsIgnoreCase("catch") || engine.currentContext.currentGoal.getName().equalsIgnoreCase("java_catch"))) {
            this.fatherCtx = engine.currentContext.fatherCtx;
            this.depth = engine.currentContext.depth;
        } else {
            this.fatherCtx = engine.currentContext;
            this.depth = engine.currentContext.depth + 1;
        }
    }
}

