/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.Color;
import alice.tuprolog.Node;
import alice.tuprolog.RBTree;
import java.util.LinkedList;

class FamilyClausesIndex<K extends Comparable<? super K>>
extends RBTree<K, LinkedList<ClauseInfo>> {
    private LinkedList<ClauseInfo> varsClauses = new LinkedList();

    private Node<K, LinkedList<ClauseInfo>> createNewNode(K k, ClauseInfo clauseInfo, boolean bl) {
        LinkedList<ClauseInfo> linkedList = new LinkedList<ClauseInfo>(this.varsClauses);
        if (bl) {
            linkedList.addFirst(clauseInfo);
        } else {
            linkedList.addLast(clauseInfo);
        }
        return new Node<K, LinkedList<ClauseInfo>>(k, linkedList, Color.RED, null, null);
    }

    @Override
    public void insert(K k, LinkedList<ClauseInfo> linkedList) {
        super.insert(k, linkedList);
    }

    public void insertAsShared(ClauseInfo clauseInfo, boolean bl) {
        if (bl) {
            this.varsClauses.addFirst(clauseInfo);
        } else {
            this.varsClauses.addLast(clauseInfo);
        }
        if (this.root != null) {
            LinkedList linkedList = new LinkedList();
            linkedList.add(this.root);
            while (linkedList.size() > 0) {
                Node node = (Node)linkedList.remove();
                if (bl) {
                    ((LinkedList)node.value).addFirst(clauseInfo);
                } else {
                    ((LinkedList)node.value).addLast(clauseInfo);
                }
                if (node.left != null) {
                    linkedList.addLast(node.left);
                }
                if (node.right == null) continue;
                linkedList.addLast(node.right);
            }
        }
    }

    public void insert(K k, ClauseInfo clauseInfo, boolean bl) {
        Node<K, LinkedList<ClauseInfo>> node = null;
        if (this.root == null) {
            node = this.root = this.createNewNode(k, clauseInfo, bl);
        } else {
            Node node2 = this.root;
            while (true) {
                int n;
                if ((n = k.compareTo(node2.key)) == 0) {
                    if (bl) {
                        ((LinkedList)node2.value).addFirst(clauseInfo);
                    } else {
                        ((LinkedList)node2.value).addLast(clauseInfo);
                    }
                    return;
                }
                if (n < 0) {
                    if (node2.left == null) {
                        node2.left = this.createNewNode(k, clauseInfo, bl);
                        node = node2.left;
                        break;
                    }
                    node2 = node2.left;
                    continue;
                }
                assert (n > 0);
                if (node2.right == null) {
                    node2.right = this.createNewNode(k, clauseInfo, bl);
                    node = node2.right;
                    break;
                }
                node2 = node2.right;
            }
            node.parent = node2;
        }
        this.insertCase1(node);
        this.verifyProperties();
    }

    public void remove(K k) {
        super.delete(k);
    }

    public void removeShared(ClauseInfo clauseInfo) {
        if (this.varsClauses.remove(clauseInfo)) {
            if (this.root != null && this.root != null) {
                LinkedList linkedList = new LinkedList();
                linkedList.add(this.root);
                while (linkedList.size() > 0) {
                    Node node = (Node)linkedList.remove();
                    ((LinkedList)node.value).remove(clauseInfo);
                    if (node.left != null) {
                        linkedList.addLast(node.left);
                    }
                    if (node.right == null) continue;
                    linkedList.addLast(node.right);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid clause: not registered in this index");
        }
    }

    public LinkedList<ClauseInfo> get(K k) {
        LinkedList linkedList = null;
        if (this.root != null) {
            linkedList = (LinkedList)super.lookup(k);
        }
        if (linkedList == null) {
            return this.varsClauses;
        }
        return linkedList;
    }
}

