/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.FamilyClausesIndex;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.ReadOnlyLinkedList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class FamilyClausesList
extends LinkedList<ClauseInfo> {
    private FamilyClausesIndex<Number> numCompClausesIndex = new FamilyClausesIndex();
    private FamilyClausesIndex<String> constantCompClausesIndex = new FamilyClausesIndex();
    private FamilyClausesIndex<String> structCompClausesIndex = new FamilyClausesIndex();
    private LinkedList<ClauseInfo> listCompClausesList = new LinkedList();

    @Override
    public void addFirst(ClauseInfo clauseInfo) {
        super.addFirst(clauseInfo);
        this.register(clauseInfo, true);
    }

    @Override
    public void addLast(ClauseInfo clauseInfo) {
        super.addLast(clauseInfo);
        this.register(clauseInfo, false);
    }

    @Override
    public boolean add(ClauseInfo clauseInfo) {
        this.addLast(clauseInfo);
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends ClauseInfo> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void add(int n, ClauseInfo clauseInfo) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public ClauseInfo set(int n, ClauseInfo clauseInfo) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public ClauseInfo removeFirst() {
        ClauseInfo clauseInfo = (ClauseInfo)this.getFirst();
        if (this.remove(clauseInfo)) {
            return clauseInfo;
        }
        return null;
    }

    @Override
    public ClauseInfo removeLast() {
        ClauseInfo clauseInfo = (ClauseInfo)this.getLast();
        if (this.remove(clauseInfo)) {
            return clauseInfo;
        }
        return null;
    }

    @Override
    public ClauseInfo remove() {
        return this.removeFirst();
    }

    @Override
    public ClauseInfo remove(int n) {
        ClauseInfo clauseInfo = (ClauseInfo)super.get(n);
        if (this.remove(clauseInfo)) {
            return clauseInfo;
        }
        return null;
    }

    @Override
    public boolean remove(Object object) {
        if (super.remove((ClauseInfo)object)) {
            this.unregister((ClauseInfo)object);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.removeFirst();
        }
    }

    public List<ClauseInfo> get(Term term) {
        if (term instanceof Struct) {
            Struct struct = (Struct)term.getTerm();
            if (struct.getArity() == 0) {
                return new ReadOnlyLinkedList<ClauseInfo>(this);
            }
            Term term2 = struct.getArg(0).getTerm();
            if (term2 instanceof Var) {
                return new ReadOnlyLinkedList<ClauseInfo>(this);
            }
            if (term2.isAtomic()) {
                if (term2 instanceof Number) {
                    return new ReadOnlyLinkedList<ClauseInfo>(this.numCompClausesIndex.get((Number)term2));
                }
                if (term2 instanceof Struct) {
                    return new ReadOnlyLinkedList<ClauseInfo>(this.constantCompClausesIndex.get(((Struct)term2).getName()));
                }
            } else if (term2 instanceof Struct) {
                if (this.isAList((Struct)term2)) {
                    return new ReadOnlyLinkedList<ClauseInfo>(this.listCompClausesList);
                }
                return new ReadOnlyLinkedList<ClauseInfo>(this.structCompClausesIndex.get(((Struct)term2).getPredicateIndicator()));
            }
        }
        return new ReadOnlyLinkedList<ClauseInfo>(this);
    }

    @Override
    public Iterator<ClauseInfo> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<ClauseInfo> listIterator() {
        return new ListItr(this, 0).getIt();
    }

    private ListIterator<ClauseInfo> superListIterator(int n) {
        return super.listIterator(n);
    }

    @Override
    public ListIterator<ClauseInfo> listIterator(int n) {
        return new ListItr(this, n).getIt();
    }

    private boolean isAList(Struct struct) {
        return struct.isEmptyList() || struct.getName().equals(".") && struct.getArity() == 2;
    }

    private void register(ClauseInfo clauseInfo, boolean bl) {
        Struct struct = clauseInfo.getHead();
        if (struct instanceof Struct) {
            Struct struct2 = (Struct)((Term)struct).getTerm();
            if (struct2.getArity() == 0) {
                return;
            }
            Term term = struct2.getArg(0).getTerm();
            if (term instanceof Var) {
                this.numCompClausesIndex.insertAsShared(clauseInfo, bl);
                this.constantCompClausesIndex.insertAsShared(clauseInfo, bl);
                this.structCompClausesIndex.insertAsShared(clauseInfo, bl);
                if (bl) {
                    this.listCompClausesList.addFirst(clauseInfo);
                } else {
                    this.listCompClausesList.addLast(clauseInfo);
                }
            } else if (term.isAtomic()) {
                if (term instanceof Number) {
                    this.numCompClausesIndex.insert((Number)term, clauseInfo, bl);
                } else if (term instanceof Struct) {
                    this.constantCompClausesIndex.insert(((Struct)term).getName(), clauseInfo, bl);
                }
            } else if (term instanceof Struct) {
                if (this.isAList((Struct)term)) {
                    if (bl) {
                        this.listCompClausesList.addFirst(clauseInfo);
                    } else {
                        this.listCompClausesList.addLast(clauseInfo);
                    }
                } else {
                    this.structCompClausesIndex.insert(((Struct)term).getPredicateIndicator(), clauseInfo, bl);
                }
            }
        }
    }

    public void unregister(ClauseInfo clauseInfo) {
        Struct struct = clauseInfo.getHead();
        if (struct instanceof Struct) {
            Struct struct2 = (Struct)((Term)struct).getTerm();
            if (struct2.getArity() == 0) {
                return;
            }
            Term term = struct2.getArg(0).getTerm();
            if (term instanceof Var) {
                this.numCompClausesIndex.removeShared(clauseInfo);
                this.constantCompClausesIndex.removeShared(clauseInfo);
                this.structCompClausesIndex.removeShared(clauseInfo);
                this.listCompClausesList.remove(clauseInfo);
            } else if (term.isAtomic()) {
                if (term instanceof Number) {
                    this.numCompClausesIndex.delete((Number)term);
                } else if (term instanceof Struct) {
                    this.constantCompClausesIndex.delete(((Struct)term).getName());
                }
            } else if (term instanceof Struct) {
                if (term.isList()) {
                    this.listCompClausesList.remove(clauseInfo);
                } else {
                    this.structCompClausesIndex.delete(((Struct)term).getPredicateIndicator());
                }
            }
        }
    }

    private static class ListItrTest {
        private static FamilyClausesList clauseList = new FamilyClausesList();

        private ListItrTest() {
        }

        public static void main(String[] stringArray) {
            ClauseInfo clauseInfo = new ClauseInfo(new Struct(new Struct("First"), (Term)new Struct("First")), "First Element");
            ClauseInfo clauseInfo2 = new ClauseInfo(new Struct(new Struct("Second"), (Term)new Struct("Second")), "Second Element");
            ClauseInfo clauseInfo3 = new ClauseInfo(new Struct(new Struct("Third"), (Term)new Struct("Third")), "Third Element");
            ClauseInfo clauseInfo4 = new ClauseInfo(new Struct(new Struct("Fourth"), (Term)new Struct("Fourth")), "Fourth Element");
            clauseList.add(clauseInfo);
            clauseList.add(clauseInfo2);
            clauseList.add(clauseInfo3);
            clauseList.add(clauseInfo4);
            ListIterator<ClauseInfo> listIterator = clauseList.listIterator();
            listIterator.next();
            listIterator.remove();
            if (clauseList.contains(clauseInfo)) {
                System.out.println("Error!");
                System.exit(-1);
            }
            listIterator.next();
            listIterator.next();
            listIterator.previous();
            listIterator.previous();
            listIterator.remove();
            if (clauseList.contains(clauseInfo2)) {
                System.out.println("Error!");
                System.exit(-2);
            }
            System.out.println("Ok!!!");
        }
    }

    private class ListItr
    implements ListIterator<ClauseInfo> {
        private ListIterator<ClauseInfo> it;
        private LinkedList<ClauseInfo> l;
        private int currentIndex = 0;

        public ListItr(FamilyClausesList familyClausesList2, int n) {
            this.l = familyClausesList2;
            this.it = familyClausesList2.superListIterator(n);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ClauseInfo next() {
            this.currentIndex = this.it.nextIndex();
            return this.it.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public ClauseInfo previous() {
            this.currentIndex = this.it.previousIndex();
            return this.it.previous();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            ClauseInfo clauseInfo = this.l.get(this.currentIndex);
            this.it.remove();
            FamilyClausesList.this.unregister(clauseInfo);
        }

        @Override
        public void set(ClauseInfo clauseInfo) {
            this.it.set(clauseInfo);
        }

        @Override
        public void add(ClauseInfo clauseInfo) {
            this.l.addLast(clauseInfo);
        }

        public ListIterator<ClauseInfo> getIt() {
            return this;
        }
    }
}

