/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import java.util.List;

public class Int
extends Number {
    private int value;

    public Int(int n) {
        this.value = n;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean isInteger() {
        return true;
    }

    @Override
    public final boolean isReal() {
        return false;
    }

    @Override
    public final boolean isTypeInt() {
        return true;
    }

    @Override
    public final boolean isInt() {
        return true;
    }

    @Override
    public final boolean isTypeFloat() {
        return false;
    }

    @Override
    public final boolean isFloat() {
        return false;
    }

    @Override
    public final boolean isTypeDouble() {
        return false;
    }

    @Override
    public final boolean isDouble() {
        return false;
    }

    @Override
    public final boolean isTypeLong() {
        return false;
    }

    @Override
    public final boolean isLong() {
        return false;
    }

    @Override
    public boolean isGreater(Term term) {
        if ((term = term.getTerm()) instanceof Number) {
            return this.value > ((Number)term).intValue();
        }
        if (term instanceof Struct) {
            return false;
        }
        return term instanceof Var;
    }

    @Override
    public boolean isEqual(Term term) {
        if ((term = term.getTerm()) instanceof Number) {
            Number number = (Number)term;
            if (!number.isInteger()) {
                return false;
            }
            return (long)this.value == number.longValue();
        }
        return false;
    }

    @Override
    boolean unify(List<Var> list, List<Var> list2, Term term) {
        if ((term = term.getTerm()) instanceof Var) {
            return term.unify(list2, list, this);
        }
        if (term instanceof Number && ((Number)term).isInteger()) {
            return this.value == ((Number)term).intValue();
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public int compareTo(Number number) {
        return new Integer(this.value).compareTo(number.intValue());
    }
}

