/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.IPrimitives;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.TheoryManager;
import alice.tuprolog.event.LibraryEvent;
import alice.tuprolog.event.WarningEvent;
import alice.util.AssemblyCustomClassLoader;
import cli.System.Reflection.Assembly;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;

public class LibraryManager {
    private ArrayList<Library> currentLibraries;
    private Prolog prolog;
    private TheoryManager theoryManager;
    private PrimitiveManager primitiveManager;
    private Hashtable<String, URL> externalLibraries = new Hashtable();

    LibraryManager() {
        this.currentLibraries = new ArrayList();
    }

    void initialize(Prolog prolog) {
        this.prolog = prolog;
        this.theoryManager = prolog.getTheoryManager();
        this.primitiveManager = prolog.getPrimitiveManager();
    }

    public synchronized Library loadLibrary(String string) throws InvalidLibraryException {
        Object object;
        Library library = null;
        try {
            library = (Library)Class.forName(string).newInstance();
            object = library.getName();
            Library library2 = this.getLibrary((String)object);
            if (library2 != null) {
                if (this.prolog.isWarning()) {
                    String string2 = "library " + library2.getName() + " already loaded.";
                    this.prolog.notifyWarning(new WarningEvent(this.prolog, string2));
                }
                return library2;
            }
        }
        catch (Exception exception) {
            throw new InvalidLibraryException(string, -1, -1);
        }
        this.bindLibrary(library);
        object = new LibraryEvent(this.prolog, library.getName());
        this.prolog.notifyLoadedLibrary((LibraryEvent)object);
        return library;
    }

    public synchronized Library loadLibrary(String string, String[] stringArray) throws InvalidLibraryException {
        Object object;
        Library library = null;
        URL[] uRLArray = null;
        URLClassLoader uRLClassLoader = null;
        try {
            uRLArray = new URL[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (stringArray[i].contains(".class")) {
                    file = new File(stringArray[i].substring(0, stringArray[i].lastIndexOf(File.separator) + 1));
                }
                uRLArray[i] = file.toURI().toURL();
            }
            if (!System.getProperty("java.vm.name").equals("IKVM.NET")) {
                uRLClassLoader = URLClassLoader.newInstance(uRLArray, this.getClass().getClassLoader());
                library = (Library)Class.forName(string, true, uRLClassLoader).newInstance();
            } else {
                Assembly assembly = null;
                boolean bl = false;
                string = "cli." + string.substring(0, string.indexOf(",")).trim();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        assembly = Assembly.LoadFrom((String)stringArray[i]);
                        uRLClassLoader = new AssemblyCustomClassLoader(assembly, uRLArray);
                        library = (Library)Class.forName(string, true, uRLClassLoader).newInstance();
                        if (library == null) continue;
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (!bl) {
                    throw new InvalidLibraryException(string, -1, -1);
                }
            }
            object = library.getName();
            Library library2 = this.getLibrary((String)object);
            if (library2 != null) {
                if (this.prolog.isWarning()) {
                    String string2 = "library " + library2.getName() + " already loaded.";
                    this.prolog.notifyWarning(new WarningEvent(this.prolog, string2));
                }
                return library2;
            }
        }
        catch (Exception exception) {
            throw new InvalidLibraryException(string, -1, -1);
        }
        this.externalLibraries.put(string, LibraryManager.getClassResource(library.getClass()));
        this.bindLibrary(library);
        object = new LibraryEvent(this.prolog, library.getName());
        this.prolog.notifyLoadedLibrary((LibraryEvent)object);
        return library;
    }

    public synchronized void loadLibrary(Library library) throws InvalidLibraryException {
        Object object;
        String string = library.getName();
        Library library2 = this.getLibrary(string);
        if (library2 != null) {
            if (this.prolog.isWarning()) {
                object = "library " + library2.getName() + " already loaded.";
                this.prolog.notifyWarning(new WarningEvent(this.prolog, (String)object));
            }
            this.unloadLibrary(string);
        }
        this.bindLibrary(library);
        object = new LibraryEvent(this.prolog, library.getName());
        this.prolog.notifyLoadedLibrary((LibraryEvent)object);
    }

    public synchronized String[] getCurrentLibraries() {
        String[] stringArray = new String[this.currentLibraries.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.currentLibraries.get(i).getName();
        }
        return stringArray;
    }

    public synchronized void unloadLibrary(String string) throws InvalidLibraryException {
        Serializable serializable;
        boolean bl = false;
        ListIterator<Library> listIterator = this.currentLibraries.listIterator();
        while (listIterator.hasNext()) {
            serializable = (Library)listIterator.next();
            if (!serializable.getName().equals(string)) continue;
            bl = true;
            listIterator.remove();
            serializable.dismiss();
            this.primitiveManager.deletePrimitiveInfo((IPrimitives)((Object)serializable));
            break;
        }
        if (!bl) {
            throw new InvalidLibraryException();
        }
        if (this.externalLibraries.containsKey(string)) {
            this.externalLibraries.remove(string);
        }
        this.theoryManager.removeLibraryTheory(string);
        this.theoryManager.rebindPrimitives();
        serializable = new LibraryEvent(this.prolog, string);
        this.prolog.notifyUnloadedLibrary((LibraryEvent)serializable);
    }

    private Library bindLibrary(Library library) throws InvalidLibraryException {
        try {
            String string = library.getName();
            library.setEngine(this.prolog);
            this.currentLibraries.add(library);
            this.primitiveManager.createPrimitiveInfo(library);
            String string2 = library.getTheory();
            if (string2 != null) {
                this.theoryManager.consult(new Theory(string2), false, string);
                this.theoryManager.solveTheoryGoal();
            }
            this.theoryManager.rebindPrimitives();
            return library;
        }
        catch (InvalidTheoryException invalidTheoryException) {
            throw new InvalidLibraryException(library.getName(), invalidTheoryException.line, invalidTheoryException.pos);
        }
        catch (Exception exception) {
            throw new InvalidLibraryException(library.getName(), -1, -1);
        }
    }

    public synchronized Library getLibrary(String string) {
        for (Library library : this.currentLibraries) {
            if (!library.getName().equals(string)) continue;
            return library;
        }
        return null;
    }

    public synchronized void onSolveBegin(Term term) {
        for (Library library : this.currentLibraries) {
            library.onSolveBegin(term);
        }
    }

    public synchronized void onSolveHalt() {
        for (Library library : this.currentLibraries) {
            library.onSolveHalt();
        }
    }

    public synchronized void onSolveEnd() {
        for (Library library : this.currentLibraries) {
            library.onSolveEnd();
        }
    }

    public synchronized URL getExternalLibraryURL(String string) {
        return this.isExternalLibrary(string) ? this.externalLibraries.get(string) : null;
    }

    public synchronized boolean isExternalLibrary(String string) {
        return this.externalLibraries.containsKey(string);
    }

    private static URL getClassResource(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class");
    }
}

