/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Term;
import alice.tuprolog.TermVisitor;
import alice.tuprolog.Var;
import java.util.AbstractMap;

public abstract class Number
extends Term
implements Comparable<Number> {
    public abstract int intValue();

    public abstract float floatValue();

    public abstract long longValue();

    public abstract double doubleValue();

    public abstract boolean isInteger();

    public abstract boolean isReal();

    public abstract boolean isTypeInt();

    public abstract boolean isInt();

    public abstract boolean isTypeFloat();

    public abstract boolean isFloat();

    public abstract boolean isTypeDouble();

    public abstract boolean isDouble();

    public abstract boolean isTypeLong();

    public abstract boolean isLong();

    public static Number createNumber(String string) {
        Term term = Term.createTerm(string);
        if (term instanceof Number) {
            return (Number)term;
        }
        throw new InvalidTermException("Term " + term + " is not a number.");
    }

    @Override
    public Term getTerm() {
        return this;
    }

    @Override
    public final boolean isNumber() {
        return true;
    }

    @Override
    public final boolean isStruct() {
        return false;
    }

    @Override
    public final boolean isVar() {
        return false;
    }

    @Override
    public final boolean isEmptyList() {
        return false;
    }

    @Override
    public final boolean isAtomic() {
        return true;
    }

    @Override
    public final boolean isCompound() {
        return false;
    }

    @Override
    public final boolean isAtom() {
        return false;
    }

    @Override
    public final boolean isList() {
        return false;
    }

    @Override
    public final boolean isGround() {
        return true;
    }

    public Term copy(int n) {
        return this;
    }

    @Override
    Term copy(AbstractMap<Var, Var> abstractMap, int n) {
        return this;
    }

    @Override
    Term copy(AbstractMap<Var, Var> abstractMap, AbstractMap<Term, Var> abstractMap2) {
        return this;
    }

    @Override
    long resolveTerm(long l) {
        return l;
    }

    @Override
    public void free() {
    }

    void restoreVariables() {
    }

    @Override
    public void accept(TermVisitor termVisitor) {
        termVisitor.visit(this);
    }
}

