/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Operator;
import alice.tuprolog.interfaces.IOperatorManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class OperatorManager
implements IOperatorManager,
Serializable {
    private OperatorRegister operatorList = new OperatorRegister();
    public static final int OP_LOW = 1;
    public static final int OP_HIGH = 1200;

    @Override
    public synchronized void opNew(String string, String string2, int n) {
        Operator operator = new Operator(string, string2, n);
        if (n >= 1 && n <= 1200) {
            this.operatorList.addOperator(operator);
        }
    }

    public synchronized int opPrio(String string, String string2) {
        Operator operator = this.operatorList.getOperator(string, string2);
        return operator == null ? 0 : operator.prio;
    }

    public synchronized int opNext(int n) {
        int n2 = 0;
        for (Operator operator : this.operatorList) {
            if (operator.prio <= n2 || operator.prio >= n) continue;
            n2 = operator.prio;
        }
        return n2;
    }

    public synchronized List<Operator> getOperators() {
        return new LinkedList<Operator>(this.operatorList);
    }

    @Override
    public IOperatorManager clone() {
        OperatorManager operatorManager = new OperatorManager();
        operatorManager.operatorList = (OperatorRegister)this.operatorList.clone();
        return operatorManager;
    }

    private static class OperatorRegister
    extends LinkedHashSet<Operator>
    implements Cloneable {
        private HashMap<String, Operator> nameTypeToKey = new HashMap();

        private OperatorRegister() {
        }

        public boolean addOperator(Operator operator) {
            String string = operator.name + operator.type;
            Operator operator2 = this.nameTypeToKey.get(string);
            if (operator2 != null) {
                super.remove(operator2);
            }
            this.nameTypeToKey.put(string, operator);
            return super.add(operator);
        }

        public Operator getOperator(String string, String string2) {
            return this.nameTypeToKey.get(string + string2);
        }

        @Override
        public Object clone() {
            OperatorRegister operatorRegister = (OperatorRegister)super.clone();
            Iterator iterator = operatorRegister.iterator();
            operatorRegister.nameTypeToKey = new HashMap();
            while (iterator.hasNext()) {
                Operator operator = (Operator)iterator.next();
                operatorRegister.nameTypeToKey.put(operator.name + operator.type, operator);
            }
            return operatorRegister;
        }
    }
}

