/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.BuiltIn;
import alice.tuprolog.IPrimitives;
import alice.tuprolog.Library;
import alice.tuprolog.PrimitiveInfo;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.interfaces.IPrimitiveManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PrimitiveManager
implements IPrimitiveManager {
    private Map<IPrimitives, List<PrimitiveInfo>> libHashMap = Collections.synchronizedMap(new IdentityHashMap());
    private Map<String, PrimitiveInfo> directiveHashMap = Collections.synchronizedMap(new HashMap());
    private Map<String, PrimitiveInfo> predicateHashMap = Collections.synchronizedMap(new HashMap());
    private Map<String, PrimitiveInfo> functorHashMap = Collections.synchronizedMap(new HashMap());

    void initialize(Prolog prolog) {
        this.createPrimitiveInfo(new BuiltIn(prolog));
    }

    void createPrimitiveInfo(IPrimitives iPrimitives) {
        Map<Integer, List<PrimitiveInfo>> map = iPrimitives.getPrimitives();
        for (PrimitiveInfo object2 : map.get(0)) {
            this.directiveHashMap.put(object2.getKey(), object2);
        }
        for (PrimitiveInfo primitiveInfo : map.get(1)) {
            this.predicateHashMap.put(primitiveInfo.getKey(), primitiveInfo);
        }
        for (PrimitiveInfo primitiveInfo : map.get(2)) {
            this.functorHashMap.put(primitiveInfo.getKey(), primitiveInfo);
        }
        LinkedList linkedList = new LinkedList(map.get(0));
        linkedList.addAll(map.get(1));
        linkedList.addAll(map.get(2));
        this.libHashMap.put(iPrimitives, linkedList);
    }

    void deletePrimitiveInfo(IPrimitives iPrimitives) {
        Iterator<PrimitiveInfo> iterator = this.libHashMap.remove(iPrimitives).iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().invalidate();
            this.directiveHashMap.remove(string);
            this.predicateHashMap.remove(string);
            this.functorHashMap.remove(string);
        }
    }

    public Term identifyDirective(Term term) {
        this.identify(term, 0);
        return term;
    }

    public boolean evalAsDirective(Struct struct) throws Throwable {
        PrimitiveInfo primitiveInfo = ((Struct)this.identifyDirective(struct)).getPrimitive();
        if (primitiveInfo != null) {
            try {
                primitiveInfo.evalAsDirective(struct);
                return true;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        return false;
    }

    public void identifyPredicate(Term term) {
        this.identify(term, 1);
    }

    public void identifyFunctor(Term term) {
        this.identify(term, 2);
    }

    private void identify(Term term, int n) {
        int n2;
        if (term == null) {
            return;
        }
        if (!((term = term.getTerm()) instanceof Struct)) {
            return;
        }
        Struct struct = (Struct)term;
        int n3 = struct.getArity();
        String string = struct.getName();
        if (string.equals(",") || string.equals("':-'") || string.equals(":-")) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.identify(struct.getArg(n2), 1);
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                this.identify(struct.getArg(n2), 2);
            }
        }
        PrimitiveInfo primitiveInfo = null;
        String string2 = string + "/" + n3;
        switch (n) {
            case 0: {
                primitiveInfo = this.directiveHashMap.get(string2);
                break;
            }
            case 1: {
                primitiveInfo = this.predicateHashMap.get(string2);
                break;
            }
            case 2: {
                primitiveInfo = this.functorHashMap.get(string2);
            }
        }
        struct.setPrimitive(primitiveInfo);
    }

    Library getLibraryDirective(String string, int n) {
        try {
            return (Library)this.directiveHashMap.get(string + "/" + n).getSource();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    Library getLibraryPredicate(String string, int n) {
        try {
            return (Library)this.predicateHashMap.get(string + "/" + n).getSource();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    Library getLibraryFunctor(String string, int n) {
        try {
            return (Library)this.functorHashMap.get(string + "/" + n).getSource();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public boolean containsTerm(String string, int n) {
        return this.functorHashMap.containsKey(string + "/" + n) || this.predicateHashMap.containsKey(string + "/" + n);
    }
}

