/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Engine;
import alice.tuprolog.EngineManager;
import alice.tuprolog.ExecutionContext;
import alice.tuprolog.FlagManager;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.LibraryManager;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.Operator;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Parser;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.TheoryManager;
import alice.tuprolog.event.ExceptionEvent;
import alice.tuprolog.event.ExceptionListener;
import alice.tuprolog.event.LibraryEvent;
import alice.tuprolog.event.LibraryListener;
import alice.tuprolog.event.OutputEvent;
import alice.tuprolog.event.OutputListener;
import alice.tuprolog.event.QueryEvent;
import alice.tuprolog.event.QueryListener;
import alice.tuprolog.event.SpyEvent;
import alice.tuprolog.event.SpyListener;
import alice.tuprolog.event.TheoryEvent;
import alice.tuprolog.event.TheoryListener;
import alice.tuprolog.event.WarningEvent;
import alice.tuprolog.event.WarningListener;
import alice.tuprolog.interfaces.IProlog;
import alice.tuprologx.ide.ToolBar;
import alice.util.VersionInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Prolog
implements IProlog,
Serializable {
    private TheoryManager theoryManager;
    private PrimitiveManager primitiveManager;
    private OperatorManager opManager;
    private FlagManager flagManager;
    private LibraryManager libraryManager;
    private EngineManager engineManager;
    private boolean spy;
    private boolean warning;
    private boolean exception;
    private ArrayList<OutputListener> outputListeners = new ArrayList();
    private ArrayList<SpyListener> spyListeners = new ArrayList();
    private ArrayList<WarningListener> warningListeners = new ArrayList();
    private ArrayList<ExceptionListener> exceptionListeners = new ArrayList();
    private ArrayList<TheoryListener> theoryListeners;
    private ArrayList<LibraryListener> libraryListeners;
    private ArrayList<QueryListener> queryListeners;
    private ArrayList<String> absolutePathList;

    public Prolog() {
        this(false, true);
        try {
            this.loadLibrary("alice.tuprolog.lib.BasicLibrary");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.ISOLibrary");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.IOLibrary");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (System.getProperty("java.vm.name").equals("IKVM.NET")) {
                this.loadLibrary("OOLibrary.OOLibrary, OOLibrary");
            } else {
                this.loadLibrary("alice.tuprolog.lib.JavaLibrary");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Prolog(String[] stringArray) throws InvalidLibraryException {
        this(false, true);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.loadLibrary(stringArray[i]);
            }
        }
    }

    private Prolog(boolean bl, boolean bl2) {
        this.spy = bl;
        this.warning = bl2;
        this.exception = true;
        this.theoryListeners = new ArrayList();
        this.queryListeners = new ArrayList();
        this.libraryListeners = new ArrayList();
        this.absolutePathList = new ArrayList();
        this.initializeManagers();
    }

    private void initializeManagers() {
        this.flagManager = new FlagManager();
        this.libraryManager = new LibraryManager();
        this.opManager = new OperatorManager();
        this.theoryManager = new TheoryManager();
        this.primitiveManager = new PrimitiveManager();
        this.engineManager = new EngineManager();
        this.theoryManager.initialize(this);
        this.libraryManager.initialize(this);
        this.flagManager.initialize(this);
        this.primitiveManager.initialize(this);
        this.engineManager.initialize(this);
    }

    public FlagManager getFlagManager() {
        return this.flagManager;
    }

    public TheoryManager getTheoryManager() {
        return this.theoryManager;
    }

    @Override
    public PrimitiveManager getPrimitiveManager() {
        return this.primitiveManager;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    @Override
    public OperatorManager getOperatorManager() {
        return this.opManager;
    }

    public EngineManager getEngineManager() {
        return this.engineManager;
    }

    public static String getVersion() {
        return VersionInfo.getEngineVersion();
    }

    public String getCurrentDirectory() {
        String string;
        String string2 = "";
        string2 = this.absolutePathList.isEmpty() ? ((string = ToolBar.getPath()) != null ? string : System.getProperty("user.dir")) : this.absolutePathList.get(this.absolutePathList.size() - 1);
        return string2;
    }

    public void setTheory(Theory theory) throws InvalidTheoryException {
        this.theoryManager.clear();
        this.addTheory(theory);
    }

    @Override
    public void addTheory(Theory theory) throws InvalidTheoryException {
        Theory theory2 = this.getTheory();
        this.theoryManager.consult(theory, true, null);
        this.theoryManager.solveTheoryGoal();
        Theory theory3 = this.getTheory();
        TheoryEvent theoryEvent = new TheoryEvent(this, theory2, theory3);
        this.notifyChangedTheory(theoryEvent);
    }

    @Override
    public Theory getTheory() {
        try {
            return new Theory(this.theoryManager.getTheory(true));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Theory getLastConsultedTheory() {
        return this.theoryManager.getLastConsultedTheory();
    }

    @Override
    public void clearTheory() {
        try {
            this.setTheory(new Theory());
        }
        catch (InvalidTheoryException invalidTheoryException) {
            // empty catch block
        }
    }

    @Override
    public Library loadLibrary(String string) throws InvalidLibraryException {
        return this.libraryManager.loadLibrary(string);
    }

    public Library loadLibrary(String string, String[] stringArray) throws InvalidLibraryException {
        return this.libraryManager.loadLibrary(string, stringArray);
    }

    public void loadLibrary(Library library) throws InvalidLibraryException {
        this.libraryManager.loadLibrary(library);
    }

    @Override
    public String[] getCurrentLibraries() {
        return this.libraryManager.getCurrentLibraries();
    }

    @Override
    public void unloadLibrary(String string) throws InvalidLibraryException {
        this.libraryManager.unloadLibrary(string);
    }

    @Override
    public Library getLibrary(String string) {
        return this.libraryManager.getLibrary(string);
    }

    protected Library getLibraryPredicate(String string, int n) {
        return this.primitiveManager.getLibraryPredicate(string, n);
    }

    protected Library getLibraryFunctor(String string, int n) {
        return this.primitiveManager.getLibraryFunctor(string, n);
    }

    public List<Operator> getCurrentOperatorList() {
        return this.opManager.getOperators();
    }

    public SolveInfo solve(Term term) {
        if (term == null) {
            return null;
        }
        SolveInfo solveInfo = this.engineManager.solve(term);
        QueryEvent queryEvent = new QueryEvent(this, solveInfo);
        this.notifyNewQueryResultAvailable(queryEvent);
        return solveInfo;
    }

    @Override
    public SolveInfo solve(String string) throws MalformedGoalException {
        try {
            Parser parser = new Parser(this.opManager, string);
            Term term = parser.nextTerm(true);
            return this.solve(term);
        }
        catch (InvalidTermException invalidTermException) {
            throw new MalformedGoalException();
        }
    }

    @Override
    public SolveInfo solveNext() throws NoMoreSolutionException {
        if (this.hasOpenAlternatives()) {
            SolveInfo solveInfo = this.engineManager.solveNext();
            QueryEvent queryEvent = new QueryEvent(this, solveInfo);
            this.notifyNewQueryResultAvailable(queryEvent);
            return solveInfo;
        }
        throw new NoMoreSolutionException();
    }

    @Override
    public void solveHalt() {
        this.engineManager.solveHalt();
    }

    @Override
    public void solveEnd() {
        this.engineManager.solveEnd();
    }

    @Override
    public boolean hasOpenAlternatives() {
        boolean bl = this.engineManager.hasOpenAlternatives();
        return bl;
    }

    public boolean isHalted() {
        return this.engineManager.isHalted();
    }

    public boolean match(Term term, Term term2) {
        return term.match(term2);
    }

    public boolean unify(Term term, Term term2) {
        return term.unify(this, term2);
    }

    public void identifyFunctor(Term term) {
        this.primitiveManager.identifyFunctor(term);
    }

    public Term toTerm(String string) throws InvalidTermException {
        return Parser.parseSingleTerm(string, this.opManager);
    }

    @Override
    public String toString(Term term) {
        return term.toStringAsArgY(this.opManager, 1200);
    }

    public boolean defineFlag(String string, Struct struct, Term term, boolean bl, String string2) {
        return this.flagManager.defineFlag(string, struct, term, bl, string2);
    }

    @Override
    public synchronized void setSpy(boolean bl) {
        this.spy = bl;
    }

    public synchronized boolean isSpy() {
        return this.spy;
    }

    protected synchronized void spy(String string) {
        if (this.spy) {
            this.notifySpy(new SpyEvent(this, string));
        }
    }

    protected synchronized void spy(String string, Engine engine) {
        if (this.spy) {
            ExecutionContext executionContext = engine.currentContext;
            int n = 0;
            String string2 = "-";
            if (executionContext.fatherCtx != null) {
                n = executionContext.depth - 1;
                string2 = executionContext.fatherCtx.currentGoal.toString();
            }
            this.notifySpy(new SpyEvent(this, engine, "spy: " + n + "  " + string + "  " + string2));
        }
    }

    public synchronized void setWarning(boolean bl) {
        this.warning = bl;
    }

    public synchronized boolean isWarning() {
        return this.warning;
    }

    public void warn(String string) {
        if (this.warning) {
            this.notifyWarning(new WarningEvent(this, string));
        }
    }

    public void exception(String string) {
        if (this.exception) {
            this.notifyException(new ExceptionEvent(this, string));
        }
    }

    public synchronized boolean isException() {
        return this.exception;
    }

    public synchronized void setException(boolean bl) {
        this.exception = bl;
    }

    public synchronized void stdOutput(String string) {
        this.notifyOutput(new OutputEvent(this, string));
    }

    @Override
    public synchronized void addOutputListener(OutputListener outputListener) {
        this.outputListeners.add(outputListener);
    }

    public synchronized void addTheoryListener(TheoryListener theoryListener) {
        this.theoryListeners.add(theoryListener);
    }

    public synchronized void addLibraryListener(LibraryListener libraryListener) {
        this.libraryListeners.add(libraryListener);
    }

    public synchronized void addQueryListener(QueryListener queryListener) {
        this.queryListeners.add(queryListener);
    }

    @Override
    public synchronized void addSpyListener(SpyListener spyListener) {
        this.spyListeners.add(spyListener);
    }

    public synchronized void addWarningListener(WarningListener warningListener) {
        this.warningListeners.add(warningListener);
    }

    @Override
    public synchronized void addExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListeners.add(exceptionListener);
    }

    @Override
    public synchronized void removeOutputListener(OutputListener outputListener) {
        this.outputListeners.remove(outputListener);
    }

    @Override
    public synchronized void removeAllOutputListeners() {
        this.outputListeners.clear();
    }

    public synchronized void removeTheoryListener(TheoryListener theoryListener) {
        this.theoryListeners.remove(theoryListener);
    }

    public synchronized void removeLibraryListener(LibraryListener libraryListener) {
        this.libraryListeners.remove(libraryListener);
    }

    public synchronized void removeQueryListener(QueryListener queryListener) {
        this.queryListeners.remove(queryListener);
    }

    @Override
    public synchronized void removeSpyListener(SpyListener spyListener) {
        this.spyListeners.remove(spyListener);
    }

    @Override
    public synchronized void removeAllSpyListeners() {
        this.spyListeners.clear();
    }

    public synchronized void removeWarningListener(WarningListener warningListener) {
        this.warningListeners.remove(warningListener);
    }

    public synchronized void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    @Override
    public synchronized void removeExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListeners.remove(exceptionListener);
    }

    @Override
    public synchronized void removeAllExceptionListeners() {
        this.exceptionListeners.clear();
    }

    public synchronized List<OutputListener> getOutputListenerList() {
        return new ArrayList<OutputListener>(this.outputListeners);
    }

    public synchronized List<WarningListener> getWarningListenerList() {
        return new ArrayList<WarningListener>(this.warningListeners);
    }

    public synchronized List<ExceptionListener> getExceptionListenerList() {
        return new ArrayList<ExceptionListener>(this.exceptionListeners);
    }

    public synchronized List<SpyListener> getSpyListenerList() {
        return new ArrayList<SpyListener>(this.spyListeners);
    }

    public synchronized List<TheoryListener> getTheoryListenerList() {
        return new ArrayList<TheoryListener>(this.theoryListeners);
    }

    public synchronized List<LibraryListener> getLibraryListenerList() {
        return new ArrayList<LibraryListener>(this.libraryListeners);
    }

    public synchronized List<QueryListener> getQueryListenerList() {
        return new ArrayList<QueryListener>(this.queryListeners);
    }

    protected void notifyOutput(OutputEvent outputEvent) {
        for (OutputListener outputListener : this.outputListeners) {
            outputListener.onOutput(outputEvent);
        }
    }

    protected void notifySpy(SpyEvent spyEvent) {
        for (SpyListener spyListener : this.spyListeners) {
            spyListener.onSpy(spyEvent);
        }
    }

    protected void notifyWarning(WarningEvent warningEvent) {
        for (WarningListener warningListener : this.warningListeners) {
            warningListener.onWarning(warningEvent);
        }
    }

    protected void notifyException(ExceptionEvent exceptionEvent) {
        for (ExceptionListener exceptionListener : this.exceptionListeners) {
            exceptionListener.onException(exceptionEvent);
        }
    }

    protected void notifyChangedTheory(TheoryEvent theoryEvent) {
        for (TheoryListener theoryListener : this.theoryListeners) {
            theoryListener.theoryChanged(theoryEvent);
        }
    }

    protected void notifyLoadedLibrary(LibraryEvent libraryEvent) {
        for (LibraryListener libraryListener : this.libraryListeners) {
            libraryListener.libraryLoaded(libraryEvent);
        }
    }

    protected void notifyUnloadedLibrary(LibraryEvent libraryEvent) {
        for (LibraryListener libraryListener : this.libraryListeners) {
            libraryListener.libraryUnloaded(libraryEvent);
        }
    }

    protected void notifyNewQueryResultAvailable(QueryEvent queryEvent) {
        for (QueryListener queryListener : this.queryListeners) {
            queryListener.newQueryResultAvailable(queryEvent);
        }
    }

    public void pushDirectoryToList(String string) {
        this.absolutePathList.add(string);
    }

    public void popDirectoryFromList() {
        if (!this.absolutePathList.isEmpty()) {
            this.absolutePathList.remove(this.absolutePathList.size() - 1);
        }
    }

    public void resetDirectoryList(String string) {
        this.absolutePathList = new ArrayList();
        this.absolutePathList.add(string);
    }

    public Term termSolve(String string) {
        try {
            Parser parser = new Parser(this.opManager, string);
            Term term = parser.nextTerm(true);
            return term;
        }
        catch (InvalidTermException invalidTermException) {
            String string2 = "null";
            Term term = Term.createTerm(string2);
            return term;
        }
    }
}

