/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Color;
import alice.tuprolog.Node;

public class RBTree<K extends Comparable<? super K>, V> {
    public static final boolean VERIFY_RBTREE = false;
    private static final int INDENT_STEP = 4;
    public Node<K, V> root = null;

    public RBTree() {
        this.verifyProperties();
    }

    public void verifyProperties() {
    }

    private static void verifyProperty1(Node<?, ?> node) {
        assert (RBTree.nodeColor(node) == Color.RED || RBTree.nodeColor(node) == Color.BLACK);
        if (node == null) {
            return;
        }
        RBTree.verifyProperty1(node.left);
        RBTree.verifyProperty1(node.right);
    }

    private static void verifyProperty2(Node<?, ?> node) {
        assert (RBTree.nodeColor(node) == Color.BLACK);
    }

    private static Color nodeColor(Node<?, ?> node) {
        return node == null ? Color.BLACK : node.color;
    }

    private static void verifyProperty4(Node<?, ?> node) {
        if (RBTree.nodeColor(node) == Color.RED) {
            assert (RBTree.nodeColor(node.left) == Color.BLACK);
            assert (RBTree.nodeColor(node.right) == Color.BLACK);
            assert (RBTree.nodeColor(node.parent) == Color.BLACK);
        }
        if (node == null) {
            return;
        }
        RBTree.verifyProperty4(node.left);
        RBTree.verifyProperty4(node.right);
    }

    private static void verifyProperty5(Node<?, ?> node) {
        RBTree.verifyProperty5Helper(node, 0, -1);
    }

    private static int verifyProperty5Helper(Node<?, ?> node, int n, int n2) {
        if (RBTree.nodeColor(node) == Color.BLACK) {
            ++n;
        }
        if (node == null) {
            if (n2 == -1) {
                n2 = n;
            } else assert (n == n2);
            return n2;
        }
        n2 = RBTree.verifyProperty5Helper(node.left, n, n2);
        n2 = RBTree.verifyProperty5Helper(node.right, n, n2);
        return n2;
    }

    private Node<K, V> lookupNode(K k) {
        Node<K, V> node = this.root;
        while (node != null) {
            int n = k.compareTo(node.key);
            if (n == 0) {
                return node;
            }
            if (n < 0) {
                node = node.left;
                continue;
            }
            assert (n > 0);
            node = node.right;
        }
        return node;
    }

    public V lookup(K k) {
        Node<K, V> node = this.lookupNode(k);
        return node == null ? null : (V)node.value;
    }

    private void rotateLeft(Node<K, V> node) {
        Node node2 = node.right;
        this.replaceNode(node, node2);
        node.right = node2.left;
        if (node2.left != null) {
            node2.left.parent = node;
        }
        node2.left = node;
        node.parent = node2;
    }

    private void rotateRight(Node<K, V> node) {
        Node node2 = node.left;
        this.replaceNode(node, node2);
        node.left = node2.right;
        if (node2.right != null) {
            node2.right.parent = node;
        }
        node2.right = node;
        node.parent = node2;
    }

    private void replaceNode(Node<K, V> node, Node<K, V> node2) {
        if (node.parent == null) {
            this.root = node2;
        } else if (node == node.parent.left) {
            node.parent.left = node2;
        } else {
            node.parent.right = node2;
        }
        if (node2 != null) {
            node2.parent = node.parent;
        }
    }

    public void insert(K k, V v) {
        Node<K, V> node = new Node<K, V>(k, v, Color.RED, null, null);
        if (this.root == null) {
            this.root = node;
        } else {
            Node<K, V> node2 = this.root;
            while (true) {
                int n;
                if ((n = k.compareTo(node2.key)) == 0) {
                    node2.value = v;
                    return;
                }
                if (n < 0) {
                    if (node2.left == null) {
                        node2.left = node;
                        break;
                    }
                    node2 = node2.left;
                    continue;
                }
                assert (n > 0);
                if (node2.right == null) {
                    node2.right = node;
                    break;
                }
                node2 = node2.right;
            }
            node.parent = node2;
        }
        this.insertCase1(node);
        this.verifyProperties();
    }

    protected void insertCase1(Node<K, V> node) {
        if (node.parent == null) {
            node.color = Color.BLACK;
        } else {
            this.insertCase2(node);
        }
    }

    private void insertCase2(Node<K, V> node) {
        if (RBTree.nodeColor(node.parent) == Color.BLACK) {
            return;
        }
        this.insertCase3(node);
    }

    void insertCase3(Node<K, V> node) {
        if (RBTree.nodeColor(node.uncle()) == Color.RED) {
            node.parent.color = Color.BLACK;
            node.uncle().color = Color.BLACK;
            node.grandparent().color = Color.RED;
            this.insertCase1(node.grandparent());
        } else {
            this.insertCase4(node);
        }
    }

    void insertCase4(Node<K, V> node) {
        if (node == node.parent.right && node.parent == node.grandparent().left) {
            this.rotateLeft(node.parent);
            node = node.left;
        } else if (node == node.parent.left && node.parent == node.grandparent().right) {
            this.rotateRight(node.parent);
            node = node.right;
        }
        this.insertCase5(node);
    }

    void insertCase5(Node<K, V> node) {
        node.parent.color = Color.BLACK;
        node.grandparent().color = Color.RED;
        if (node == node.parent.left && node.parent == node.grandparent().left) {
            this.rotateRight(node.grandparent());
        } else {
            assert (node == node.parent.right && node.parent == node.grandparent().right);
            this.rotateLeft(node.grandparent());
        }
    }

    public void delete(K k) {
        Node node;
        Node<K, V> node2 = this.lookupNode(k);
        if (node2 == null) {
            return;
        }
        if (node2.left != null && node2.right != null) {
            node = RBTree.maximumNode(node2.left);
            node2.key = node.key;
            node2.value = node.value;
            node2 = node;
        }
        assert (node2.left == null || node2.right == null);
        Node node3 = node = node2.right == null ? node2.left : node2.right;
        if (RBTree.nodeColor(node2) == Color.BLACK) {
            node2.color = RBTree.nodeColor(node);
            this.deleteCase1(node2);
        }
        this.replaceNode(node2, node);
        if (RBTree.nodeColor(this.root) == Color.RED) {
            this.root.color = Color.BLACK;
        }
        this.verifyProperties();
    }

    private static <K extends Comparable<? super K>, V> Node<K, V> maximumNode(Node<K, V> node) {
        assert (node != null);
        while (node.right != null) {
            node = node.right;
        }
        return node;
    }

    private void deleteCase1(Node<K, V> node) {
        if (node.parent == null) {
            return;
        }
        this.deleteCase2(node);
    }

    private void deleteCase2(Node<K, V> node) {
        if (RBTree.nodeColor(node.sibling()) == Color.RED) {
            node.parent.color = Color.RED;
            node.sibling().color = Color.BLACK;
            if (node == node.parent.left) {
                this.rotateLeft(node.parent);
            } else {
                this.rotateRight(node.parent);
            }
        }
        this.deleteCase3(node);
    }

    private void deleteCase3(Node<K, V> node) {
        if (RBTree.nodeColor(node.parent) == Color.BLACK && RBTree.nodeColor(node.sibling()) == Color.BLACK && RBTree.nodeColor(node.sibling().left) == Color.BLACK && RBTree.nodeColor(node.sibling().right) == Color.BLACK) {
            node.sibling().color = Color.RED;
            this.deleteCase1(node.parent);
        } else {
            this.deleteCase4(node);
        }
    }

    private void deleteCase4(Node<K, V> node) {
        if (RBTree.nodeColor(node.parent) == Color.RED && RBTree.nodeColor(node.sibling()) == Color.BLACK && RBTree.nodeColor(node.sibling().left) == Color.BLACK && RBTree.nodeColor(node.sibling().right) == Color.BLACK) {
            node.sibling().color = Color.RED;
            node.parent.color = Color.BLACK;
        } else {
            this.deleteCase5(node);
        }
    }

    private void deleteCase5(Node<K, V> node) {
        if (node == node.parent.left && RBTree.nodeColor(node.sibling()) == Color.BLACK && RBTree.nodeColor(node.sibling().left) == Color.RED && RBTree.nodeColor(node.sibling().right) == Color.BLACK) {
            node.sibling().color = Color.RED;
            node.sibling().left.color = Color.BLACK;
            this.rotateRight(node.sibling());
        } else if (node == node.parent.right && RBTree.nodeColor(node.sibling()) == Color.BLACK && RBTree.nodeColor(node.sibling().right) == Color.RED && RBTree.nodeColor(node.sibling().left) == Color.BLACK) {
            node.sibling().color = Color.RED;
            node.sibling().right.color = Color.BLACK;
            this.rotateLeft(node.sibling());
        }
        this.deleteCase6(node);
    }

    private void deleteCase6(Node<K, V> node) {
        node.sibling().color = RBTree.nodeColor(node.parent);
        node.parent.color = Color.BLACK;
        if (node == node.parent.left) {
            assert (RBTree.nodeColor(node.sibling().right) == Color.RED);
            node.sibling().right.color = Color.BLACK;
            this.rotateLeft(node.parent);
        } else {
            assert (RBTree.nodeColor(node.sibling().left) == Color.RED);
            node.sibling().left.color = Color.BLACK;
            this.rotateRight(node.parent);
        }
    }

    public void print() {
        RBTree.printHelper(this.root, 0);
    }

    private static void printHelper(Node<?, ?> node, int n) {
        if (node == null) {
            System.out.print("<empty tree>");
            return;
        }
        if (node.right != null) {
            RBTree.printHelper(node.right, n + 4);
        }
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
        if (node.color == Color.BLACK) {
            System.out.println(node.key);
        } else {
            System.out.println("<" + node.key + ">");
        }
        if (node.left != null) {
            RBTree.printHelper(node.left, n + 4);
        }
    }
}

