/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.NoSolutionException;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.UnknownVarException;
import alice.tuprolog.Var;
import java.io.Serializable;
import java.util.List;

public class SolveInfo
implements Serializable {
    static final int HALT = -1;
    static final int FALSE = 0;
    static final int TRUE = 1;
    static final int TRUE_CP = 2;
    private int endState;
    private boolean isSuccess;
    private Term query;
    private Struct goal;
    private List<Var> bindings;

    SolveInfo(Term term) {
        this.query = term;
        this.isSuccess = false;
    }

    SolveInfo(Term term, Struct struct, int n, List<Var> list) {
        this.query = term;
        this.goal = struct;
        this.bindings = list;
        this.endState = n;
        this.isSuccess = this.endState > 0;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isHalted() {
        return this.endState == -1;
    }

    public boolean hasOpenAlternatives() {
        return this.endState == 2;
    }

    public Term getQuery() {
        return this.query;
    }

    public Term getSolution() throws NoSolutionException {
        if (this.isSuccess) {
            return this.goal;
        }
        throw new NoSolutionException();
    }

    public List<Var> getBindingVars() throws NoSolutionException {
        if (this.isSuccess) {
            return this.bindings;
        }
        throw new NoSolutionException();
    }

    public Term getTerm(String string) throws NoSolutionException, UnknownVarException {
        Term term = this.getVarValue(string);
        if (term == null) {
            throw new UnknownVarException();
        }
        return term;
    }

    public Term getVarValue(String string) throws NoSolutionException {
        if (this.isSuccess) {
            for (Var var : this.bindings) {
                if (var == null || !var.getName().equals(string)) continue;
                return var.getTerm();
            }
            return null;
        }
        throw new NoSolutionException();
    }

    public String toString() {
        if (this.isSuccess) {
            StringBuffer stringBuffer = new StringBuffer("yes");
            if (this.bindings.size() > 0) {
                stringBuffer.append(".\n");
            } else {
                stringBuffer.append(". ");
            }
            for (Var var : this.bindings) {
                if (var == null || var.isAnonymous() || !var.isBound() || var.getTerm() instanceof Var && ((Var)var.getTerm()).getName().startsWith("_")) continue;
                stringBuffer.append(var);
                stringBuffer.append("  ");
            }
            return stringBuffer.toString().trim();
        }
        if (this.endState == -1) {
            return "halt.";
        }
        return "no.";
    }
}

