/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Engine;
import alice.tuprolog.EngineRunner;
import alice.tuprolog.Int;
import alice.tuprolog.State;
import alice.tuprolog.Struct;
import alice.tuprolog.SubGoalTree;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import java.util.Iterator;
import java.util.List;

public class StateException
extends State {
    final Term catchTerm = Term.createTerm("catch(Goal, Catcher, Handler)");
    final Term javaCatchTerm = Term.createTerm("java_catch(Goal, List, Finally)");

    public StateException(EngineRunner engineRunner) {
        this.c = engineRunner;
        this.stateName = "Exception";
    }

    @Override
    void doJob(Engine engine) {
        String string = engine.currentContext.currentGoal.getName();
        if (string.equals("throw")) {
            this.prologError(engine);
        } else {
            this.javaException(engine);
        }
    }

    private void prologError(Engine engine) {
        Term term = engine.currentContext.currentGoal.getArg(0);
        engine.currentContext = engine.currentContext.fatherCtx;
        if (engine.currentContext == null) {
            engine.nextState = this.c.END_HALT;
            return;
        }
        do {
            if (engine.currentContext.currentGoal.match(this.catchTerm) && engine.currentContext.currentGoal.getArg(1).match(term)) {
                this.c.cut();
                List<Var> list = engine.currentContext.trailingVars.getHead();
                engine.currentContext.currentGoal.getArg(1).unify(list, list, term);
                Term term2 = engine.currentContext.currentGoal.getArg(2);
                Term term3 = term2.getTerm();
                if (!(term3 instanceof Struct)) {
                    engine.nextState = this.c.END_FALSE;
                    return;
                }
                if (term2 != term3) {
                    term2 = new Struct("call", term3);
                }
                Struct struct = (Struct)term2;
                this.c.identify(struct);
                SubGoalTree subGoalTree = new SubGoalTree();
                subGoalTree.addChild(struct);
                this.c.pushSubGoal(subGoalTree);
                engine.currentContext.currentGoal = struct;
                engine.nextState = this.c.GOAL_SELECTION;
                return;
            }
            engine.currentContext = engine.currentContext.fatherCtx;
        } while (engine.currentContext != null);
        engine.nextState = this.c.END_HALT;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void javaException(Engine engine) {
        Term term = engine.currentContext.currentGoal.getArg(0);
        engine.currentContext = engine.currentContext.fatherCtx;
        if (engine.currentContext == null) {
            engine.nextState = this.c.END_HALT;
            return;
        }
        do {
            if (engine.currentContext.currentGoal.match(this.javaCatchTerm) && this.javaMatch(engine.currentContext.currentGoal.getArg(1), term)) {
                this.c.cut();
                List<Var> list = engine.currentContext.trailingVars.getHead();
                Term term2 = this.javaUnify(engine.currentContext.currentGoal.getArg(1), term, list);
                if (term2 == null) {
                    engine.nextState = this.c.END_FALSE;
                    return;
                }
                Term term3 = term2.getTerm();
                if (!(term3 instanceof Struct)) {
                    engine.nextState = this.c.END_FALSE;
                    return;
                }
                Term term4 = engine.currentContext.currentGoal.getArg(2);
                Term term5 = term4.getTerm();
                boolean bl = true;
                if (term5 instanceof Int) {
                    Int intVal = (Int)term5;
                    if (intVal.intValue() != 0) {
                        engine.nextState = this.c.END_FALSE;
                        return;
                    }
                    bl = false;
                } else if (!(term5 instanceof Struct)) {
                    engine.nextState = this.c.END_FALSE;
                    return;
                }
                if (term2 != term3) {
                    term2 = new Struct("call", term3);
                }
                if (term4 != term5) {
                    term4 = new Struct("call", term5);
                }
                Struct struct = (Struct)term2;
                this.c.identify(struct);
                SubGoalTree subGoalTree = new SubGoalTree();
                subGoalTree.addChild(struct);
                if (bl) {
                    Struct struct2 = (Struct)term4;
                    this.c.identify(struct2);
                    subGoalTree.addChild(struct2);
                }
                this.c.pushSubGoal(subGoalTree);
                engine.currentContext.currentGoal = struct;
                engine.nextState = this.c.GOAL_SELECTION;
                return;
            }
            engine.currentContext = engine.currentContext.fatherCtx;
        } while (engine.currentContext != null);
        engine.nextState = this.c.END_HALT;
    }

    private boolean javaMatch(Term term, Term term2) {
        if (!term.isList()) {
            return false;
        }
        Struct struct = (Struct)term;
        if (struct.isEmptyList()) {
            return false;
        }
        Iterator<? extends Term> iterator = struct.listIterator();
        while (iterator.hasNext()) {
            Struct struct2;
            Term term3 = iterator.next();
            if (!term3.isCompound() || !(struct2 = (Struct)term3).getName().equals(",") || struct2.getArity() != 2 || !struct2.getArg(0).match(term2)) continue;
            return true;
        }
        return false;
    }

    private Term javaUnify(Term term, Term term2, List<Var> list) {
        Struct struct = (Struct)term;
        Iterator<? extends Term> iterator = struct.listIterator();
        while (iterator.hasNext()) {
            Struct struct2;
            Term term3 = iterator.next();
            if (!term3.isCompound() || !(struct2 = (Struct)term3).getName().equals(",") || struct2.getArity() != 2 || !struct2.getArg(0).match(term2)) continue;
            struct2.getArg(0).unify(list, list, term2);
            return struct2.getArg(1);
        }
        return null;
    }
}

