/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Engine;
import alice.tuprolog.EngineRunner;
import alice.tuprolog.HaltException;
import alice.tuprolog.JavaException;
import alice.tuprolog.PrimitiveInfo;
import alice.tuprolog.PrologError;
import alice.tuprolog.State;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;

public class StateGoalEvaluation
extends State {
    public StateGoalEvaluation(EngineRunner engineRunner) {
        this.c = engineRunner;
        this.stateName = "Eval";
    }

    @Override
    void doJob(Engine engine) {
        if (engine.currentContext.currentGoal.isPrimitive()) {
            PrimitiveInfo primitiveInfo = engine.currentContext.currentGoal.getPrimitive();
            try {
                engine.nextState = primitiveInfo.evalAsPredicate(engine.currentContext.currentGoal) ? this.c.GOAL_SELECTION : this.c.BACKTRACK;
            }
            catch (HaltException haltException) {
                engine.nextState = this.c.END_HALT;
            }
            catch (Throwable throwable) {
                if (throwable instanceof PrologError) {
                    PrologError prologError = (PrologError)throwable;
                    engine.currentContext.currentGoal = new Struct("throw", prologError.getError());
                    engine.manager.exception(prologError.toString());
                } else if (throwable instanceof JavaException) {
                    JavaException javaException = (JavaException)throwable;
                    engine.currentContext.currentGoal = new Struct("java_throw", (Term)javaException.getException());
                    engine.manager.exception(javaException.getException().toString());
                }
                engine.nextState = this.c.EXCEPTION;
            }
            ++engine.nDemoSteps;
        } else {
            engine.nextState = this.c.RULE_SELECTION;
        }
    }
}

