/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTermException;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Parser;
import alice.tuprolog.PrimitiveInfo;
import alice.tuprolog.StructIterator;
import alice.tuprolog.Term;
import alice.tuprolog.TermVisitor;
import alice.tuprolog.Var;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Struct
extends Term {
    private static final long serialVersionUID = 1L;
    private String name;
    private Term[] arg;
    private int arity;
    private String predicateIndicator;
    private transient PrimitiveInfo primitive;
    private boolean resolved = false;

    public Struct(String string) {
        this(string, 0);
    }

    public Struct(String string, Term term) {
        this(string, new Term[]{term});
    }

    public Struct(String string, Term term, Term term2) {
        this(string, new Term[]{term, term2});
    }

    public Struct(String string, Term term, Term term2, Term term3) {
        this(string, new Term[]{term, term2, term3});
    }

    public Struct(String string, Term term, Term term2, Term term3, Term term4) {
        this(string, new Term[]{term, term2, term3, term4});
    }

    public Struct(String string, Term term, Term term2, Term term3, Term term4, Term term5) {
        this(string, new Term[]{term, term2, term3, term4, term5});
    }

    public Struct(String string, Term term, Term term2, Term term3, Term term4, Term term5, Term term6) {
        this(string, new Term[]{term, term2, term3, term4, term5, term6});
    }

    public Struct(String string, Term term, Term term2, Term term3, Term term4, Term term5, Term term6, Term term7) {
        this(string, new Term[]{term, term2, term3, term4, term5, term6, term7});
    }

    public Struct(String string, Term[] termArray) {
        this(string, termArray.length);
        for (int i = 0; i < termArray.length; ++i) {
            if (termArray[i] == null) {
                throw new InvalidTermException("Arguments of a Struct cannot be null");
            }
            this.arg[i] = termArray[i];
        }
    }

    public Struct() {
        this("[]", 0);
        this.resolved = true;
    }

    public Struct(Term term, Term term2) {
        this(".", 2);
        this.arg[0] = term;
        this.arg[1] = term2;
    }

    public Struct(Term[] termArray) {
        this(termArray, 0);
    }

    private Struct(Term[] termArray, int n) {
        this(".", 2);
        if (n < termArray.length) {
            this.arg[0] = termArray[n];
            this.arg[1] = new Struct(termArray, n + 1);
        } else {
            this.name = "[]";
            this.arity = 0;
            this.arg = null;
        }
    }

    Struct(String string, LinkedList<Term> linkedList) {
        this.name = string;
        this.arity = linkedList.size();
        if (this.arity > 0) {
            this.arg = new Term[this.arity];
            for (int i = 0; i < this.arity; ++i) {
                this.arg[i] = linkedList.removeFirst();
            }
        }
        this.predicateIndicator = this.name + "/" + this.arity;
        this.resolved = false;
    }

    private Struct(int n) {
        this.arity = n;
        this.arg = new Term[this.arity];
    }

    private Struct(String string, int n) {
        if (string == null) {
            throw new InvalidTermException("The functor of a Struct cannot be null");
        }
        if (string.length() == 0 && n > 0) {
            throw new InvalidTermException("The functor of a non-atom Struct cannot be an empty string");
        }
        this.name = string;
        this.arity = n;
        if (this.arity > 0) {
            this.arg = new Term[this.arity];
        }
        this.predicateIndicator = this.name + "/" + this.arity;
        this.resolved = false;
    }

    String getHashKey() {
        return this.getPredicateIndicator();
    }

    String getPredicateIndicator() {
        return this.predicateIndicator;
    }

    public int getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public Term getArg(int n) {
        return this.arg[n];
    }

    void setArg(int n, Term term) {
        this.arg[n] = term;
    }

    public Term getTerm(int n) {
        if (!(this.arg[n] instanceof Var)) {
            return this.arg[n];
        }
        return this.arg[n].getTerm();
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Override
    public boolean isAtomic() {
        return this.arity == 0;
    }

    @Override
    public boolean isCompound() {
        return this.arity > 0;
    }

    @Override
    public boolean isAtom() {
        return this.arity == 0 || this.isEmptyList();
    }

    @Override
    public boolean isList() {
        return this.name.equals(".") && this.arity == 2 && this.arg[1].isList() || this.isEmptyList();
    }

    @Override
    public boolean isGround() {
        for (int i = 0; i < this.arity; ++i) {
            if (this.arg[i].isGround()) continue;
            return false;
        }
        return true;
    }

    public boolean isClause() {
        return this.name.equals(":-") && this.arity > 1 && this.arg[0].getTerm() instanceof Struct;
    }

    @Override
    public Term getTerm() {
        return this;
    }

    public Struct getArg(String string) {
        Struct struct;
        int n;
        if (this.arity == 0) {
            return null;
        }
        for (n = 0; n < this.arg.length; ++n) {
            if (!(this.arg[n] instanceof Struct) || !(struct = (Struct)this.arg[n]).getName().equals(string)) continue;
            return struct;
        }
        for (n = 0; n < this.arg.length; ++n) {
            Struct struct2;
            if (!(this.arg[n] instanceof Struct) || (struct2 = (struct = (Struct)this.arg[n]).getArg(string)) == null) continue;
            return struct2;
        }
        return null;
    }

    @Override
    public boolean isGreater(Term term) {
        if (!((term = term.getTerm()) instanceof Struct)) {
            return true;
        }
        Struct struct = (Struct)term;
        int n = struct.arity;
        if (this.arity > n) {
            return true;
        }
        if (this.arity == n) {
            if (this.name.compareTo(struct.name) > 0) {
                return true;
            }
            if (this.name.compareTo(struct.name) == 0) {
                for (int i = 0; i < this.arity; ++i) {
                    if (this.arg[i].isGreater(struct.arg[i])) {
                        return true;
                    }
                    if (this.arg[i].isEqual(struct.arg[i])) continue;
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEqual(Term term) {
        if ((term = term.getTerm()) instanceof Struct) {
            Struct struct = (Struct)term;
            if (this.arity == struct.arity && this.name.equals(struct.name)) {
                for (int i = 0; i < this.arity; ++i) {
                    if (this.arg[i].isEqual(struct.arg[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    Term copy(AbstractMap<Var, Var> abstractMap, int n) {
        Struct struct = new Struct(this.arity);
        struct.resolved = this.resolved;
        struct.name = this.name;
        struct.predicateIndicator = this.predicateIndicator;
        struct.primitive = this.primitive;
        for (int i = 0; i < this.arity; ++i) {
            struct.arg[i] = this.arg[i].copy(abstractMap, n);
        }
        return struct;
    }

    @Override
    Term copy(AbstractMap<Var, Var> abstractMap, AbstractMap<Term, Var> abstractMap2) {
        Struct struct = new Struct(this.arity);
        struct.resolved = false;
        struct.name = this.name;
        struct.predicateIndicator = this.predicateIndicator;
        struct.primitive = null;
        for (int i = 0; i < this.arity; ++i) {
            struct.arg[i] = this.arg[i].copy(abstractMap, abstractMap2);
        }
        return struct;
    }

    @Override
    long resolveTerm(long l) {
        if (this.resolved) {
            return l;
        }
        LinkedList<Var> linkedList = new LinkedList<Var>();
        return this.resolveTerm(linkedList, l);
    }

    long resolveTerm(LinkedList<Var> linkedList, long l) {
        long l2 = l;
        for (int i = 0; i < this.arity; ++i) {
            Term term = this.arg[i];
            if (term == null) continue;
            if ((term = term.getTerm()) instanceof Var) {
                Var var = (Var)term;
                var.setTimestamp(l2++);
                if (var.isAnonymous()) continue;
                String string = var.getName();
                Iterator iterator = linkedList.iterator();
                Var var2 = null;
                while (iterator.hasNext()) {
                    Var var3 = (Var)iterator.next();
                    if (!string.equals(var3.getName())) continue;
                    var2 = var3;
                    break;
                }
                if (var2 != null) {
                    this.arg[i] = var2;
                    continue;
                }
                linkedList.add(var);
                continue;
            }
            if (!(term instanceof Struct)) continue;
            l2 = ((Struct)term).resolveTerm(linkedList, l2);
        }
        this.resolved = true;
        return l2;
    }

    @Override
    public boolean isEmptyList() {
        return this.name.equals("[]") && this.arity == 0;
    }

    public Term listHead() {
        if (!this.isList()) {
            throw new UnsupportedOperationException("The structure " + this + " is not a list.");
        }
        return this.arg[0].getTerm();
    }

    public Struct listTail() {
        if (!this.isList()) {
            throw new UnsupportedOperationException("The structure " + this + " is not a list.");
        }
        return (Struct)this.arg[1].getTerm();
    }

    public int listSize() {
        if (!this.isList()) {
            throw new UnsupportedOperationException("The structure " + this + " is not a list.");
        }
        Struct struct = this;
        int n = 0;
        while (!struct.isEmptyList()) {
            ++n;
            struct = (Struct)struct.arg[1].getTerm();
        }
        return n;
    }

    public Iterator<? extends Term> listIterator() {
        if (!this.isList()) {
            throw new UnsupportedOperationException("The structure " + this + " is not a list.");
        }
        return new StructIterator(this);
    }

    Struct toList() {
        Struct struct = new Struct();
        for (int i = this.arity - 1; i >= 0; --i) {
            struct = new Struct(this.arg[i].getTerm(), (Term)struct);
        }
        return new Struct(new Struct(this.name), (Term)struct);
    }

    Struct fromList() {
        Term term = this.arg[0].getTerm();
        if (!term.isAtom()) {
            return null;
        }
        Struct struct = (Struct)this.arg[1].getTerm();
        LinkedList<Term> linkedList = new LinkedList<Term>();
        while (!struct.isEmptyList()) {
            if (!struct.isList()) {
                return null;
            }
            linkedList.addLast(struct.getTerm(0));
            struct = (Struct)struct.getTerm(1);
        }
        return new Struct(((Struct)term).name, linkedList);
    }

    public void append(Term term) {
        if (this.isEmptyList()) {
            this.name = ".";
            this.arity = 2;
            this.predicateIndicator = this.name + "/" + this.arity;
            this.arg = new Term[this.arity];
            this.arg[0] = term;
            this.arg[1] = new Struct();
        } else if (this.arg[1].isList()) {
            ((Struct)this.arg[1]).append(term);
        } else {
            this.arg[1] = term;
        }
    }

    void insert(Term term) {
        Struct struct = new Struct();
        struct.arg[0] = this.arg[0];
        struct.arg[1] = this.arg[1];
        this.arg[0] = term;
        this.arg[1] = struct;
    }

    @Override
    boolean unify(List<Var> list, List<Var> list2, Term term) {
        if ((term = term.getTerm()) instanceof Struct) {
            Struct struct = (Struct)term;
            if (this.arity == struct.arity && this.name.equals(struct.name)) {
                for (int i = 0; i < this.arity; ++i) {
                    if (this.arg[i].unify(list, list2, struct.arg[i])) continue;
                    return false;
                }
                return true;
            }
        } else if (term instanceof Var) {
            return term.unify(list2, list, this);
        }
        return false;
    }

    @Override
    public void free() {
    }

    void setPrimitive(PrimitiveInfo primitiveInfo) {
        this.primitive = primitiveInfo;
    }

    public PrimitiveInfo getPrimitive() {
        return this.primitive;
    }

    public boolean isPrimitive() {
        return this.primitive != null;
    }

    public String toString() {
        String string;
        if (this.isEmptyList()) {
            return "[]";
        }
        if (this.name.equals(".") && this.arity == 2) {
            return "[" + this.toString0() + "]";
        }
        if (this.name.equals("{}")) {
            return "{" + this.toString0_bracket() + "}";
        }
        String string2 = string = Parser.isAtom(this.name) ? this.name : "'" + this.name + "'";
        if (this.arity > 0) {
            string = string + "(";
            for (int i = 1; i < this.arity; ++i) {
                string = !(this.arg[i - 1] instanceof Var) ? string + this.arg[i - 1].toString() + "," : string + ((Var)this.arg[i - 1]).toStringFlattened() + ",";
            }
            string = !(this.arg[this.arity - 1] instanceof Var) ? string + this.arg[this.arity - 1].toString() + ")" : string + ((Var)this.arg[this.arity - 1]).toStringFlattened() + ")";
        }
        return string;
    }

    private String toString0() {
        Term term = this.arg[0].getTerm();
        Term term2 = this.arg[1].getTerm();
        if (term2.isList()) {
            Struct struct = (Struct)term2;
            if (struct.isEmptyList()) {
                return term.toString();
            }
            if (term instanceof Var) {
                return ((Var)term).toStringFlattened() + "," + struct.toString0();
            }
            return term.toString() + "," + struct.toString0();
        }
        String string = term instanceof Var ? ((Var)term).toStringFlattened() : term.toString();
        String string2 = term2 instanceof Var ? ((Var)term2).toStringFlattened() : term2.toString();
        return string + "|" + string2;
    }

    private String toString0_bracket() {
        if (this.arity == 0) {
            return "";
        }
        if (!(this.arity != 1 || this.arg[0] instanceof Struct && ((Struct)this.arg[0]).getName().equals(","))) {
            return this.arg[0].getTerm().toString();
        }
        Term term = ((Struct)this.arg[0]).getTerm(0);
        Term term2 = ((Struct)this.arg[0]).getTerm(1);
        StringBuffer stringBuffer = new StringBuffer(term.toString());
        while (term2 instanceof Struct && ((Struct)term2).getName().equals(",")) {
            term = ((Struct)term2).getTerm(0);
            stringBuffer.append("," + term.toString());
            term2 = ((Struct)term2).getTerm(1);
        }
        stringBuffer.append("," + term2.toString());
        return stringBuffer.toString();
    }

    private String toStringAsList(OperatorManager operatorManager) {
        Term term = this.arg[0];
        Term term2 = this.arg[1].getTerm();
        if (term2.isList()) {
            Struct struct = (Struct)term2;
            if (struct.isEmptyList()) {
                return term.toStringAsArgY(operatorManager, 0);
            }
            return term.toStringAsArgY(operatorManager, 0) + "," + struct.toStringAsList(operatorManager);
        }
        return term.toStringAsArgY(operatorManager, 0) + "|" + term2.toStringAsArgY(operatorManager, 0);
    }

    @Override
    String toStringAsArg(OperatorManager operatorManager, int n, boolean bl) {
        int n2 = 0;
        String string = "";
        if (this.name.equals(".") && this.arity == 2) {
            if (this.arg[0].isEmptyList()) {
                return "[]";
            }
            return "[" + this.toStringAsList(operatorManager) + "]";
        }
        if (this.name.equals("{}")) {
            return "{" + this.toString0_bracket() + "}";
        }
        if (this.arity == 2) {
            n2 = operatorManager.opPrio(this.name, "xfx");
            if (n2 >= 1) {
                return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.arg[0].toStringAsArgX(operatorManager, n2) + " " + this.name + " " + this.arg[1].toStringAsArgX(operatorManager, n2) + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
            }
            n2 = operatorManager.opPrio(this.name, "yfx");
            if (n2 >= 1) {
                return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.arg[0].toStringAsArgY(operatorManager, n2) + " " + this.name + " " + this.arg[1].toStringAsArgX(operatorManager, n2) + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
            }
            n2 = operatorManager.opPrio(this.name, "xfy");
            if (n2 >= 1) {
                if (!this.name.equals(",")) {
                    return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.arg[0].toStringAsArgX(operatorManager, n2) + " " + this.name + " " + this.arg[1].toStringAsArgY(operatorManager, n2) + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
                }
                return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.arg[0].toStringAsArgX(operatorManager, n2) + "," + this.arg[1].toStringAsArgY(operatorManager, n2) + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
            }
        } else if (this.arity == 1) {
            n2 = operatorManager.opPrio(this.name, "fx");
            if (n2 >= 1) {
                return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.name + " " + this.arg[0].toStringAsArgX(operatorManager, n2) + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
            }
            n2 = operatorManager.opPrio(this.name, "fy");
            if (n2 >= 1) {
                return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.name + " " + this.arg[0].toStringAsArgY(operatorManager, n2) + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
            }
            n2 = operatorManager.opPrio(this.name, "xf");
            if (n2 >= 1) {
                return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.arg[0].toStringAsArgX(operatorManager, n2) + " " + this.name + " " + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
            }
            n2 = operatorManager.opPrio(this.name, "yf");
            if (n2 >= 1) {
                return (bl && n2 >= n || !bl && n2 > n ? "(" : "") + this.arg[0].toStringAsArgY(operatorManager, n2) + " " + this.name + " " + (bl && n2 >= n || !bl && n2 > n ? ")" : "");
            }
        }
        String string2 = string = Parser.isAtom(this.name) ? this.name : "'" + this.name + "'";
        if (this.arity == 0) {
            return string;
        }
        string = string + "(";
        for (n2 = 1; n2 < this.arity; ++n2) {
            string = string + this.arg[n2 - 1].toStringAsArgY(operatorManager, 0) + ",";
        }
        string = string + this.arg[this.arity - 1].toStringAsArgY(operatorManager, 0);
        string = string + ")";
        return string;
    }

    @Override
    public Term iteratedGoalTerm() {
        if (this.name.equals("^") && this.arity == 2) {
            Term term = this.getTerm(1);
            return term.iteratedGoalTerm();
        }
        return super.iteratedGoalTerm();
    }

    @Override
    public void accept(TermVisitor termVisitor) {
        termVisitor.visit(this);
    }
}

