/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.EngineRunner;
import alice.tuprolog.Prolog;
import alice.tuprolog.Term;
import java.util.LinkedList;
import java.util.ListIterator;

public class TermQueue {
    private LinkedList<Term> queue = new LinkedList();

    public synchronized boolean get(Term term, Prolog prolog, EngineRunner engineRunner) {
        return this.searchLoop(term, prolog, true, true, engineRunner);
    }

    private synchronized boolean searchLoop(Term term, Prolog prolog, boolean bl, boolean bl2, EngineRunner engineRunner) {
        boolean bl3 = false;
        do {
            if (bl3 = this.search(term, prolog, bl2)) {
                return true;
            }
            engineRunner.setSolving(false);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        } while (bl);
        return false;
    }

    private synchronized boolean search(Term term, Prolog prolog, boolean bl) {
        boolean bl2 = false;
        Term term2 = null;
        ListIterator listIterator = this.queue.listIterator();
        while (!bl2) {
            if (!listIterator.hasNext()) {
                return false;
            }
            term2 = (Term)listIterator.next();
            bl2 = prolog.unify(term, term2);
        }
        if (bl) {
            this.queue.remove(term2);
        }
        return true;
    }

    public synchronized boolean peek(Term term, Prolog prolog) {
        return this.search(term, prolog, false);
    }

    public synchronized boolean remove(Term term, Prolog prolog) {
        return this.search(term, prolog, true);
    }

    public synchronized boolean wait(Term term, Prolog prolog, EngineRunner engineRunner) {
        return this.searchLoop(term, prolog, true, false, engineRunner);
    }

    public synchronized void store(Term term) {
        this.queue.addLast(term);
        this.notifyAll();
    }

    public synchronized int size() {
        return this.queue.size();
    }

    public synchronized void clear() {
        this.queue.clear();
    }
}

