/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.AbstractSubGoalTree;
import alice.tuprolog.ClauseDatabase;
import alice.tuprolog.ClauseInfo;
import alice.tuprolog.FamilyClausesList;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.PrimitiveManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.SubGoalElement;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.Var;
import alice.util.Tools;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class TheoryManager
implements Serializable {
    private ClauseDatabase dynamicDBase;
    private ClauseDatabase staticDBase;
    private Prolog engine;
    private PrimitiveManager primitiveManager;
    private Stack<Term> startGoalStack;
    Theory lastConsultedTheory;

    public void initialize(Prolog prolog) {
        this.dynamicDBase = new ClauseDatabase();
        this.staticDBase = new ClauseDatabase();
        this.lastConsultedTheory = new Theory();
        this.engine = prolog;
        this.primitiveManager = this.engine.getPrimitiveManager();
    }

    public synchronized void assertA(Struct struct, boolean bl, String string, boolean bl2) {
        ClauseInfo clauseInfo = new ClauseInfo(this.toClause(struct), string);
        String string2 = clauseInfo.getHead().getPredicateIndicator();
        if (bl) {
            this.dynamicDBase.addFirst(string2, clauseInfo);
            if (this.staticDBase.containsKey(string2)) {
                this.engine.warn("A static predicate with signature " + string2 + " has been overriden.");
            }
        } else {
            this.staticDBase.addFirst(string2, clauseInfo);
        }
        this.engine.spy("INSERTA: " + clauseInfo.getClause() + "\n");
    }

    public synchronized void assertZ(Struct struct, boolean bl, String string, boolean bl2) {
        ClauseInfo clauseInfo = new ClauseInfo(this.toClause(struct), string);
        String string2 = clauseInfo.getHead().getPredicateIndicator();
        if (bl) {
            this.dynamicDBase.addLast(string2, clauseInfo);
            if (this.staticDBase.containsKey(string2)) {
                this.engine.warn("A static predicate with signature " + string2 + " has been overriden.");
            }
        } else {
            this.staticDBase.addLast(string2, clauseInfo);
        }
        this.engine.spy("INSERTZ: " + clauseInfo.getClause() + "\n");
    }

    public synchronized ClauseInfo retract(Struct struct) {
        Struct struct2 = this.toClause(struct);
        Struct struct3 = (Struct)struct2.getArg(0);
        FamilyClausesList familyClausesList = (FamilyClausesList)this.dynamicDBase.get(struct3.getPredicateIndicator());
        if (familyClausesList == null) {
            return null;
        }
        Iterator<ClauseInfo> iterator = familyClausesList.iterator();
        while (iterator.hasNext()) {
            ClauseInfo clauseInfo = iterator.next();
            if (!struct2.match(clauseInfo.getClause())) continue;
            iterator.remove();
            this.engine.spy("DELETE: " + clauseInfo.getClause() + "\n");
            return new ClauseInfo(clauseInfo.getClause(), null);
        }
        return null;
    }

    public synchronized boolean abolish(Struct struct) {
        if (!(struct instanceof Struct) || !struct.isGround() || struct.getArity() != 2) {
            throw new IllegalArgumentException(struct + " is not a valid Struct");
        }
        if (!struct.getName().equals("/")) {
            throw new IllegalArgumentException(struct + " has not the valid predicate name. Espected '/' but was " + struct.getName());
        }
        String string = Tools.removeApices(struct.getArg(0).toString());
        String string2 = Tools.removeApices(struct.getArg(1).toString());
        String string3 = string + "/" + string2;
        FamilyClausesList familyClausesList = this.dynamicDBase.abolish(string3);
        if (familyClausesList != null) {
            this.engine.spy("ABOLISHED: " + string3 + " number of clauses=" + familyClausesList.size() + "\n");
        }
        return true;
    }

    public synchronized List<ClauseInfo> find(Term term) {
        if (term instanceof Struct) {
            List<ClauseInfo> list = this.dynamicDBase.getPredicates(term);
            if (list.isEmpty()) {
                list = this.staticDBase.getPredicates(term);
            }
            return list;
        }
        if (term instanceof Var) {
            throw new RuntimeException();
        }
        return new LinkedList<ClauseInfo>();
    }

    public synchronized void consult(Theory theory, boolean bl, String string) throws InvalidTheoryException {
        this.startGoalStack = new Stack();
        int n = 1;
        try {
            Iterator<? extends Term> iterator = theory.iterator(this.engine);
            while (iterator.hasNext()) {
                ++n;
                Struct struct = (Struct)iterator.next();
                if (this.runDirective(struct)) continue;
                this.assertZ(struct, bl, string, true);
            }
        }
        catch (InvalidTermException invalidTermException) {
            throw new InvalidTheoryException(invalidTermException.getMessage(), n, invalidTermException.line, invalidTermException.pos);
        }
        if (string == null) {
            this.lastConsultedTheory = theory;
        }
    }

    public void rebindPrimitives() {
        for (ClauseInfo clauseInfo : this.dynamicDBase) {
            for (AbstractSubGoalTree abstractSubGoalTree : clauseInfo.getBody()) {
                Term term = ((SubGoalElement)abstractSubGoalTree).getValue();
                this.primitiveManager.identifyPredicate(term);
            }
        }
    }

    public synchronized void clear() {
        this.dynamicDBase = new ClauseDatabase();
    }

    public synchronized void removeLibraryTheory(String string) {
        Iterator<ClauseInfo> iterator = this.staticDBase.iterator();
        while (iterator.hasNext()) {
            ClauseInfo clauseInfo = iterator.next();
            if (clauseInfo.libName == null || !string.equals(clauseInfo.libName)) continue;
            try {
                iterator.remove();
            }
            catch (Exception exception) {}
        }
    }

    private boolean runDirective(Struct struct) {
        if ("':-'".equals(struct.getName()) || ":-".equals(struct.getName()) && struct.getArity() == 1 && struct.getTerm(0) instanceof Struct) {
            Struct struct2 = (Struct)struct.getTerm(0);
            try {
                if (!this.primitiveManager.evalAsDirective(struct2)) {
                    this.engine.warn("The directive " + struct2.getPredicateIndicator() + " is unknown.");
                }
            }
            catch (Throwable throwable) {
                this.engine.warn("An exception has been thrown during the execution of the " + struct2.getPredicateIndicator() + " directive.\n" + throwable.getMessage());
            }
            return true;
        }
        return false;
    }

    private Struct toClause(Struct struct) {
        if (!(struct = (Struct)Term.createTerm(struct.toString(), this.engine.getOperatorManager())).isClause()) {
            struct = new Struct(":-", struct, new Struct("true"));
        }
        this.primitiveManager.identifyPredicate(struct);
        return struct;
    }

    public synchronized void solveTheoryGoal() {
        Struct struct = null;
        while (!this.startGoalStack.empty()) {
            struct = struct == null ? (Struct)this.startGoalStack.pop() : new Struct(",", (Struct)this.startGoalStack.pop(), struct);
        }
        if (struct != null) {
            try {
                this.engine.solve(struct);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void addStartGoal(Struct struct) {
        this.startGoalStack.push(struct);
    }

    synchronized boolean save(OutputStream outputStream, boolean bl) {
        try {
            new DataOutputStream(outputStream).writeBytes(this.getTheory(bl));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized String getTheory(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ClauseInfo clauseInfo : this.dynamicDBase) {
            stringBuffer.append(clauseInfo.toString(this.engine.getOperatorManager())).append("\n");
        }
        if (!bl) {
            for (ClauseInfo clauseInfo : this.staticDBase) {
                stringBuffer.append(clauseInfo.toString(this.engine.getOperatorManager())).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public synchronized Theory getLastConsultedTheory() {
        return this.lastConsultedTheory;
    }
}

