/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Parser;
import alice.tuprolog.Token;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedList;

public class Tokenizer
extends StreamTokenizer
implements Serializable {
    static final int TYPEMASK = 255;
    static final int ATTRMASK = 65280;
    static final int LPAR = 1;
    static final int RPAR = 2;
    static final int LBRA = 3;
    static final int RBRA = 4;
    static final int BAR = 5;
    static final int INTEGER = 6;
    static final int FLOAT = 7;
    static final int ATOM = 8;
    static final int VARIABLE = 9;
    static final int SQ_SEQUENCE = 10;
    static final int DQ_SEQUENCE = 11;
    static final int END = 13;
    static final int LBRA2 = 14;
    static final int RBRA2 = 15;
    static final int FUNCTOR = 256;
    static final int OPERATOR = 512;
    static final int EOF = 4096;
    static final char[] GRAPHIC_CHARS = new char[]{'\\', '$', '&', '?', '^', '@', '#', '.', ',', ':', ';', '=', '<', '>', '+', '-', '*', '/', '~'};
    private int tokenOffset;
    private int tokenStart;
    private int tokenLength;
    private String text = null;
    private LinkedList<Token> tokenList = new LinkedList();
    private PushBack pushBack2 = null;

    public Tokenizer(String string) {
        this(new StringReader(string));
        this.text = string;
        this.tokenOffset = -1;
    }

    public Tokenizer(Reader reader) {
        super(reader);
        this.resetSyntax();
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(95, 95);
        this.wordChars(48, 57);
        this.ordinaryChar(33);
        this.ordinaryChar(92);
        this.ordinaryChar(36);
        this.ordinaryChar(38);
        this.ordinaryChar(94);
        this.ordinaryChar(64);
        this.ordinaryChar(35);
        this.ordinaryChar(44);
        this.ordinaryChar(46);
        this.ordinaryChar(58);
        this.ordinaryChar(59);
        this.ordinaryChar(61);
        this.ordinaryChar(60);
        this.ordinaryChar(62);
        this.ordinaryChar(43);
        this.ordinaryChar(45);
        this.ordinaryChar(42);
        this.ordinaryChar(47);
        this.ordinaryChar(126);
        this.ordinaryChar(39);
        this.ordinaryChar(34);
        this.ordinaryChar(37);
    }

    public Token readToken() throws InvalidTermException, IOException {
        return !this.tokenList.isEmpty() ? this.tokenList.removeFirst() : this.readNextToken();
    }

    void unreadToken(Token token) {
        this.tokenList.addFirst(token);
    }

    Token readNextToken() throws IOException, InvalidTermException {
        int n;
        int n2;
        String string;
        int n3;
        if (this.pushBack2 != null) {
            n3 = this.pushBack2.typea;
            string = this.pushBack2.svala;
            this.pushBack2 = null;
        } else {
            n3 = this.tokenConsume();
            string = this.sval;
        }
        while (Tokenizer.isWhite(n3)) {
            n3 = this.tokenConsume();
            string = this.sval;
        }
        if (n3 == 37) {
            while ((n3 = this.tokenConsume()) != 13 && n3 != 10 && n3 != -1) {
            }
            this.tokenPushBack();
            return this.readNextToken();
        }
        if (n3 == 47) {
            n2 = this.tokenConsume();
            if (n2 == 42) {
                do {
                    n3 = n2;
                    n2 = this.tokenConsume();
                    if (n3 != -1 || n2 != -1) continue;
                    throw new InvalidTermException("Invalid multi-line comment statement");
                } while (n3 != 42 || n2 != 47);
                return this.readNextToken();
            }
            this.tokenPushBack();
        }
        this.tokenStart = this.tokenOffset - this.tokenLength + 1;
        if (n3 == -1) {
            return new Token("", 4096);
        }
        if (n3 == 40) {
            return new Token("(", 1);
        }
        if (n3 == 41) {
            return new Token(")", 2);
        }
        if (n3 == 123) {
            return new Token("{", 14);
        }
        if (n3 == 125) {
            return new Token("}", 15);
        }
        if (n3 == 91) {
            return new Token("[", 3);
        }
        if (n3 == 93) {
            return new Token("]", 4);
        }
        if (n3 == 124) {
            return new Token("|", 5);
        }
        if (n3 == 33) {
            return new Token("!", 8);
        }
        if (n3 == 44) {
            return new Token(",", 512);
        }
        if (n3 == 46) {
            n2 = this.tokenConsume();
            if (Tokenizer.isWhite(n2) || n2 == 37 || n2 == -1) {
                return new Token(".", 13);
            }
            this.tokenPushBack();
        }
        n2 = 0;
        if (n3 == -3) {
            n = string.charAt(0);
            if (Character.isUpperCase((char)n) || 95 == n) {
                return new Token(string, 9);
            }
            if (n >= 48 && n <= 57) {
                n2 = 1;
            } else {
                int n4 = this.tokenConsume();
                this.tokenPushBack();
                if (n4 == 40) {
                    return new Token(string, 264);
                }
                if (Tokenizer.isWhite(n4)) {
                    return new Token(string, 520);
                }
                return new Token(string, 8);
            }
        }
        if (n3 == 39 || n3 == 34 || n3 == 96) {
            int n5;
            n = n3;
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n6;
                n3 = this.tokenConsume();
                string = this.sval;
                if (n3 == 92) {
                    n6 = this.tokenConsume();
                    if (n6 == 10) continue;
                    if (n6 == 13) {
                        n5 = this.tokenConsume();
                        if (n5 == 10) continue;
                        this.tokenPushBack();
                        continue;
                    }
                    this.tokenPushBack();
                }
                if (n3 == n) {
                    n6 = this.tokenConsume();
                    if (n6 == n) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    break;
                }
                if (n3 == 10 || n3 == 13) {
                    throw new InvalidTermException("Line break in quote not allowed");
                }
                if (string != null) {
                    stringBuffer.append(string);
                    continue;
                }
                if (n3 < 0) {
                    throw new InvalidTermException("Invalid string");
                }
                stringBuffer.append((char)n3);
            }
            this.tokenPushBack();
            String string2 = stringBuffer.toString();
            int n7 = n == 39 ? 10 : (n = n == 34 ? 11 : 10);
            if (n == 10) {
                if (Parser.isAtom(string2)) {
                    n = 8;
                }
                n5 = this.tokenConsume();
                this.tokenPushBack();
                if (n5 == 40) {
                    return new Token(string2, n | 0x100);
                }
            }
            return new Token(string2, n);
        }
        if (Arrays.binarySearch(GRAPHIC_CHARS, (char)n3) >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n8 = n3;
            while (Arrays.binarySearch(GRAPHIC_CHARS, (char)n8) >= 0) {
                stringBuffer.append((char)n8);
                n8 = this.tokenConsume();
            }
            this.tokenPushBack();
            return new Token(stringBuffer.toString(), 512);
        }
        if (n2 != 0) {
            try {
                int n9;
                if (string.startsWith("0")) {
                    if (string.indexOf(98) == 1) {
                        return new Token("" + Long.parseLong(string.substring(2), 2), 6);
                    }
                    if (string.indexOf(111) == 1) {
                        return new Token("" + Long.parseLong(string.substring(2), 8), 6);
                    }
                    if (string.indexOf(120) == 1) {
                        return new Token("" + Long.parseLong(string.substring(2), 16), 6);
                    }
                }
                n = this.tokenConsume();
                String string3 = this.sval;
                if (n != 46 && n != 39) {
                    this.tokenPushBack();
                    return new Token("" + Long.parseLong(string), 6);
                }
                if (n == 39 && "0".equals(string)) {
                    String string4;
                    int n10 = this.tokenConsume();
                    int n11 = Tokenizer.isCharacterCodeConstantToken(n10, string4 = this.sval);
                    if (n11 != -1) {
                        return new Token("" + n11, 6);
                    }
                    throw new InvalidTermException("Character code constant starting with 0'<X> cannot be recognized.");
                }
                Long.parseLong(string);
                if (n != 46) {
                    throw new InvalidTermException("A number starting with 0-9 cannot be rcognized as an int and does not have a fraction '.'");
                }
                int n12 = this.tokenConsume();
                String string5 = this.sval;
                if (n12 != -3) {
                    this.tokenPushBack();
                    this.pushBack2 = new PushBack(n, string3);
                    return new Token(string, 6);
                }
                int n13 = string5.indexOf("E");
                if (n13 == -1) {
                    n13 = string5.indexOf("e");
                }
                if (n13 >= 1 && n13 == string5.length() - 1 && ((n9 = this.tokenConsume()) == 43 || n9 == 45)) {
                    int n14 = this.tokenConsume();
                    String string6 = this.sval;
                    if (n14 == -3) {
                        Long.parseLong(string5.substring(0, n13));
                        Integer.parseInt(string6);
                        return new Token(string + "." + string5 + (char)n9 + string6, 7);
                    }
                }
                Double.parseDouble(string + "." + string5);
                return new Token(string + "." + string5, 7);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidTermException("A term starting with 0-9 cannot be parsed as a number");
            }
        }
        throw new InvalidTermException("Unknown Unicode character: " + n3 + "  (" + string + ")");
    }

    @Override
    public int lineno() {
        return this.offsetToRowColumn(this.tokenOffset)[0];
    }

    public int tokenOffset() {
        return this.tokenOffset;
    }

    public int tokenStart() {
        return this.tokenStart;
    }

    public int[] offsetToRowColumn(int n) {
        if (this.text == null || this.text.length() <= 0) {
            return new int[]{super.lineno(), -1};
        }
        String string = this.removeTrailing(this.text, this.tokenOffset);
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < string.length() && i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
            n3 = i;
        }
        return new int[]{n2 + 1, n - n3};
    }

    String removeTrailing(String string, int n) {
        int n2 = n;
        String string2 = string;
        try {
            char c = string.charAt(n - 1);
            while (c == '\n') {
                string2 = string.substring(0, n2);
                c = string.charAt(--n2);
            }
            string2 = string2.concat(string.substring(n));
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private int tokenConsume() throws IOException {
        int n = super.nextToken();
        this.tokenLength = this.sval == null ? 1 : this.sval.length();
        this.tokenOffset += this.tokenLength;
        return n;
    }

    private void tokenPushBack() {
        super.pushBack();
        this.tokenOffset -= this.tokenLength;
    }

    private static int isCharacterCodeConstantToken(int n, String string) {
        if (string != null) {
            if (string.length() == 1) {
                return string.charAt(0);
            }
            if (string.length() > 1) {
                return -1;
            }
        }
        if (n == 32 || Arrays.binarySearch(GRAPHIC_CHARS, (char)n) >= 0) {
            return n;
        }
        return -1;
    }

    private static boolean isWhite(int n) {
        return n == 32 || n == 13 || n == 10 || n == 9 || n == 12;
    }

    static {
        Arrays.sort(GRAPHIC_CHARS);
    }

    private static class PushBack {
        int typea;
        String svala;

        public PushBack(int n, String string) {
            this.typea = n;
            this.svala = string;
        }
    }
}

