/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.AbstractSocket;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.TermVisitor;
import java.util.AbstractMap;
import java.util.List;

public class Var
extends Term {
    private static final long serialVersionUID = 1L;
    static final String ANY = "_";
    private String name;
    private StringBuilder completeName;
    private Term link;
    private long timestamp;
    private int id;
    static final int ORIGINAL = -1;
    static final int PROGRESSIVE = -2;

    public Var(String string) {
        this.link = null;
        this.id = -1;
        if (string.equals(ANY)) {
            this.name = null;
            this.completeName = new StringBuilder();
        } else if (Character.isUpperCase(string.charAt(0)) || string.startsWith(ANY)) {
            this.name = string;
            this.completeName = new StringBuilder(string);
        } else {
            throw new InvalidTermException("Illegal variable name: " + string);
        }
    }

    public Var() {
        this.name = null;
        this.completeName = new StringBuilder();
        this.link = null;
        this.id = -1;
        this.timestamp = 0L;
    }

    private Var(String string, int n, int n2, long l) {
        this.name = string;
        this.completeName = new StringBuilder();
        this.timestamp = l;
        this.link = null;
        if (n < 0) {
            n = -1;
        }
        this.rename(n, n2);
    }

    void rename(int n, int n2) {
        this.id = n;
        if (this.id > -1) {
            this.completeName = this.completeName.delete(0, this.completeName.length()).append(this.name).append("_e").append(this.id);
        } else if (this.id == -1) {
            this.completeName = this.completeName.delete(0, this.completeName.length()).append(this.name);
        } else if (this.id == -2) {
            this.completeName = this.completeName.delete(0, this.completeName.length()).append(ANY).append(n2);
        }
    }

    @Override
    Term copy(AbstractMap<Var, Var> abstractMap, int n) {
        Term term = this.getTerm();
        if (term == this) {
            Var var = abstractMap.get(this);
            if (var == null) {
                var = new Var(this.name, n, 0, this.timestamp);
                abstractMap.put(this, var);
            }
            return var;
        }
        return term.copy(abstractMap, n);
    }

    @Override
    Term copy(AbstractMap<Var, Var> abstractMap, AbstractMap<Term, Var> abstractMap2) {
        Var var;
        Var var2 = abstractMap.get(this);
        if (var2 == null) {
            var = new Var(null, -2, abstractMap.size(), this.timestamp);
            abstractMap.put(this, var);
        } else {
            var = var2;
        }
        Term term = this.getTerm();
        if (term instanceof Var) {
            Var var3 = abstractMap2.get(term);
            if (var3 == null) {
                abstractMap2.put(term, var);
                var.link = null;
            } else {
                Term term2 = var.link = var3 != var ? var3 : null;
            }
        }
        if (term instanceof Struct) {
            var.link = term.copy(abstractMap, abstractMap2);
        }
        if (term instanceof Number) {
            var.link = term;
        }
        return var;
    }

    @Override
    public void free() {
        this.link = null;
    }

    public static void free(List<Var> list) {
        for (Var var : list) {
            var.free();
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.completeName.toString();
        }
        return ANY;
    }

    public String getOriginalName() {
        if (this.name != null) {
            return this.name;
        }
        return ANY + this.hashCode();
    }

    @Override
    public Term getTerm() {
        Term term = this;
        Term term2 = this.link;
        while (term2 != null) {
            term = term2;
            if (!(term2 instanceof Var)) break;
            term2 = ((Var)term2).link;
        }
        return term;
    }

    Term getLink() {
        return this.link;
    }

    void setLink(Term term) {
        this.link = term;
    }

    void setTimestamp(long l) {
        this.timestamp = l;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isStruct() {
        return false;
    }

    @Override
    public boolean isVar() {
        return true;
    }

    @Override
    public boolean isEmptyList() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isEmptyList();
    }

    @Override
    public boolean isAtomic() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isAtomic();
    }

    @Override
    public boolean isCompound() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isCompound();
    }

    @Override
    public boolean isAtom() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isAtom();
    }

    @Override
    public boolean isList() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isList();
    }

    @Override
    public boolean isGround() {
        Term term = this.getTerm();
        if (term == this) {
            return false;
        }
        return term.isGround();
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public boolean isBound() {
        return this.link != null;
    }

    private boolean occurCheck(List<Var> list, Struct struct) {
        int n = struct.getArity();
        for (int i = 0; i < n; ++i) {
            Term term = struct.getTerm(i);
            if (term instanceof Struct) {
                if (!this.occurCheck(list, (Struct)term)) continue;
                return true;
            }
            if (!(term instanceof Var)) continue;
            Var var = (Var)term;
            if (var.link == null) {
                list.add(var);
            }
            if (this != var) continue;
            return true;
        }
        return false;
    }

    @Override
    long resolveTerm(long l) {
        Term term = this.getTerm();
        if (term != this) {
            return term.resolveTerm(l);
        }
        this.timestamp = l;
        return l++;
    }

    @Override
    boolean unify(List<Var> list, List<Var> list2, Term term) {
        Term term2 = this.getTerm();
        if (term2 == this) {
            if ((term = term.getTerm()) instanceof Var) {
                if (this == term) {
                    try {
                        list.add(this);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    return true;
                }
            } else if (term instanceof Struct ? this.occurCheck(list2, (Struct)term) : !(term instanceof Number) && !(term instanceof AbstractSocket)) {
                return false;
            }
            this.link = term;
            try {
                list.add(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        return term2.unify(list, list2, term);
    }

    @Override
    public boolean isGreater(Term term) {
        Term term2 = this.getTerm();
        if (term2 == this) {
            if (!((term = term.getTerm()) instanceof Var)) {
                return false;
            }
            return this.timestamp > ((Var)term).timestamp;
        }
        return term2.isGreater(term);
    }

    @Override
    public boolean isEqual(Term term) {
        Term term2 = this.getTerm();
        if (term2 == this) {
            return (term = term.getTerm()) instanceof Var && this.timestamp == ((Var)term).timestamp;
        }
        return term2.isEqual(term);
    }

    public String toString() {
        Term term = this.getTerm();
        if (this.name != null) {
            if (term == this) {
                return this.completeName.toString();
            }
            return this.completeName.toString() + " / " + term.toString();
        }
        if (term == this) {
            return ANY + this.hashCode();
        }
        return term.toString();
    }

    public String toStringFlattened() {
        Term term = this.getTerm();
        if (this.name != null) {
            if (term == this) {
                return this.completeName.toString();
            }
            return term.toString();
        }
        if (term == this) {
            return ANY + this.hashCode();
        }
        return term.toString();
    }

    @Override
    public void accept(TermVisitor termVisitor) {
        termVisitor.visit(this);
    }
}

