/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Agent;
import alice.tuprolog.Double;
import alice.tuprolog.Float;
import alice.tuprolog.Int;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.Operator;
import alice.tuprolog.PrologError;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.Var;
import alice.tuprolog.lib.TheoryLibrary;
import alice.util.Tools;
import java.util.Iterator;

public class BasicLibrary
extends Library {
    public boolean set_theory_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        try {
            Struct struct = (Struct)term;
            this.getEngine().setTheory(new Theory(struct.getName()));
            return true;
        }
        catch (InvalidTheoryException invalidTheoryException) {
            throw PrologError.syntax_error(this.engine.getEngineManager(), invalidTheoryException.clause, invalidTheoryException.line, invalidTheoryException.pos, new Struct(invalidTheoryException.getMessage()));
        }
    }

    public boolean add_theory_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        try {
            Struct struct = (Struct)term.getTerm();
            this.getEngine().addTheory(new Theory(struct.getName()));
            return true;
        }
        catch (InvalidTheoryException invalidTheoryException) {
            throw PrologError.syntax_error(this.engine.getEngineManager(), invalidTheoryException.clause, invalidTheoryException.line, invalidTheoryException.pos, new Struct(invalidTheoryException.getMessage()));
        }
    }

    public boolean get_theory_1(Term term) {
        term = term.getTerm();
        try {
            Struct struct = new Struct(this.getEngine().getTheory().toString());
            return this.unify(term, struct);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean load_library_from_theory_2(Term term, Term term2) {
        Struct struct = (Struct)term.getTerm();
        Struct struct2 = (Struct)term2.getTerm();
        try {
            if (!struct.isAtom()) {
                return false;
            }
            if (!struct2.isAtom()) {
                return false;
            }
            Theory theory = new Theory(struct.getName());
            TheoryLibrary theoryLibrary = new TheoryLibrary(struct2.getName(), theory);
            this.getEngine().loadLibrary(theoryLibrary);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean get_operators_list_1(Term term) {
        Term term2 = term.getTerm();
        Struct struct = new Struct();
        for (Operator operator : this.getEngine().getCurrentOperatorList()) {
            struct = new Struct(new Struct("op", new Int(operator.prio), new Struct(operator.type), new Struct(operator.name)), (Term)struct);
        }
        return this.unify(term2, struct);
    }

    public boolean agent_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        Struct struct = (Struct)term;
        try {
            new Agent(Tools.removeApices(struct.toString())).spawn();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean agent_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        if (!(term2 instanceof Struct)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "struct", term2);
        }
        Struct struct = (Struct)term;
        Struct struct2 = (Struct)term2;
        try {
            new Agent(Tools.removeApices(struct.toString()), struct2.toString() + ".").spawn();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean spy_0() {
        this.getEngine().setSpy(true);
        return true;
    }

    public boolean nospy_0() {
        this.getEngine().setSpy(false);
        return true;
    }

    public boolean trace_0() {
        return this.spy_0();
    }

    public boolean notrace_0() {
        return this.nospy_0();
    }

    public boolean warning_0() {
        this.getEngine().setWarning(true);
        return true;
    }

    public boolean nowarning_0() {
        this.getEngine().setWarning(false);
        return true;
    }

    public boolean constant_1(Term term) {
        term = term.getTerm();
        return term.isAtomic();
    }

    public boolean number_1(Term term) {
        return term.getTerm() instanceof Number;
    }

    public boolean integer_1(Term term) {
        if (!(term.getTerm() instanceof Number)) {
            return false;
        }
        Number number = (Number)term.getTerm();
        return number.isInteger();
    }

    public boolean float_1(Term term) {
        if (!(term instanceof Number)) {
            return false;
        }
        Number number = (Number)term.getTerm();
        return number.isReal();
    }

    public boolean atom_1(Term term) {
        term = term.getTerm();
        return term.isAtom();
    }

    public boolean compound_1(Term term) {
        term = term.getTerm();
        return term.isCompound();
    }

    public boolean list_1(Term term) {
        term = term.getTerm();
        return term.isList();
    }

    public boolean var_1(Term term) {
        term = term.getTerm();
        return term instanceof Var;
    }

    public boolean nonvar_1(Term term) {
        return !((term = term.getTerm()) instanceof Var);
    }

    public boolean atomic_1(Term term) {
        term = term.getTerm();
        return term.isAtomic();
    }

    public boolean ground_1(Term term) {
        term = term.getTerm();
        return term.isGround();
    }

    private void handleError(Throwable throwable, int n) throws PrologError {
        ArithmeticException arithmeticException;
        if (throwable instanceof ArithmeticException && (arithmeticException = (ArithmeticException)throwable).getMessage().equals("/ by zero")) {
            throw PrologError.evaluation_error(this.engine.getEngineManager(), n, "zero_divisor");
        }
    }

    public boolean expression_equality_2(Term term, Term term2) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 1);
        }
        try {
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 2);
        }
        if (term3 == null || !(term3 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "evaluable", term.getTerm());
        }
        if (term4 == null || !(term4 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "evaluable", term2.getTerm());
        }
        Number number = (Number)term3;
        Number number2 = (Number)term4;
        if (number.isInteger() && number2.isInteger()) {
            return number.longValue() == number2.longValue();
        }
        return number.doubleValue() == number2.doubleValue();
    }

    public boolean expression_greater_than_2(Term term, Term term2) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 1);
        }
        try {
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 2);
        }
        if (term3 == null || !(term3 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "evaluable", term.getTerm());
        }
        if (term4 == null || !(term4 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "evaluable", term2.getTerm());
        }
        return this.expression_greater_than((Number)term3, (Number)term4);
    }

    public boolean expression_less_or_equal_than_2(Term term, Term term2) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 1);
        }
        try {
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 2);
        }
        if (term3 == null || !(term3 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "evaluable", term.getTerm());
        }
        if (term4 == null || !(term4 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "evaluable", term2.getTerm());
        }
        return !this.expression_greater_than((Number)term3, (Number)term4);
    }

    private boolean expression_greater_than(Number number, Number number2) {
        if (number.isInteger() && number2.isInteger()) {
            return number.longValue() > number2.longValue();
        }
        return number.doubleValue() > number2.doubleValue();
    }

    public boolean expression_less_than_2(Term term, Term term2) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 1);
        }
        try {
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 2);
        }
        if (term3 == null || !(term3 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "evaluable", term.getTerm());
        }
        if (term4 == null || !(term4 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "evaluable", term2.getTerm());
        }
        return this.expression_less_than((Number)term3, (Number)term4);
    }

    public boolean expression_greater_or_equal_than_2(Term term, Term term2) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 1);
        }
        try {
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            this.handleError(throwable, 2);
        }
        if (term3 == null || !(term3 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "evaluable", term.getTerm());
        }
        if (term4 == null || !(term4 instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "evaluable", term2.getTerm());
        }
        return !this.expression_less_than((Number)term3, (Number)term4);
    }

    private boolean expression_less_than(Number number, Number number2) {
        if (number.isInteger() && number2.isInteger()) {
            return number.longValue() < number2.longValue();
        }
        return number.doubleValue() < number2.doubleValue();
    }

    public boolean term_equality_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        return term.isEqual(term2);
    }

    public boolean term_greater_than_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        return term.isGreater(term2);
    }

    public boolean term_less_than_2(Term term, Term term2) throws PrologError {
        return !(term = term.getTerm()).isGreater(term2 = term2.getTerm()) && !term.isEqual(term2);
    }

    public Term expression_plus_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 != null && term2 instanceof Number) {
            return term2;
        }
        return null;
    }

    public Term expression_minus_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 != null && term2 instanceof Number) {
            Number number = (Number)term2;
            if (number instanceof Int) {
                return new Int(number.intValue() * -1);
            }
            if (number instanceof Double) {
                return new Double(number.doubleValue() * -1.0);
            }
            if (number instanceof Long) {
                return new Long(number.longValue() * -1L);
            }
            if (number instanceof Float) {
                return new Float(number.floatValue() * -1.0f);
            }
            return null;
        }
        return null;
    }

    public Term expression_bitwise_not_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 != null && term2 instanceof Number) {
            return new Long(((Number)term2).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return null;
    }

    Number getIntegerNumber(long l) {
        if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            return new Int((int)l);
        }
        return new Long(l);
    }

    public Term expression_plus_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(number.longValue() + number2.longValue());
            }
            return new Double(number.doubleValue() + number2.doubleValue());
        }
        return null;
    }

    public Term expression_minus_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(number.longValue() - number2.longValue());
            }
            return new Double(number.doubleValue() - number2.doubleValue());
        }
        return null;
    }

    public Term expression_multiply_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(number.longValue() * number2.longValue());
            }
            return new Double(number.doubleValue() * number2.doubleValue());
        }
        return null;
    }

    public Term expression_div_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            if (number.isInteger() && number2.isInteger()) {
                return this.getIntegerNumber(number.longValue() / number2.longValue());
            }
            return new Double(number.doubleValue() / number2.doubleValue());
        }
        return null;
    }

    public Term expression_integer_div_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return this.getIntegerNumber(number.longValue() / number2.longValue());
        }
        return null;
    }

    public Term expression_pow_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Double(Math.pow(number.doubleValue(), number2.doubleValue()));
        }
        return null;
    }

    public Term expression_bitwise_shift_right_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Long(number.longValue() >> (int)number2.longValue());
        }
        return null;
    }

    public Term expression_bitwise_shift_left_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Long(number.longValue() << (int)number2.longValue());
        }
        return null;
    }

    public Term expression_bitwise_and_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Long(number.longValue() & number2.longValue());
        }
        return null;
    }

    public Term expression_bitwise_or_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 != null && term4 != null && term3 instanceof Number && term4 instanceof Number) {
            Number number = (Number)term3;
            Number number2 = (Number)term4;
            return new Long(number.longValue() | number2.longValue());
        }
        return null;
    }

    public boolean text_term_2(Term term, Term term2) {
        term = term.getTerm();
        term2 = term2.getTerm();
        this.getEngine().stdOutput(term.toString() + "\n" + term2.toString());
        if (!term.isGround()) {
            return this.unify(term, new Struct(term2.toString()));
        }
        try {
            String string = Tools.removeApices(term.toString());
            return this.unify(term2, this.getEngine().toTerm(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean text_concat_3(Term term, Term term2, Term term3) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        term3 = term3.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        if (!term2.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "atom", term2);
        }
        return this.unify(term3, new Struct(((Struct)term).getName() + ((Struct)term2).getName()));
    }

    public boolean num_atom_2(Term term, Term term2) throws PrologError {
        int n;
        int n2;
        int n3;
        term = term.getTerm();
        if ((term2 = term2.getTerm()) instanceof Var) {
            if (!(term instanceof Number)) {
                throw PrologError.type_error(this.engine.getEngineManager(), 1, "number", term);
            }
            Number number = (Number)term;
            String string = null;
            string = number.isInteger() ? new Integer(number.intValue()).toString() : new java.lang.Double(number.doubleValue()).toString();
            return this.unify(term2, new Struct(string));
        }
        if (!term2.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "atom", term2);
        }
        String string = ((Struct)term2).getName();
        String string2 = "";
        for (n3 = 0; n3 < string.length(); ++n3) {
            String string3;
            string2 = string2 + string.charAt(n3);
            if (string.charAt(0) == '0' && string.charAt(1) == '\'' && string.charAt(2) == '\'' && string.length() == 4) {
                string3 = "" + string.charAt(3);
                byte[] byArray = string3.getBytes();
                string2 = "" + byArray[0];
            }
            if (string.charAt(0) != '0' || string.charAt(1) != 'x' || string.charAt(2) < 'a' || string.charAt(2) > 'f' || string.length() != 3) continue;
            string3 = "" + string.charAt(2);
            int n4 = Integer.parseInt(string3, 16);
            string2 = "" + n4;
        }
        n3 = 1;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        String string4 = null;
        String string5 = "";
        for (n2 = 0; n2 < string2.length(); ++n2) {
            if ((string2.charAt(n2) < '0' || string2.charAt(n2) > '9') && n3 != 0) {
                ++n5;
            }
            bl2 = false;
            if (string2.charAt(n2) >= '0' && string2.charAt(n2) <= '9') {
                n = 0;
                for (int i = n2 + 1; i < string2.length(); ++i) {
                    if (string2.charAt(i) >= '0' && string2.charAt(i) <= '9' && i - n2 > 1) {
                        n7 += 2;
                        string5 = "" + (n += n2 + 1) + i;
                        n2 += i;
                        i = string2.length();
                        bl2 = true;
                        continue;
                    }
                    if (string2.charAt(i) < '0' || string2.charAt(i) > '9' || i - n2 != 1) continue;
                    ++n;
                }
                if (!bl2) {
                    n3 = 0;
                    bl = true;
                } else {
                    n3 = 0;
                }
            }
            if (string2.charAt(n2) >= '0' && string2.charAt(n2) <= '9' || !bl) continue;
            ++n6;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (string2.charAt(n2) == ' ') {
                string4 = string2.substring(n2 + 1, string2.length());
                continue;
            }
            if (string2.charAt(n2) == '\\' && (string2.charAt(n2 + 1) == 'n' || string2.charAt(n2 + 1) == 't')) {
                string4 = string2.substring(n2 + 2, string2.length());
                ++n2;
                continue;
            }
            if (string2.charAt(n2) == '-' || string2.charAt(n2) == '+') continue;
            string4 = "";
        }
        for (n2 = 0; n2 < n7; n2 += 2) {
            for (n = Integer.parseInt(new StringBuilder().append("").append(string5.charAt(n2)).toString()); n < Integer.parseInt("" + string5.charAt(n2 + 1)); ++n) {
                if (string2.charAt(n) == '.' || string2.charAt(n2) == 'E' && (string2.charAt(n2) == 'E' || string2.charAt(n2 + 1) == '+' && string2.charAt(n2 + 1) == '-') || string2.charAt(n2) == 'e' && (string2.charAt(n2) == 'e' || string2.charAt(n2 + 1) == '+' && string2.charAt(n2 + 1) == '-')) continue;
                string4 = "";
            }
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (string2.charAt(n2) == 'E' && (string2.charAt(n2) == 'E' || string2.charAt(n2 + 1) == '+' && string2.charAt(n2 + 1) == '-') || string2.charAt(n2) == '.' || string2.charAt(n2) == 'e' && (string2.charAt(n2) == 'e' || string2.charAt(n2 + 1) == '+' && string2.charAt(n2 + 1) == '-')) continue;
            string4 = "";
        }
        if (string4 != null) {
            string2 = string4;
        }
        Number number = null;
        try {
            number = new Int(Integer.parseInt(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (number == null) {
            try {
                number = new Double(java.lang.Double.parseDouble(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (number == null) {
            throw PrologError.domain_error(this.engine.getEngineManager(), 2, "num_atom", term2);
        }
        return this.unify(term, number);
    }

    public boolean throw_1(Term term) throws PrologError {
        throw new PrologError(term);
    }

    @Override
    public String getTheory() {
        return "':-'(op( 1200, fx,   ':-')). \n:- op( 1200, xfx,  ':-'). \n:- op( 1200, fx,   '?-'). \n:- op( 1100, xfy,  ';'). \n:- op( 1050, xfy,  '->'). \n:- op( 1000, xfy,  ','). \n:- op(  900, fy,   '\\+'). \n:- op(  900, fy,   'not'). \n:- op(  700, xfx,  '='). \n:- op(  700, xfx,  '\\='). \n:- op(  700, xfx,  '=='). \n:- op(  700, xfx,  '\\=='). \n:- op(  700, xfx,  '@>'). \n:- op(  700, xfx,  '@<'). \n:- op(  700, xfx,  '@=<'). \n:- op(  700, xfx,  '@>='). \n:- op(  700, xfx,  '=:='). \n:- op(  700, xfx,  '=\\='). \n:- op(  700, xfx,  '>'). \n:- op(  700, xfx,  '<'). \n:- op(  700, xfx,  '=<'). \n:- op(  700, xfx,  '>='). \n:- op(  700, xfx,  'is'). \n:- op(  700, xfx,  '=..'). \n:- op(  500, yfx,  '+'). \n:- op(  500, yfx,  '-'). \n:- op(  500, yfx,  '/\\'). \n:- op(  500, yfx,  '\\/'). \n:- op(  400, yfx,  '*'). \n:- op(  400, yfx,  '/'). \n:- op(  400, yfx,  '//'). \n:- op(  400, yfx,  '>>'). \n:- op(  400, yfx,  '<<'). \n:- op(  400, yfx,  'rem'). \n:- op(  400, yfx,  'mod'). \n:- op(  200, xfx,  '**'). \n:- op(  200, xfy,  '^'). \n:- op(  200, fy,   '\\'). \n:- op(  200, fy,   '-'). \ncurrent_prolog_flag(Name,Value) :- catch(get_prolog_flag(Name,Value), Error, false),!.\ncurrent_prolog_flag(Name,Value) :- flag_list(L), member(flag(Name,Value),L).\n'=:='(X,Y):- expression_equality(X,Y). \n'=\\='(X,Y):- not expression_equality(X,Y). \n'>'(X,Y):- expression_greater_than(X,Y). \n'<'(X,Y):- expression_less_than(X,Y). \n'>='(X,Y):- expression_greater_or_equal_than(X,Y). \n'=<'(X,Y):- expression_less_or_equal_than(X,Y). \n'=='(X,Y):- term_equality(X,Y).\n'\\=='(X,Y):- not term_equality(X,Y).\n'@>'(X,Y):- term_greater_than(X,Y).\n'@<'(X,Y):- term_less_than(X,Y).\n'@>='(X,Y):- not term_less_than(X,Y).\n'@=<'(X,Y):- not term_greater_than(X,Y).\n'=..'(T, [T]) :- atomic(T), !. \n                                                          '=..'(T,L)  :- compound(T),!, '$tolist'(T,L). \n                                                          '=..'(T,L)  :- nonvar(L), catch('$fromlist'(T,L),Error,false). \n                                                          functor(Term, Name, Arity) :- atomic(Term), !, Name = Term, Arity = 0. \nfunctor(Term, Name, Arity) :- compound(Term), !, Term =.. [Name | Args], length(Args, Arity). \nfunctor(Term, Name, Arity) :- var(Term), atomic(Name), Arity == 0, !, Term = Name. \nfunctor(Term, Name, Arity) :- var(Term), atom(Name), integer(Arity), Arity > 0, current_prolog_flag(max_arity, Max), Arity=<Max, !, newlist([], Arity, L), Term =.. [Name | L]. \narg(N,C,T):- arg_guard(N,C,T), C =.. [_|Args], element(N,Args,T).\nclause(H, B) :- clause_guard(H,B), L = [], '$find'(H, L), copy_term(L, LC), member((':-'(H, B)), LC). \ncall(G) :- call_guard(G), '$call'(G). \n'\\+'(P):- P,!,fail.\n                                                                            '\\+'(_).\n                                                                                             C -> T ; B :- !, or((call(C), !, call(T)), '$call'(B)). \nC -> T :- call(C), !, call(T). \nor(A, B) :- '$call'(A). \nor(A, B) :- '$call'(B). \nA ; B :- A =.. ['->', C, T], !, ('$call'(C), !, '$call'(T) ; '$call'(B)). \nA ; B :- '$call'(A). \nA ; B :- '$call'(B). \n unify_with_occurs_check(X,Y):- !,X=Y.\ncurrent_op(Pri,Type,Name):-get_operators_list(L),member(op(Pri,Type,Name),L).\n                          once(X) :- myonce(X).\n                                                                                  myonce(X):-X,!.\n                                                                                        repeat. \n                                                                                              repeat        :- repeat. \n                                                                             not(G)        :- G,!,fail. \n                                                                     not(_). \n                                                                                              catch(Goal, Catcher, Handler) :- call(Goal).\nfindall(Template, Goal, Instances) :- \nall_solutions_predicates_guard(Template, Goal, Instances), \nL = [], \n'$findall0'(Template, Goal, L), \nInstances = L. \n'$findall0'(Template, Goal, L) :- \ncall(Goal), \ncopy_term(Template, CL), \n'$append'(CL, L), \nfail. \n'$findall0'(_, _, _). \nvariable_set(T, []) :- atomic(T), !. \nvariable_set(T, [T]) :- var(T), !. \nvariable_set([H | T], [SH | ST]) :- \nvariable_set(H, SH), variable_set(T, ST). \nvariable_set(T, S) :- \nT =.. [_ | Args], variable_set(Args, L), flatten(L, FL), no_duplicates(FL, S), !. \nflatten(L, FL) :- '$flatten0'(L, FL), !. \n'$flatten0'(T, []) :- nonvar(T), T = []. \n'$flatten0'(T, [T]) :- var(T). \n'$flatten0'([H | T], [H | FT]) :- \nnot(islist(H)), !, '$flatten0'(T, FT). \n'$flatten0'([H | T], FL) :- \n'$flatten0'(H, FH), '$flatten0'(T, FT), append(FH, FT, FL). \nislist([]). \nislist([_|L]):- islist(L). \n existential_variables_set(Term, Set) :- '$existential_variables_set0'(Term, Set), !. \n'$existential_variables_set0'(Term, []) :- var(Term), !. \n'$existential_variables_set0'(Term, []) :- atomic(Term), !. \n'$existential_variables_set0'(V ^ G, Set) :- \nvariable_set(V, VS), '$existential_variables_set0'(G, EVS), append(VS, EVS, Set). \n'$existential_variables_set0'(Term, []) :- nonvar(Term), !. \nfree_variables_set(Term, WithRespectTo, Set) :- \nvariable_set(Term, VS), \nvariable_set(WithRespectTo, VS1), existential_variables_set(Term, EVS1), append(VS1, EVS1, BV), \nlist_difference(VS, BV, List), no_duplicates(List, Set), !. \nlist_difference(List, Subtrahend, Difference) :- '$ld'(List, Subtrahend, Difference). \n'$ld'([], _, []). \n'$ld'([H | T], S, D) :- is_member(H, S), !, '$ld'(T, S, D). \n'$ld'([H | T], S, [H | TD]) :- '$ld'(T, S, TD). \nno_duplicates([], []). \nno_duplicates([H | T], L) :- is_member(H, T), !, no_duplicates(T, L). \nno_duplicates([H | T], [H | L]) :- no_duplicates(T, L). \nis_member(E, [H | _]) :- E == H, !. \nis_member(E, [_ | T]) :- is_member(E, T). \n'$wt_list'([], []). \n'$wt_list'([W + T | STail], [WW + T | WTTail]) :- copy_term(W, WW), '$wt_list'(STail, WTTail). \n'$s_next'(Witness, WT_List, S_Next) :- copy_term(Witness, W2), '$s_next0'(W2, WT_List, S_Next), !. \nbagof(Template, Goal, Instances) :- \nall_solutions_predicates_guard(Template, Goal, Instances), \nfree_variables_set(Goal, Template, Set), \nWitness =.. [witness | Set], \niterated_goal_term(Goal, G), \nfindall(Witness + Template, G, S), \n'$bagof0'(Witness, S, Instances). \n'$bagof0'(_, [], _) :- !, fail. \n'$bagof0'(Witness, S, Instances) :- \n'$wt_list'(S, WT_List), \n'$wt_unify'(Witness, WT_List, T_List), \nInstances = T_List. \n'$bagof0'(Witness, S, Instances) :- \n'$wt_list'(S, WT_List), \n'$s_next'(Witness, WT_List, S_Next), \n'$bagof0'(Witness, S_Next, Instances). \nsetof(Template, Goal, Instances) :- \nall_solutions_predicates_guard(Template, Goal, Instances), \nbagof(Template, Goal, List), \nquicksort(List, '@<', OrderedList), \nno_duplicates(OrderedList, Instances). \nassert(C) :- assertz(C). \nretract(Rule) :- retract_guard(Rule), Rule = ':-'(Head, Body), !, clause(Head, Body), '$retract'(Rule). \nretract(Fact) :- retract_guard(Fact), clause(Fact, true), '$retract'(Fact). \nretractall(Head) :- retract_guard(Head), findall(':-'(Head, Body), clause(Head, Body), L), '$retract_clause_list'(L), !. \n'$retract_clause_list'([]). \n'$retract_clause_list'([E | T]) :- !, '$retract'(E), '$retract_clause_list'(T). \n member(E,L) :- member_guard(E,L), member0(E,L).\n                                                                                     member0(E,[E|_]). \n                                                                       member0(E,[_|L]):- member0(E,L). \n                                                                       length(L, S) :- number(S), !, lengthN(L, S), !. \nlength(L, S) :- var(S), lengthX(L, S). \nlengthN([],0). \nlengthN(_, N) :- N < 0, !, fail. \nlengthN([_|L], N) :- M is N - 1, lengthN(L,M). \nlengthX([],0). \nlengthX([_|L], N) :- lengthX(L,M), N is M + 1. \nappend([],L2,L2). \n                                                                                    append([E|T1],L2,[E|T2]):- append(T1,L2,T2). \n                                                         reverse(L1,L2):- reverse_guard(L1,L2), reverse0(L1,[],L2). \n                                                                 reverse0([],Acc,Acc). \n                                                                                reverse0([H|T],Acc,Y):- reverse0(T,[H|Acc],Y). \n                                                       delete(E,S,D) :- delete_guard(E,S,D), delete0(E,S,D). \n                                                                                     delete0(E,[],[]). \n                                                                                     delete0(E,[E|T],L):- !,delete0(E,T,L). \n                                                                 delete0(E,[H|T],[H|L]):- delete0(E,T,L). \n                                                               element(P,L,E):- element_guard(P,L,E), element0(P,L,E). \n                                                                              element0(1,[E|L],E):- !. \n                                                                              element0(N,[_|L],E):- M is N - 1,element0(M,L,E). \n                                                      newlist(Ls,0,Ls):- !. \n                                                                                newlist(Ls,N,Ld):- !, append(X,Ls,Ld), length(X,N). \n                                                                                newlist(Ls,N,Ld):- M is N - 1,newlist([_|Ls],M,Ld). \n                                                  quicksort([],Pred,[]).                             \nquicksort([X|Tail],Pred,Sorted):-                  \n   split(X,Tail,Pred,Small,Big),                   \n   quicksort(Small,Pred,SortedSmall),              \n   quicksort(Big,Pred,SortedBig),                  \n   append(SortedSmall,[X|SortedBig],Sorted).       \nsplit(_,[],_,[],[]).                               \nsplit(X,[Y|Tail],Pred,Small,[Y|Big]):-             \n   Predicate =..[Pred,X,Y],                        \n   call(Predicate),!,                              \n   split(X,Tail,Pred,Small,Big).                   \nsplit(X,[Y|Tail],Pred,[Y|Small],Big):-             \n   split(X,Tail,Pred,Small,Big).                   \n";
    }

    public boolean arg_guard_3(Term term, Term term2, Term term3) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!(term instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        if (!term2.isCompound()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "compound", term2);
        }
        Int intVal = (Int)term;
        if (intVal.intValue() < 1) {
            throw PrologError.domain_error(this.engine.getEngineManager(), 1, "greater_than_zero", term);
        }
        return true;
    }

    public boolean clause_guard_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        return true;
    }

    public boolean call_guard_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom() && !term.isCompound()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "callable", term);
        }
        return true;
    }

    public boolean all_solutions_predicates_guard_3(Term term, Term term2, Term term3) throws PrologError {
        if ((term2 = term2.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!term2.isAtom() && !term2.isCompound()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "callable", term2);
        }
        return true;
    }

    public boolean retract_guard_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!(term instanceof Struct)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "clause", term);
        }
        return true;
    }

    public boolean member_guard_2(Term term, Term term2) throws PrologError {
        if (!((term2 = term2.getTerm()) instanceof Var) && !term2.isList()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "list", term2);
        }
        return true;
    }

    public boolean reverse_guard_2(Term term, Term term2) throws PrologError {
        if (!((term = term.getTerm()) instanceof Var) && !term.isList()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "list", term);
        }
        return true;
    }

    public boolean delete_guard_3(Term term, Term term2, Term term3) throws PrologError {
        if (!((term2 = term2.getTerm()) instanceof Var) && !term2.isList()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "list", term2);
        }
        return true;
    }

    public boolean element_guard_3(Term term, Term term2, Term term3) throws PrologError {
        if (!((term2 = term2.getTerm()) instanceof Var) && !term2.isList()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "list", term2);
        }
        return true;
    }

    public boolean $wt_unify_3(Term term, Term term2, Term term3) {
        Struct struct = (Struct)term2.getTerm();
        Struct struct2 = new Struct();
        Iterator<? extends Term> iterator = struct.listIterator();
        while (iterator.hasNext()) {
            Struct struct3 = (Struct)iterator.next();
            Term term4 = struct3.getArg(0);
            Term term5 = struct3.getArg(1);
            if (!this.unify(term, term4)) continue;
            struct2.append(term5);
        }
        return this.unify(term3, struct2);
    }

    public boolean $s_next0_3(Term term, Term term2, Term term3) {
        Struct struct = (Struct)term2.getTerm();
        Struct struct2 = new Struct();
        Iterator<? extends Term> iterator = struct.listIterator();
        while (iterator.hasNext()) {
            Struct struct3 = (Struct)iterator.next();
            Term term4 = struct3.getArg(0);
            if (this.unify(term, term4)) continue;
            struct2.append(struct3);
        }
        return this.unify(term3, struct2);
    }

    public boolean iterated_goal_term_2(Term term, Term term2) {
        Term term3 = term.getTerm();
        Term term4 = term3.iteratedGoalTerm();
        return this.unify(term4, term2);
    }

    @Override
    public String[][] getSynonymMap() {
        return new String[][]{{"+", "expression_plus", "functor"}, {"-", "expression_minus", "functor"}, {"*", "expression_multiply", "functor"}, {"/", "expression_div", "functor"}, {"**", "expression_pow", "functor"}, {">>", "expression_bitwise_shift_right", "functor"}, {"<<", "expression_bitwise_shift_left", "functor"}, {"/\\", "expression_bitwise_and", "functor"}, {"\\/", "expression_bitwise_or", "functor"}, {"//", "expression_integer_div", "functor"}, {"\\", "expression_bitwise_not", "functor"}};
    }
}

