/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Double;
import alice.tuprolog.Int;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Library;
import alice.tuprolog.Number;
import alice.tuprolog.PrologError;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Random;

public class IOLibrary
extends Library {
    protected String inputStreamName = "stdin";
    protected InputStream inputStream = System.in;
    protected String outputStreamName = "stdout";
    protected OutputStream outputStream = System.out;
    private Random gen = new Random();

    public IOLibrary() {
        this.gen.setSeed(System.currentTimeMillis());
    }

    public boolean see_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        Struct struct = (Struct)term.getTerm();
        if (this.inputStream != System.in) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (struct.getName().equals("stdin")) {
            this.inputStream = System.in;
        } else {
            try {
                this.inputStream = new FileInputStream(struct.getName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw PrologError.domain_error(this.engine.getEngineManager(), 1, "stream", struct);
            }
        }
        this.inputStreamName = struct.getName();
        return true;
    }

    public boolean seen_0() {
        if (this.inputStream != System.in) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                return false;
            }
            this.inputStream = System.in;
            this.inputStreamName = "stdin";
        }
        return true;
    }

    public boolean seeing_1(Term term) {
        return this.unify(term, new Struct(this.inputStreamName));
    }

    public boolean tell_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        Struct struct = (Struct)term.getTerm();
        if (this.outputStream != System.out) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (struct.getName().equals("stdout")) {
            this.outputStream = System.out;
        } else {
            try {
                this.outputStream = new FileOutputStream(struct.getName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw PrologError.domain_error(this.engine.getEngineManager(), 1, "stream", term);
            }
        }
        this.outputStreamName = struct.getName();
        return true;
    }

    public boolean told_0() {
        if (this.outputStream != System.out) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                return false;
            }
            this.outputStream = System.out;
            this.outputStreamName = "stdout";
        }
        return true;
    }

    public boolean telling_1(Term term) {
        return this.unify(term, new Struct(this.outputStreamName));
    }

    public boolean put_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "character", term);
        }
        Struct struct = (Struct)term.getTerm();
        String string = struct.getName();
        if (string.length() > 1) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "character", term);
        }
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput(string);
        } else {
            try {
                this.outputStream.write((byte)string.charAt(0));
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
            }
        }
        return true;
    }

    public boolean get0_1(Term term) throws PrologError {
        int n = -2;
        try {
            n = this.inputStream.read();
        }
        catch (IOException iOException) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "stream", new Struct(this.inputStreamName), new Struct(iOException.getMessage()));
        }
        if (n == -1) {
            return this.unify(term, new Int(-1));
        }
        return this.unify(term, new Struct(new Character((char)n).toString()));
    }

    public boolean get_1(Term term) throws PrologError {
        int n = 0;
        do {
            try {
                n = this.inputStream.read();
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "input", "stream", new Struct(this.inputStreamName), new Struct(iOException.getMessage()));
            }
        } while (n < 32 && n >= 0);
        if (n == -1) {
            return this.unify(term, new Int(-1));
        }
        return this.unify(term, new Struct(new Character((char)n).toString()));
    }

    public boolean tab_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!(term instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        int n = ((Int)term.getTerm()).intValue();
        if (this.outputStreamName.equals("stdout")) {
            for (int i = 0; i < n; ++i) {
                this.getEngine().stdOutput(" ");
            }
        } else {
            for (int i = 0; i < n; ++i) {
                try {
                    this.outputStream.write(32);
                    continue;
                }
                catch (IOException iOException) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
                }
            }
        }
        return true;
    }

    public boolean read_1(Term term) throws PrologError {
        term = term.getTerm();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        while (true) {
            try {
                n = this.inputStream.read();
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "input", "stream", new Struct(this.inputStreamName), new Struct(iOException.getMessage()));
            }
            if (n == -1) break;
            boolean bl3 = true;
            if (n == 39) {
                bl = !bl;
            } else if (n == 34) {
                bl2 = !bl2;
            } else if (n == 46 && !bl && !bl2) break;
            if (!bl3) continue;
            string = string + new Character((char)n).toString();
        }
        try {
            this.unify(term, this.getEngine().toTerm(string));
        }
        catch (InvalidTermException invalidTermException) {
            throw PrologError.syntax_error(this.engine.getEngineManager(), -1, invalidTermException.line, invalidTermException.pos, new Struct(string));
        }
        return true;
    }

    public boolean write_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput(term.toString());
        } else {
            try {
                this.outputStream.write(term.toString().getBytes());
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
            }
        }
        return true;
    }

    public boolean print_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput(Tools.removeApices(term.toString()));
        } else {
            try {
                this.outputStream.write(Tools.removeApices(term.toString()).getBytes());
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
            }
        }
        return true;
    }

    public boolean nl_0() throws PrologError {
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput("\n");
        } else {
            try {
                this.outputStream.write(10);
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
            }
        }
        return true;
    }

    public boolean text_from_file_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        Struct struct = (Struct)term.getTerm();
        Struct struct2 = null;
        String string = Tools.removeApices(struct.toString());
        if (!new File(string).isAbsolute()) {
            string = this.engine.getCurrentDirectory() + File.separator + string;
        }
        try {
            struct2 = new Struct(Tools.loadText(string));
        }
        catch (IOException iOException) {
            throw PrologError.existence_error(this.engine.getEngineManager(), 1, "stream", term, new Struct(iOException.getMessage()));
        }
        this.engine.resetDirectoryList(new File(string).getParent());
        return this.unify(term2, struct2);
    }

    public boolean set_seed_1(Term term) throws PrologError {
        if (!((term = term.getTerm()) instanceof Number)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "Integer Number", term);
        }
        Number number = (Number)term;
        if (!number.isInteger()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "Integer Number", term);
        }
        this.gen.setSeed(number.longValue());
        return true;
    }

    public boolean rand_float_1(Term term) {
        return this.unify(term, new Double(this.gen.nextFloat()));
    }

    public boolean rand_int_2(Term term, Term term2) {
        Number number = (Number)term.getTerm();
        return this.unify(term2, new Int(this.gen.nextInt(number.intValue())));
    }

    @Override
    public String getTheory() {
        return "consult(File) :- text_from_file(File,Text), add_theory(Text).\nreconsult(File) :- text_from_file(File,Text), set_theory(Text).\nsolve_file(File,Goal) :- solve_file_goal_guard(File,Goal),text_from_file(File,Text),text_term(Text,Goal),call(Goal).\nagent_file(X)  :- text_from_file(X,Y),agent(Y).\n";
    }

    public boolean solve_file_goal_guard_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        if ((term2 = term2.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!term2.isAtom() && !term2.isCompound()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "callable", term2);
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InputStream inputStream = this.inputStream;
        OutputStream outputStream = this.outputStream;
        this.inputStream = null;
        this.outputStream = null;
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (IOException iOException) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
            throw new IOException();
        }
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.outputStreamName.equals("user")) {
            this.outputStream = System.out;
        }
        if (this.inputStreamName.equals("user")) {
            this.inputStream = System.in;
        }
    }

    public boolean write_base_1(Term term) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput(term.toString());
        } else {
            try {
                this.outputStream.write(term.toString().getBytes());
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
            }
        }
        return true;
    }
}

