/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Int;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.Library;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.Operator;
import alice.tuprolog.PrologError;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.tuprolog.lib.IOLibrary;
import alice.util.Tools;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ISOIOLibrary
extends Library {
    protected final int files = 1000;
    protected Hashtable<InputStream, Hashtable<String, Term>> inputStreams = new Hashtable(1000);
    protected Hashtable<OutputStream, Hashtable<String, Term>> outputStreams = new Hashtable(1000);
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected String inputStreamName = null;
    protected String outputStreamName = null;
    protected IOLibrary IOLib = null;
    private int flag = 0;
    private int write_flag = 1;

    public boolean open_4(Term term, Term term2, Term term3, Term term4) throws PrologError {
        this.initLibrary();
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        File file = new File(((Struct)term).getName());
        if (!file.exists()) {
            throw PrologError.existence_error(this.engine.getEngineManager(), 1, "source_sink", term, new Struct("File not found."));
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!term2.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term2);
        }
        if (!(term3 instanceof Var)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 3, "variable", term3);
        }
        Hashtable<String, Term> hashtable = new Hashtable<String, Term>(10);
        boolean bl = this.inizialize_properties(hashtable);
        BufferedOutputStream bufferedOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        if (bl) {
            Object object;
            Struct struct = (Struct)term4;
            Struct struct2 = (Struct)term;
            if (struct.isList()) {
                if (!struct.isEmptyList()) {
                    object = struct.listIterator();
                    while (object.hasNext()) {
                        Struct struct3 = null;
                        Object e = object.next();
                        if (e instanceof Var) {
                            throw PrologError.instantiation_error(this.engine.getEngineManager(), 4);
                        }
                        struct3 = (Struct)e;
                        if (!hashtable.containsKey(struct3.getName())) {
                            throw PrologError.domain_error(this.engine.getEngineManager(), 4, "stream_option", struct3);
                        }
                        if (struct3.getName().equals("alias")) {
                            int n;
                            int n2;
                            Term term5;
                            for (Map.Entry<InputStream, Hashtable<String, Term>> entry : this.inputStreams.entrySet()) {
                                for (Map.Entry<String, Term> entry2 : entry.getValue().entrySet()) {
                                    if (!entry2.getKey().equals("alias")) continue;
                                    term5 = entry2.getValue();
                                    for (n2 = 0; n2 < struct3.getArity(); ++n2) {
                                        if (((Struct)term5).getArity() > 1) {
                                            for (n = 0; n < ((Struct)term5).getArity(); ++n) {
                                                if (!((Struct)term5).getArg(n).equals(struct3.getArg(n2))) continue;
                                                throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term5, new Struct("Alias is already associated with an open stream."));
                                            }
                                            continue;
                                        }
                                        if (!term5.equals(struct3.getArg(n2))) continue;
                                        throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term5, new Struct("Alias is already associated with an open stream."));
                                    }
                                }
                            }
                            for (Map.Entry<Closeable, Hashtable<String, Term>> entry : this.outputStreams.entrySet()) {
                                for (Map.Entry<String, Term> entry2 : entry.getValue().entrySet()) {
                                    if (!entry2.getKey().equals("alias")) continue;
                                    term5 = entry2.getValue();
                                    for (n2 = 0; n2 < struct3.getArity(); ++n2) {
                                        if (((Struct)term5).getArity() > 1) {
                                            for (n = 0; n < ((Struct)term5).getArity(); ++n) {
                                                if (!((Struct)term5).getArg(n).equals(struct3.getArg(n2))) continue;
                                                throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term5, new Struct("Alias is already associated with an open stream."));
                                            }
                                            continue;
                                        }
                                        if (!term5.equals(struct3.getArg(n2))) continue;
                                        throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term5, new Struct("Alias is already associated with an open stream."));
                                    }
                                }
                            }
                            int n3 = struct3.getArity();
                            if (n3 > 1) {
                                Term[] termArray = new Term[n3];
                                for (int i = 0; i < n3; ++i) {
                                    termArray[i] = struct3.getArg(i);
                                }
                                hashtable.put(struct3.getName(), new Struct(".", termArray));
                                continue;
                            }
                            hashtable.put(struct3.getName(), struct3.getArg(0));
                            continue;
                        }
                        Struct struct4 = null;
                        struct4 = (Struct)struct3.getArg(0);
                        hashtable.put(struct3.getName(), struct4);
                    }
                    hashtable.put("mode", term2);
                    hashtable.put("file_name", term);
                }
            } else {
                throw PrologError.type_error(this.engine.getEngineManager(), 4, "list", struct);
            }
            object = (Struct)term2;
            if (((Struct)object).getName().equals("write")) {
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(struct2.getName()));
                }
                catch (Exception exception) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term, new Struct("The source_sink specified by Source_sink cannot be opened."));
                }
                hashtable.put("output", new Struct("true"));
                this.outputStreams.put(bufferedOutputStream, hashtable);
                return this.unify(term3, new Struct(bufferedOutputStream.toString()));
            }
            if (((Struct)object).getName().equals("read")) {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(struct2.getName()));
                }
                catch (Exception exception) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term, new Struct("The source_sink specified by Source_sink cannot be opened."));
                }
                hashtable.put("input", new Struct("true"));
                if (((Struct)hashtable.get("reposition")).getName().equals("true")) {
                    try {
                        bufferedInputStream.mark(bufferedInputStream.available() + 5);
                    }
                    catch (IOException iOException) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException2) {
                            throw PrologError.system_error(new Struct("An error has occurred in open when closing the input file."));
                        }
                        throw PrologError.system_error(new Struct("An error has occurred in open."));
                    }
                }
                this.inputStreams.put(bufferedInputStream, hashtable);
                return this.unify(term3, new Struct(bufferedInputStream.toString()));
            }
            if (((Struct)object).getName().equals("append")) {
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(struct2.getName(), true));
                }
                catch (Exception exception) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term, new Struct("The source_sink specified by Source_sink cannot be opened."));
                }
                hashtable.put("output", new Struct("true"));
                this.outputStreams.put(bufferedOutputStream, hashtable);
                return this.unify(term3, new Struct(bufferedOutputStream.toString()));
            }
            throw PrologError.domain_error(this.engine.getEngineManager(), 2, "io_mode", term2);
        }
        PrologError.system_error(new Struct("A problem has occurred with initialization of properties' hashmap."));
        return false;
    }

    public boolean open_3(Term term, Term term2, Term term3) throws PrologError {
        this.initLibrary();
        term = term.getTerm();
        File file = new File(((Struct)term).getName());
        if (!file.exists()) {
            throw PrologError.existence_error(this.engine.getEngineManager(), 1, "source_sink", term, new Struct("File not found"));
        }
        term2 = term2.getTerm();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!term2.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term2);
        }
        if (!(term3 instanceof Var)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 3, "variable", term3);
        }
        Hashtable<String, Term> hashtable = new Hashtable<String, Term>(10);
        boolean bl = this.inizialize_properties(hashtable);
        BufferedOutputStream bufferedOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Struct struct = (Struct)term2;
        if (bl) {
            Struct struct2 = (Struct)term;
            Struct struct3 = new Struct(struct2.getName());
            hashtable.put("file_name", struct3);
            hashtable.put("mode", term2);
            if (struct.getName().equals("write")) {
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(struct2.getName()));
                }
                catch (Exception exception) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term, new Struct("The source_sink specified by Source_sink cannot be opened."));
                }
                hashtable.put("output", new Struct("true"));
                this.outputStreams.put(bufferedOutputStream, hashtable);
                return this.unify(term3, new Struct(bufferedOutputStream.toString()));
            }
            if (struct.getName().equals("read")) {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(struct2.getName()));
                }
                catch (Exception exception) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term, new Struct("The source_sink specified by Source_sink cannot be opened."));
                }
                hashtable.put("input", new Struct("true"));
                if (((Struct)hashtable.get("reposition")).getName().equals("true")) {
                    try {
                        bufferedInputStream.mark(bufferedInputStream.available() + 5);
                    }
                    catch (IOException iOException) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException2) {
                            throw PrologError.system_error(new Struct("An error has occurred in open when closing the input file."));
                        }
                        throw PrologError.system_error(new Struct("An error has occurred in open."));
                    }
                }
                this.inputStreams.put(bufferedInputStream, hashtable);
                return this.unify(term3, new Struct(bufferedInputStream.toString()));
            }
            if (struct.getName().equals("append")) {
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(struct2.getName(), true));
                }
                catch (Exception exception) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "open", "source_sink", term, new Struct("The source_sink specified by Source_sink cannot be opened."));
                }
                hashtable.put("output", new Struct("true"));
                this.outputStreams.put(bufferedOutputStream, hashtable);
                return this.unify(term3, new Struct(bufferedOutputStream.toString()));
            }
            throw PrologError.domain_error(this.engine.getEngineManager(), 1, "stream", struct2);
        }
        PrologError.system_error(new Struct("A problem has occurred with the initialization of the hashmap properties."));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean close_2(Term term, Term term2) throws PrologError {
        InputStream inputStream;
        block12: {
            Object object;
            this.initLibrary();
            OutputStream outputStream = null;
            inputStream = null;
            boolean bl = false;
            Struct struct = (Struct)term2;
            if (!term2.isList()) throw PrologError.type_error(this.engine.getEngineManager(), 4, "list", term2);
            if (!term2.isEmptyList()) {
                object = struct.listIterator();
                while (object.hasNext()) {
                    Struct struct2 = null;
                    Term term3 = object.next();
                    if (term3 instanceof Var) {
                        throw PrologError.instantiation_error(this.engine.getEngineManager(), 4);
                    }
                    struct2 = (Struct)term3;
                    if (!struct2.getName().equals("force")) throw PrologError.domain_error(this.engine.getEngineManager(), 2, "close_option", struct2);
                    Struct struct3 = (Struct)struct2.getArg(0);
                    bl = struct3.getName().equals("true");
                }
            }
            try {
                inputStream = this.find_input_stream(term);
            }
            catch (PrologError prologError) {
                outputStream = this.find_output_stream(term);
            }
            if (outputStream != null) {
                object = this.get_output_name(outputStream);
                if (((String)object).equals("stdout")) {
                    return true;
                }
                try {
                    this.flush_output_1(term);
                    outputStream.close();
                    return true;
                }
                catch (IOException iOException) {
                    if (!bl) throw PrologError.system_error(new Struct("An error has occurred on stream closure."));
                    this.outputStreams.remove(inputStream);
                    outputStream = null;
                    if (!((String)object).equals(this.outputStreamName)) return true;
                    this.outputStreamName = "stdout";
                    this.outputStream = System.out;
                    return true;
                }
            }
            if (inputStream == null) return true;
            object = this.get_input_name(inputStream);
            if (((String)object).equals("stdin")) {
                return true;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                if (!bl) throw PrologError.system_error(new Struct("An error has occurred on stream closure."));
                this.inputStreams.remove(inputStream);
                inputStream = null;
                if (!((String)object).equals(this.inputStreamName)) break block12;
                this.inputStreamName = "stdin";
                this.inputStream = System.in;
            }
        }
        this.inputStreams.remove(inputStream);
        return true;
    }

    public boolean close_1(Term term) throws PrologError {
        this.initLibrary();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            inputStream = this.find_input_stream(term);
        }
        catch (PrologError prologError) {
            outputStream = this.find_output_stream(term);
        }
        if (outputStream != null) {
            String string = this.get_output_name(outputStream);
            if (string.equals("stdout")) {
                return true;
            }
            this.flush_output_1(term);
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw PrologError.system_error(new Struct("An error has occurred on stream closure."));
            }
            if (string.equals(this.outputStreamName)) {
                this.outputStreamName = "stdout";
                this.outputStream = System.out;
            }
            this.outputStreams.remove(outputStream);
        } else if (inputStream != null) {
            String string = this.get_input_name(inputStream);
            if (string.equals("stdin")) {
                return true;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw PrologError.system_error(new Struct("An error has occurred on stream closure."));
            }
            if (string.equals(this.inputStreamName)) {
                this.inputStreamName = "stdin";
                this.inputStream = System.in;
            }
            this.inputStreams.remove(inputStream);
        }
        return true;
    }

    public boolean set_input_1(Term term) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        Struct struct = (Struct)hashtable.get("file_name");
        this.inputStream = inputStream;
        this.inputStreamName = struct.getName();
        return true;
    }

    public boolean set_output_1(Term term) throws PrologError {
        this.initLibrary();
        OutputStream outputStream = this.find_output_stream(term);
        Hashtable<String, Term> hashtable = this.outputStreams.get(outputStream);
        Struct struct = (Struct)hashtable.get("file_name");
        this.outputStream = outputStream;
        this.outputStreamName = struct.getName();
        return true;
    }

    public boolean find_property_2(Term term, Term term2) throws PrologError {
        int n;
        int n2;
        this.initLibrary();
        if (this.outputStreams.isEmpty() && this.inputStreams.isEmpty()) {
            return false;
        }
        if (!(term instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        term2 = term2.getTerm();
        Struct struct = (Struct)term2;
        String string = struct.getName();
        Struct struct2 = null;
        if (!string.equals("input") && !string.equals("output")) {
            struct2 = (Struct)struct.getArg(0);
        }
        ArrayList<Struct> arrayList = new ArrayList<Struct>();
        if (string.equals("input")) {
            for (Map.Entry<InputStream, Hashtable<String, Term>> entry : this.inputStreams.entrySet()) {
                arrayList.add(new Struct(entry.getKey().toString()));
            }
            Struct struct3 = new Struct(arrayList.toArray(new Struct[1]));
            return this.unify(term, struct3);
        }
        if (string.equals("output")) {
            for (Map.Entry<OutputStream, Hashtable<String, Term>> entry : this.outputStreams.entrySet()) {
                arrayList.add(new Struct(entry.getKey().toString()));
            }
            Struct struct4 = new Struct(arrayList.toArray(new Struct[1]));
            return this.unify(term, struct4);
        }
        block2: for (Map.Entry<InputStream, Hashtable<String, Term>> entry : this.inputStreams.entrySet()) {
            block3: for (Map.Entry<String, Term> entry2 : entry.getValue().entrySet()) {
                if (!entry2.getKey().equals(string)) continue;
                if (string.equals("alias")) {
                    n2 = ((Struct)entry2.getValue()).getArity();
                    if (n2 == 0 && struct2.equals((Struct)entry2.getValue())) {
                        arrayList.add(new Struct(entry.getKey().toString()));
                        continue block2;
                    }
                    for (n = 0; n < n2; ++n) {
                        if (!struct2.equals(((Struct)entry2.getValue()).getArg(n))) continue;
                        arrayList.add(new Struct(entry.getKey().toString()));
                        continue block3;
                    }
                    continue;
                }
                if (!entry2.getValue().equals(struct2)) continue;
                arrayList.add(new Struct(entry.getKey().toString()));
            }
        }
        block5: for (Map.Entry<Closeable, Hashtable<String, Term>> entry : this.outputStreams.entrySet()) {
            block6: for (Map.Entry<String, Term> entry2 : entry.getValue().entrySet()) {
                if (!entry2.getKey().equals(string)) continue;
                if (string.equals("alias")) {
                    n2 = ((Struct)entry2.getValue()).getArity();
                    if (n2 == 0 && struct2.equals((Struct)entry2.getValue())) {
                        arrayList.add(new Struct(((OutputStream)entry.getKey()).toString()));
                        continue block5;
                    }
                    for (n = 0; n < n2; ++n) {
                        if (!struct2.equals(((Struct)entry2.getValue()).getArg(n))) continue;
                        arrayList.add(new Struct(((OutputStream)entry.getKey()).toString()));
                        continue block6;
                    }
                    continue;
                }
                if (!entry2.getValue().equals(struct2)) continue;
                arrayList.add(new Struct(((OutputStream)entry.getKey()).toString()));
            }
        }
        Struct struct5 = new Struct(arrayList.toArray(new Struct[1]));
        return this.unify(term, struct5);
    }

    @Override
    public String getTheory() {
        return "stream_property(S,P) :- find_property(L,P),member(S,L).\n";
    }

    public boolean at_end_of_stream_0() throws PrologError {
        this.initLibrary();
        Hashtable<String, Term> hashtable = this.inputStreams.get(this.inputStream);
        Term term = hashtable.get("end_of_stream");
        Struct struct = (Struct)term;
        return !struct.getName().equals("not");
    }

    public boolean at_end_of_stream_1(Term term) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        Term term2 = hashtable.get("end_of_stream");
        Struct struct = (Struct)term2;
        return !struct.getName().equals("not");
    }

    public boolean set_stream_position_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Term term3 = null;
        BufferedInputStream bufferedInputStream = null;
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!(term2 instanceof Number)) {
            throw PrologError.domain_error(this.engine.getEngineManager(), 2, "stream_position", term2);
        }
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        term3 = hashtable.get("reposition");
        Struct struct = (Struct)term3;
        if (struct.getName().equals("false")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "reposition", "stream", term, new Struct("Stream has property reposition(false)"));
        }
        if (inputStream instanceof BufferedInputStream) {
            bufferedInputStream = (BufferedInputStream)inputStream;
        }
        if (bufferedInputStream.markSupported()) {
            try {
                bufferedInputStream.reset();
                Number number = (Number)term2;
                long l = number.longValue();
                if (l < 0L) {
                    throw PrologError.domain_error(this.engine.getEngineManager(), 2, "+long", term2);
                }
                int n = inputStream.available();
                if (l > (long)n) {
                    throw PrologError.system_error(new Struct("Invalid operation. Input position is greater than file size."));
                }
                if (l == (long)n) {
                    hashtable.put("end_of_file", new Struct("at"));
                }
                bufferedInputStream.skip(l);
                int n2 = new Long(l).intValue();
                hashtable.put("position", new Int(n2));
                this.inputStreams.put(bufferedInputStream, hashtable);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw PrologError.system_error(new Struct("An error has occurred in method 'set_stream_position'."));
            }
        }
        return true;
    }

    public boolean flush_output_0() throws PrologError {
        this.initLibrary();
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            throw PrologError.system_error(new Struct("An error has occurred in method 'flush_output_0'."));
        }
        return true;
    }

    public boolean flush_output_1(Term term) throws PrologError {
        this.initLibrary();
        OutputStream outputStream = this.find_output_stream(term);
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw PrologError.system_error(new Struct("An error has occurred in method 'flush_output_1'."));
        }
        return true;
    }

    public boolean get_char_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Character c = null;
        int n = 0;
        if (!(term2 instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        Struct struct = (Struct)hashtable.get("file_name");
        String string = struct.toString();
        Struct struct2 = (Struct)hashtable.get("type");
        if (struct2.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "binary_stream", term, new Struct("The target stream is associated with a binary stream."));
        }
        if (string.equals("stdin")) {
            this.IOLib.get0_1(term2);
            return true;
        }
        try {
            Term term3;
            Number number = (Number)hashtable.get("position");
            Struct struct3 = (Struct)hashtable.get("end_of_stream");
            if (struct3.getName().equals("past")) {
                term3 = hashtable.get("eof_action");
                String string2 = ((Struct)term3).getName();
                if (string2.equals("error")) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "input", "past_end_of_stream", new Struct("reader"), new Struct("End of file is reached."));
                }
                if (string2.equals("eof_code")) {
                    return this.unify(term2, new Struct("-1"));
                }
                if (string2.equals("reset")) {
                    hashtable.put("end_of_stream", new Struct("not"));
                    hashtable.put("position", new Int(0));
                    inputStream.reset();
                }
            }
            if (!Character.isDefined(n = inputStream.read())) {
                if (n == -1) {
                    hashtable.put("end_of_stream", new Struct("past"));
                } else {
                    throw PrologError.representation_error(this.engine.getEngineManager(), 2, "character");
                }
            }
            term3 = (Int)number;
            int n2 = ((Int)term3).intValue();
            hashtable.put("position", new Int(++n2));
            if (n != -1) {
                Var var = new Var();
                this.peek_code_2(term, var);
                Term term4 = var.getTerm();
                Number number2 = (Number)term4;
                if (number2.intValue() == -1) {
                    hashtable.put("end_of_stream", new Struct("at"));
                }
            }
            this.inputStreams.put(inputStream, hashtable);
            if (n == -1) {
                return this.unify(term2, Term.createTerm(n + ""));
            }
            c = new Character((char)n);
            return this.unify(term2, new Struct(c.toString()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw PrologError.system_error(new Struct("An I/O error has occurred"));
        }
    }

    public boolean get_code_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.inputStream.toString());
        return this.get_code_2(struct, term);
    }

    public boolean get_code_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        int n = 0;
        if (!(term2 instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "binary_stream", term, new Struct("The target stream is associated with a binary stream."));
        }
        Struct struct2 = (Struct)hashtable.get("file_name");
        String string = struct2.toString();
        if (string.equals("stdin")) {
            try {
                n = this.inputStream.read();
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "input", "stream", new Struct(this.inputStreamName), new Struct(iOException.getMessage()));
            }
            if (n == -1) {
                return this.unify(term2, new Int(-1));
            }
            return this.unify(term2, new Int(n));
        }
        try {
            Term term3;
            Number number = (Number)hashtable.get("position");
            Struct struct3 = (Struct)hashtable.get("end_of_stream");
            if (struct3.equals("past")) {
                term3 = hashtable.get("eof_action");
                String string2 = ((Struct)term3).getName();
                if (string2.equals("error")) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "input", "past_end_of_stream", new Struct("reader"), new Struct("End of file is reached."));
                }
                if (string2.equals("eof_code")) {
                    return this.unify(term2, new Struct("-1"));
                }
                if (string2.equals("reset")) {
                    hashtable.put("end_of_stream", new Struct("not"));
                    hashtable.put("position", new Int(0));
                    inputStream.reset();
                }
            }
            if (!Character.isDefined(n = inputStream.read())) {
                if (n == -1) {
                    hashtable.put("end_of_stream", new Struct("past"));
                } else {
                    throw PrologError.representation_error(this.engine.getEngineManager(), 2, "character");
                }
            }
            term3 = (Int)number;
            int n2 = ((Int)term3).intValue();
            hashtable.put("position", new Int(++n2));
            if (n != -1) {
                Var var = new Var();
                this.peek_code_2(term, var);
                Term term4 = var.getTerm();
                Number number2 = (Number)term4;
                if (number2.intValue() == -1) {
                    hashtable.put("end_of_stream", new Struct("at"));
                }
            }
            this.inputStreams.put(inputStream, hashtable);
            return this.unify(term2, new Int(n));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw PrologError.system_error(new Struct("An I/O error has occurred."));
        }
    }

    public boolean peek_char_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.inputStream.toString());
        if (this.inputStreamName.equals("stdin")) {
            this.inputStream.mark(5);
            boolean bl = this.get_char_2(struct, term);
            try {
                this.inputStream.reset();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                PrologError.system_error(new Struct("An error has occurred in peek_char_1."));
            }
            return bl;
        }
        return this.peek_char_2(struct, term);
    }

    public boolean peek_char_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        String string = ((Struct)hashtable.get("file_name")).getName();
        if (string.equals("stdin")) {
            return this.get_char_2(term, term2);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            PrologError.system_error(new Struct("File not found."));
        }
        Character c = null;
        int n = 0;
        if (!(term2 instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "binary_stream", term, new Struct("Target stream is associated with a binary stream."));
        }
        try {
            Number number = (Number)hashtable.get("position");
            Struct struct2 = (Struct)hashtable.get("end_of_stream");
            if (struct2.equals("past")) {
                Term term3 = hashtable.get("eof_action");
                String string2 = ((Struct)term3).getName();
                if (string2.equals("error")) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "input", "past_end_of_stream", new Struct("reader"), new Struct("End of file has been reached."));
                }
                if (string2.equals("eof_code")) {
                    return this.unify(term2, new Struct("-1"));
                }
                if (string2.equals("reset")) {
                    hashtable.put("end_of_stream", new Struct("not"));
                    hashtable.put("position", new Int(0));
                    inputStream.reset();
                }
            } else {
                Int intVal = (Int)number;
                long l = intVal.longValue();
                fileInputStream.skip(l);
                n = fileInputStream.read();
                fileInputStream.close();
            }
            if (!Character.isDefined(n) && n != -1) {
                throw PrologError.representation_error(this.engine.getEngineManager(), 2, "character");
            }
            this.inputStreams.put(inputStream, hashtable);
            if (n == -1) {
                return this.unify(term2, Term.createTerm(n + ""));
            }
            c = new Character((char)n);
            return this.unify(term2, Term.createTerm(c.toString()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw PrologError.system_error(new Struct("An I/O error has occurred."));
        }
    }

    public boolean peek_code_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.inputStream.toString());
        if (this.inputStreamName.equals("stdin")) {
            this.inputStream.mark(5);
            boolean bl = this.get_code_2(struct, term);
            try {
                this.inputStream.reset();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                PrologError.system_error(new Struct("An error has occurred in peek_code_1."));
            }
            return bl;
        }
        return this.peek_char_2(struct, term);
    }

    public boolean peek_code_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        String string = ((Struct)hashtable.get("file_name")).getName();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            PrologError.system_error(new Struct("File not found."));
        }
        int n = 0;
        if (!(term2 instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "binary_stream", term, new Struct("Target stream is associated with a binary stream."));
        }
        try {
            Number number = (Number)hashtable.get("position");
            Struct struct2 = (Struct)hashtable.get("end_of_stream");
            if (struct2.equals("past")) {
                Term term3 = hashtable.get("eof_action");
                String string2 = ((Struct)term3).getName();
                if (string2.equals("error")) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "input", "past_end_of_stream", new Struct("reader"), new Struct("End of file is reached."));
                }
                if (string2.equals("eof_code")) {
                    return this.unify(term2, new Struct("-1"));
                }
                if (string2.equals("reset")) {
                    hashtable.put("end_of_stream", new Struct("not"));
                    hashtable.put("position", new Int(0));
                    inputStream.reset();
                }
            } else {
                Int intVal = (Int)number;
                long l = intVal.longValue();
                fileInputStream.skip(l);
                n = fileInputStream.read();
                fileInputStream.close();
            }
            if (!Character.isDefined(n) && n != -1) {
                throw PrologError.representation_error(this.engine.getEngineManager(), 2, "character");
            }
            this.inputStreams.put(inputStream, hashtable);
            return this.unify(term2, new Int(n));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw PrologError.system_error(new Struct("An I/O error has occurred."));
        }
    }

    public boolean put_char_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        OutputStream outputStream = this.find_output_stream(term);
        String string = this.get_output_name(outputStream);
        Hashtable<String, Term> hashtable = this.outputStreams.get(outputStream);
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "binary_stream", term, new Struct("Target stream is associated with a binary stream."));
        }
        Struct struct2 = (Struct)term2.getTerm();
        if (struct2.isVar()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!struct2.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "character", struct2);
        }
        String string2 = struct2.getName();
        if (!Character.isDefined(string2.charAt(0))) {
            throw PrologError.representation_error(this.engine.getEngineManager(), 2, "character");
        }
        if (string2.length() > 1) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "character", new Struct(string2));
        }
        if (string.equals("stdout")) {
            this.getEngine().stdOutput(string2);
        } else {
            try {
                outputStream.write((byte)string2.charAt(0));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw PrologError.system_error(new Struct("An I/O error has occurred."));
            }
        }
        return true;
    }

    public boolean put_code_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.outputStream.toString());
        return this.put_code_2(struct, term);
    }

    public boolean put_code_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        OutputStream outputStream = this.find_output_stream(term);
        String string = this.get_output_name(outputStream);
        Hashtable<String, Term> hashtable = this.outputStreams.get(outputStream);
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "binary_stream", term, new Struct("Target stream is associated with a binary stream."));
        }
        Number number = (Number)term2.getTerm();
        if (number.isVar()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!number.isNumber()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 2, "character", number);
        }
        if (Character.isDefined(number.intValue())) {
            throw PrologError.representation_error(this.engine.getEngineManager(), 2, "character_code");
        }
        if (string.equals("stdout")) {
            this.getEngine().stdOutput("" + number.intValue());
        } else {
            try {
                outputStream.write(number.intValue());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw PrologError.system_error(new Struct("An I/O error has occurred."));
            }
        }
        return true;
    }

    public boolean nl_1(Term term) throws PrologError {
        this.initLibrary();
        OutputStream outputStream = this.find_output_stream(term);
        String string = this.get_output_name(outputStream);
        if (string.equals("stdout")) {
            this.getEngine().stdOutput("\n");
        } else {
            try {
                outputStream.write(10);
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
            }
        }
        return true;
    }

    public boolean get_byte_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.inputStream.toString());
        return this.get_byte_2(struct, term);
    }

    public boolean get_byte_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Byte by = null;
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("text")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "text_stream", term, new Struct("Target stream is associated with a text stream."));
        }
        if (!(term2 instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        try {
            Object object;
            Term term3;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Number number = (Number)hashtable.get("position");
            Int intVal = (Int)number;
            int n = intVal.intValue();
            dataInputStream.skipBytes(n - 1);
            Struct struct2 = (Struct)hashtable.get("end_of_stream");
            if (struct2.equals("past")) {
                term3 = hashtable.get("eof_action");
                object = ((Struct)term3).getName();
                if (((String)object).equals("error")) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "input", "past_end_of_stream", new Struct("reader"), new Struct("End of file is reached."));
                }
                if (((String)object).equals("eof_code")) {
                    return this.unify(term2, new Struct("-1"));
                }
                if (((String)object).equals("reset")) {
                    hashtable.put("end_of_stream", new Struct("not"));
                    hashtable.put("position", new Int(0));
                    dataInputStream.reset();
                }
            }
            by = dataInputStream.readByte();
            hashtable.put("position", new Int(++n));
            term3 = new Var();
            this.peek_byte_2(term, term3);
            object = ((Var)term3).getTerm();
            Number number2 = (Number)object;
            if (number2.intValue() == -1) {
                hashtable.put("end_of_stream", new Struct("at"));
            }
            this.inputStreams.put(inputStream, hashtable);
            return this.unify(term2, Term.createTerm(by.toString()));
        }
        catch (IOException iOException) {
            hashtable.put("end_of_stream", new Struct("past"));
            return this.unify(term2, Term.createTerm("-1"));
        }
    }

    public boolean peek_byte_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.inputStream.toString());
        return this.peek_char_2(struct, term);
    }

    public boolean peek_byte_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        Byte by = null;
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("text")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "text_stream", term, new Struct("Target stream is associated with a text stream."));
        }
        if (!(term2 instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Number number = (Number)hashtable.get("position");
            Int intVal = (Int)number;
            int n = intVal.intValue();
            dataInputStream.skipBytes(n - 2);
            Struct struct2 = (Struct)hashtable.get("end_of_stream");
            if (struct2.equals("past")) {
                Term term3 = hashtable.get("eof_action");
                String string = ((Struct)term3).getName();
                if (string.equals("error")) {
                    throw PrologError.permission_error(this.engine.getEngineManager(), "input", "past_end_of_stream", new Struct("reader"), new Struct("End of file is reached."));
                }
                if (string.equals("eof_code")) {
                    return this.unify(term2, new Struct("-1"));
                }
                if (string.equals("reset")) {
                    hashtable.put("end_of_stream", new Struct("not"));
                    hashtable.put("position", new Int(0));
                    dataInputStream.reset();
                }
            } else {
                by = dataInputStream.readByte();
            }
            this.inputStreams.put(inputStream, hashtable);
            return this.unify(term2, Term.createTerm(by.toString()));
        }
        catch (IOException iOException) {
            hashtable.put("end_of_stream", new Struct("past"));
            return this.unify(term2, Term.createTerm("-1"));
        }
    }

    public boolean put_byte_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.outputStream.toString());
        return this.put_byte_2(struct, term);
    }

    public boolean put_byte_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        OutputStream outputStream = this.find_output_stream(term);
        term2 = term2.getTerm();
        Number number = (Number)term2.getTerm();
        Hashtable<String, Term> hashtable = this.outputStreams.get(outputStream);
        Struct struct = (Struct)hashtable.get("type");
        if (struct.getName().equals("text")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "output", "text_stream", term, new Struct("Target stream is associated with a text stream."));
        }
        if (term2 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (outputStream.equals("stdout")) {
            this.getEngine().stdOutput(term2.toString());
        } else {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                Number number2 = (Number)hashtable.get("position");
                Int intVal = (Int)number2;
                int n = intVal.intValue();
                dataOutputStream.writeByte(number.intValue());
                hashtable.put("position", new Int(++n));
                this.outputStreams.put(outputStream, hashtable);
            }
            catch (IOException iOException) {
                throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", new Struct(this.outputStreamName), new Struct(iOException.getMessage()));
            }
        }
        return true;
    }

    public boolean read_term_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.inputStream.toString());
        return this.read_term_3(struct, term, term2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean read_term_3(Term term, Term term2, Term term3) throws PrologError {
        this.initLibrary();
        InputStream inputStream = this.find_input_stream(term);
        if (term3 instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 3);
        }
        Hashtable<String, Term> hashtable = this.inputStreams.get(inputStream);
        Struct struct = (Struct)hashtable.get("type");
        Struct struct2 = (Struct)hashtable.get("end_of_stream");
        Struct struct3 = (Struct)hashtable.get("eof_action");
        Number number = (Number)hashtable.get("position");
        if (struct.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "binary_stream", term, new Struct("Target stream is associated with a binary stream."));
        }
        if (struct2.getName().equals("past") && struct3.getName().equals("error")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "past_end_of_stream", "stream", term, new Struct("Target stream has position at past_end_of_stream"));
        }
        Struct struct4 = null;
        Struct struct5 = null;
        Struct struct6 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Struct struct7 = (Struct)term3;
        if (struct7.isList()) {
            if (!struct7.isEmptyList()) {
                Iterator<? extends Term> iterator = struct7.listIterator();
                while (iterator.hasNext()) {
                    Struct struct8 = null;
                    Term term4 = iterator.next();
                    if (term4 instanceof Var) {
                        throw PrologError.instantiation_error(this.engine.getEngineManager(), 3);
                    }
                    struct8 = (Struct)term4;
                    if (struct8.getName().equals("variables")) {
                        bl = true;
                        continue;
                    }
                    if (struct8.getName().equals("variable_name")) {
                        bl2 = true;
                        continue;
                    }
                    if (struct8.getName().equals("singletons")) {
                        bl3 = true;
                        continue;
                    }
                    PrologError.domain_error(this.engine.getEngineManager(), 3, "read_option", struct8);
                }
            }
        } else {
            throw PrologError.type_error(this.engine.getEngineManager(), 3, "list", term3);
        }
        try {
            void var33_47;
            int n = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            term2 = term2.getTerm();
            String string = "";
            while ((n = inputStream.read()) != -1) {
                boolean bl6 = true;
                if (n == 39) {
                    bl4 = !bl4;
                } else if (n == 34) {
                    bl5 = !bl5;
                } else if (n == 46 && !bl4 && !bl5) break;
                if (!bl6) continue;
                string = string + new Character((char)n).toString();
            }
            Int intVal = (Int)number;
            int n2 = intVal.intValue();
            n2 += string.getBytes().length;
            if (n == -1) {
                string = "-1";
                hashtable.put("end_of_stream", new Struct("past"));
                hashtable.put("position", new Int(n2));
                this.inputStreams.put(inputStream, hashtable);
                return this.unify(term2, Term.createTerm(string));
            }
            if (!(bl || bl2 || bl3)) {
                return this.unify(term2, this.getEngine().toTerm(string));
            }
            Var var = new Var();
            this.unify(var, Term.createTerm(string));
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            this.analize_term(arrayList2, var);
            Hashtable<Term, String> hashtable2 = new Hashtable<Term, String>(arrayList2.size());
            Hashtable<Term, String> hashtable3 = new Hashtable<Term, String>(arrayList2.size());
            LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>(arrayList2);
            ArrayList<Var> arrayList3 = new ArrayList<Var>();
            if (bl) {
                int n3 = 0;
                for (Term arrayList4 : linkedHashSet) {
                    ++n3;
                    if (bl2) {
                        hashtable3.put(arrayList4, "X" + n3);
                        if (!arrayList4.toString().startsWith("_")) {
                            hashtable2.put(arrayList4, "X" + n3);
                        }
                    }
                    arrayList3.add(new Var("X" + n3));
                }
            }
            ArrayList<Term> arrayList5 = new ArrayList<Term>();
            boolean bl7 = false;
            if (bl3) {
                ArrayList<Term> arrayList = new ArrayList<Term>(arrayList2);
                for (Term term4 : arrayList2) {
                    arrayList.remove(term4);
                    bl7 = false;
                    for (Term term5 : arrayList) {
                        if (!term5.equals(term4)) continue;
                        bl7 = true;
                    }
                    if (!bl7 && !term4.toString().startsWith("_")) {
                        arrayList5.add(term4);
                    }
                    arrayList.add(term4);
                }
            }
            Iterator<? extends Term> iterator = struct7.listIterator();
            Object object = null;
            while (iterator.hasNext()) {
                Term term6 = iterator.next();
                object = (Struct)term6;
                if (((Struct)object).getName().equals("variables")) {
                    struct4 = new Struct();
                    struct4 = (Struct)Term.createTerm(((Object)arrayList3).toString());
                    this.unify(((Struct)object).getArg(0), struct4);
                    continue;
                }
                if (((Struct)object).getName().equals("variable_name")) {
                    struct5 = new Struct();
                    struct5 = (Struct)Term.createTerm(hashtable2.toString());
                    this.unify(((Struct)object).getArg(0), struct5);
                    continue;
                }
                if (!((Struct)object).getName().equals("singletons")) continue;
                struct6 = new Struct();
                struct6 = (Struct)Term.createTerm(((Object)arrayList5).toString());
                this.unify(((Struct)object).getArg(0), struct6);
            }
            String string2 = var.toString();
            for (Map.Entry entry : hashtable3.entrySet()) {
                String string3 = ((Term)entry.getKey()).toString();
                String string4 = (String)entry.getValue();
                String string5 = var33_47.replaceAll(string3, string4);
            }
            hashtable.put("position", new Int(n2));
            this.inputStreams.put(inputStream, hashtable);
            return this.unify(term2, this.getEngine().toTerm((String)var33_47));
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void analize_term(List<Term> list, Term term) {
        if (!term.isCompound()) {
            list.add(term);
        } else {
            Struct struct = (Struct)term.getTerm();
            for (int i = 0; i < struct.getArity(); ++i) {
                this.analize_term(list, struct.getArg(i));
            }
        }
    }

    public boolean read_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(".", (Term)new Struct());
        return this.read_term_3(term, term2, struct);
    }

    public boolean write_term_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.outputStream.toString());
        return this.write_term_3(struct, term, term2);
    }

    public boolean write_term_3(Term term, Term term2, Term term3) throws PrologError {
        Object object;
        Object object2;
        this.initLibrary();
        term2 = term2.getTerm();
        OutputStream outputStream = this.find_output_stream(term);
        String string = this.get_output_name(outputStream);
        Struct struct = (Struct)term3.getTerm();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Struct struct2 = null;
        Hashtable<String, Term> hashtable = this.outputStreams.get(outputStream);
        Struct struct3 = (Struct)hashtable.get("type");
        if (struct3.getName().equals("binary")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "output", "binary_stream", term, new Struct("Target stream is associated with a binary stream."));
        }
        if (struct.isList()) {
            if (!struct.isEmptyList()) {
                object2 = struct.listIterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (object instanceof Var) {
                        throw PrologError.instantiation_error(this.engine.getEngineManager(), 3);
                    }
                    struct2 = (Struct)object;
                    if (struct2.getName().equals("quoted")) {
                        bl = ((Struct)struct2.getArg(0)).getName().equals("true");
                        continue;
                    }
                    if (struct2.getName().equals("ignore_ops")) {
                        bl2 = ((Struct)struct2.getArg(0)).getName().equals("true");
                        continue;
                    }
                    if (struct2.getName().equals("numbervars")) {
                        bl3 = ((Struct)struct2.getArg(0)).getName().equals("true");
                        continue;
                    }
                    throw PrologError.domain_error(this.engine.getEngineManager(), 3, "write_options", struct.getTerm());
                }
            }
        } else {
            PrologError.type_error(this.engine.getEngineManager(), 3, "list", struct);
        }
        try {
            if (!term2.isCompound() && !(term2 instanceof Var)) {
                if (string.equals("stdout")) {
                    if (bl) {
                        this.getEngine().stdOutput(Tools.removeApices(term2.toString()));
                    } else {
                        this.getEngine().stdOutput(term2.toString());
                    }
                } else if (bl) {
                    outputStream.write(Tools.removeApices(term2.toString()).getBytes());
                } else {
                    outputStream.write(term2.toString().getBytes());
                }
                return true;
            }
            if (term2 instanceof Var) {
                if (string.equals("stdout")) {
                    if (bl) {
                        this.getEngine().stdOutput(Tools.removeApices(term2.toString()) + " ");
                    } else {
                        this.getEngine().stdOutput(term2.toString() + " ");
                    }
                } else if (bl) {
                    outputStream.write((Tools.removeApices(term2.toString()) + " ").getBytes());
                } else {
                    outputStream.write((term2.toString() + " ").getBytes());
                }
                return true;
            }
            object2 = (Struct)term2;
            object = "";
            Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>(3);
            hashtable2.put("numbervars", bl3);
            hashtable2.put("ignore_ops", bl2);
            hashtable2.put("quoted", bl);
            object = this.create_string(hashtable2, (Struct)object2);
            if (string.equals("stdout")) {
                this.getEngine().stdOutput((String)object);
            } else {
                outputStream.write(((String)object + " ").getBytes());
            }
        }
        catch (IOException iOException) {
            PrologError.system_error(new Struct("Write error has occurred in write_term/3."));
        }
        return true;
    }

    private String create_string(Hashtable<String, Boolean> hashtable, Struct struct) {
        boolean bl = hashtable.get("numbervars");
        boolean bl2 = hashtable.get("quoted");
        boolean bl3 = hashtable.get("ignore_ops");
        String string = "";
        String string2 = "";
        if (struct.isList()) {
            string2 = this.print_list(struct, hashtable);
            if (!bl3) {
                return "[" + string2 + "]";
            }
            return string2;
        }
        List<Operator> list = this.engine.getCurrentOperatorList();
        String string3 = "";
        boolean bl4 = false;
        for (Operator operator : list) {
            if (!operator.name.equals(struct.getName())) continue;
            string3 = operator.name;
            bl4 = true;
            break;
        }
        if (!bl4) {
            string = string + struct.getName() + "(";
        }
        int n = struct.getArity();
        for (int i = 0; i < n; ++i) {
            Term term;
            if (i > 0 && !bl4) {
                string = string + ",";
            }
            if ((term = struct.getArg(i)) instanceof Number) {
                if (struct.getName().contains("$VAR")) {
                    if (bl) {
                        Int intVal = (Int)struct.getArg(i);
                        int n2 = intVal.intValue() % 26;
                        int n3 = intVal.intValue() / 26;
                        Character c = Character.valueOf('A');
                        int n4 = c.charValue() + n2;
                        string = new String(Character.toChars(n4));
                        if (n3 == 0) continue;
                        string = string + n3;
                        continue;
                    }
                    if (bl2) {
                        return struct.toString();
                    }
                    string = string + Tools.removeApices(term.toString());
                    continue;
                }
                if (!bl3) {
                    string = string + term.toString();
                    if (i % 2 != 0 || string3 == "") continue;
                    string = string + " " + string3 + " ";
                    continue;
                }
                string = struct.toString();
                return string;
            }
            if (term instanceof Var) {
                if (!bl3) {
                    string = string + term.toString();
                    if (i % 2 != 0 || string3 == "") continue;
                    string = string + " " + string3 + " ";
                    continue;
                }
                string = string + term.toString();
                continue;
            }
            if (term.isCompound()) {
                if (!bl3) {
                    string = string + this.create_string(hashtable, (Struct)term);
                    if (i % 2 != 0 || string3 == "") continue;
                    string = string + " " + string3 + " ";
                    continue;
                }
                string = string + this.create_string(hashtable, (Struct)term);
                continue;
            }
            if (bl2) {
                if (!bl3) {
                    string = string + term.toString();
                    if (i % 2 != 0 || string3 == "") continue;
                    string = string + " " + string3 + " ";
                    continue;
                }
                string = string + term.toString();
                continue;
            }
            if (!bl3) {
                string = string + Tools.removeApices(term.toString());
                if (i % 2 != 0 || string3 == "") continue;
                string = string + " " + string3 + " ";
                continue;
            }
            string = string + Tools.removeApices(term.toString());
        }
        if (!bl4 && string.contains("(")) {
            string = string + ")";
        }
        return string;
    }

    private String print_list(Struct struct, Hashtable<String, Boolean> hashtable) {
        boolean bl = hashtable.get("ignore_ops");
        String string = "";
        if (bl) {
            string = "'" + struct.getName() + "'" + " (";
            for (int i = 0; i < struct.getArity(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = struct.getArg(i).isList() && !struct.getArg(i).isEmptyList() ? string + this.print_list((Struct)struct.getArg(i), hashtable) : string + struct.getArg(i);
            }
            return string + ")";
        }
        for (int i = 0; i < struct.getArity(); ++i) {
            if (i > 0 && !struct.getArg(i).isEmptyList()) {
                string = string + ",";
            }
            if (struct.getArg(i).isCompound() && !struct.getArg(i).isList()) {
                string = string + this.create_string(hashtable, (Struct)struct.getArg(i));
                continue;
            }
            if (struct.getArg(i).isList() && !struct.getArg(i).isEmptyList()) {
                string = string + this.print_list((Struct)struct.getArg(i), hashtable);
                continue;
            }
            if (struct.getArg(i).isEmptyList()) continue;
            string = string + struct.getArg(i).toString();
        }
        return string;
    }

    public boolean write_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(".", new Struct("quoted", (Term)new Struct("false")), new Struct(".", new Struct("ignore_ops", (Term)new Struct("false")), new Struct(".", new Struct("numbervars", (Term)new Struct("true")), new Struct())));
        return this.write_term_3(term, term2, struct);
    }

    public boolean write_1(Term term) throws PrologError {
        if (this.write_flag == 0) {
            return this.write_iso_1(term);
        }
        return this.IOLib.write_base_1(term);
    }

    public boolean write_iso_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.outputStream.toString());
        Struct struct2 = new Struct(".", new Struct("quoted", (Term)new Struct("false")), new Struct(".", new Struct("ignore_ops", (Term)new Struct("false")), new Struct(".", new Struct("numbervars", (Term)new Struct("true")), new Struct())));
        return this.write_term_3(struct, term, struct2);
    }

    public boolean writeq_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.outputStream.toString());
        Struct struct2 = new Struct(".", new Struct("quoted", (Term)new Struct("true")), new Struct(".", new Struct("ignore_ops", (Term)new Struct("false")), new Struct(".", new Struct("numbervars", (Term)new Struct("true")), new Struct())));
        return this.write_term_3(struct, term, struct2);
    }

    public boolean writeq_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(".", new Struct("quoted", (Term)new Struct("true")), new Struct(".", new Struct("ignore_ops", (Term)new Struct("false")), new Struct(".", new Struct("numbervars", (Term)new Struct("true")), new Struct())));
        return this.write_term_3(term, term2, struct);
    }

    public boolean write_canonical_1(Term term) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(this.outputStream.toString());
        Struct struct2 = new Struct(".", new Struct("quoted", (Term)new Struct("true")), new Struct(".", new Struct("ignore_ops", (Term)new Struct("true")), new Struct(".", new Struct("numbervars", (Term)new Struct("false")), new Struct())));
        return this.write_term_3(struct, term, struct2);
    }

    public boolean write_canonical_2(Term term, Term term2) throws PrologError {
        this.initLibrary();
        Struct struct = new Struct(".", new Struct("quoted", (Term)new Struct("true")), new Struct(".", new Struct("ignore_ops", (Term)new Struct("true")), new Struct(".", new Struct("numbervars", (Term)new Struct("false")), new Struct())));
        return this.write_term_3(term, term2, struct);
    }

    private void initLibrary() {
        if (this.flag == 1) {
            return;
        }
        Library library = null;
        library = this.engine.getLibrary("alice.tuprolog.lib.IOLibrary");
        if (library == null) {
            try {
                library = this.engine.loadLibrary("alice.tuprolog.lib.IOLibrary");
            }
            catch (InvalidLibraryException invalidLibraryException) {
                invalidLibraryException.printStackTrace();
                PrologError.system_error(new Struct("IOLibrary does not exists."));
            }
        }
        this.IOLib = (IOLibrary)library;
        this.inputStream = this.IOLib.inputStream;
        this.outputStream = this.IOLib.outputStream;
        this.inputStreamName = this.IOLib.inputStreamName;
        this.outputStreamName = this.IOLib.outputStreamName;
        this.flag = 1;
        Hashtable<String, Term> hashtable = new Hashtable<String, Term>(10);
        this.inizialize_properties(hashtable);
        hashtable.put("input", new Struct("true"));
        hashtable.put("mode", new Struct("read"));
        hashtable.put("alias", new Struct("user_input"));
        hashtable.put("file_name", new Struct("stdin"));
        hashtable.put("eof_action", new Struct("reset"));
        hashtable.put("type", new Struct("text"));
        Hashtable<String, Term> hashtable2 = new Hashtable<String, Term>(10);
        this.inizialize_properties(hashtable2);
        hashtable2.put("output", new Struct("true"));
        hashtable2.put("mode", new Struct("append"));
        hashtable2.put("alias", new Struct("user_output"));
        hashtable2.put("eof_action", new Struct("reset"));
        hashtable2.put("file_name", new Struct("stdout"));
        hashtable2.put("type", new Struct("text"));
        this.inputStreams.put(this.inputStream, hashtable);
        this.outputStreams.put(this.outputStream, hashtable2);
    }

    private boolean inizialize_properties(Hashtable<String, Term> hashtable) {
        Struct struct = new Struct();
        hashtable.put("file_name", struct);
        hashtable.put("mode", struct);
        hashtable.put("input", new Struct("false"));
        hashtable.put("output", new Struct("false"));
        hashtable.put("alias", struct);
        hashtable.put("position", new Int(0));
        hashtable.put("end_of_stream", new Struct("not"));
        hashtable.put("eof_action", new Struct("error"));
        hashtable.put("reposition", new Struct("false"));
        hashtable.put("type", struct);
        return true;
    }

    private InputStream find_input_stream(Term term) throws PrologError {
        boolean bl = false;
        InputStream inputStream = null;
        term = term.getTerm();
        Struct struct = (Struct)term;
        String string = struct.getName();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        block0: for (Map.Entry<InputStream, Hashtable<String, Term>> entry : this.inputStreams.entrySet()) {
            block1: for (Map.Entry<String, Term> entry2 : entry.getValue().entrySet()) {
                if (entry.getKey().toString().equals(string)) {
                    inputStream = entry.getKey();
                    bl = true;
                    continue block0;
                }
                if (entry2.getKey().equals("file_name")) {
                    if (!term.equals(entry2.getValue())) continue;
                    inputStream = entry.getKey();
                    bl = true;
                    continue block0;
                }
                if (!entry2.getKey().equals("alias")) continue;
                Struct struct2 = (Struct)entry2.getValue();
                int n = struct2.getArity();
                if (n > 1) {
                    for (int i = 0; i < struct2.getArity(); ++i) {
                        if (!struct2.getArg(i).equals(term)) continue;
                        inputStream = entry.getKey();
                        bl = true;
                        continue block1;
                    }
                    continue;
                }
                if (!struct2.getName().equals(string)) continue;
                inputStream = entry.getKey();
                bl = true;
                continue block0;
            }
        }
        if (string.contains("Output") || string.equals("stdout")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "output", "stream", term, new Struct("S_or_a is an output stream"));
        }
        if (!bl) {
            throw PrologError.existence_error(this.engine.getEngineManager(), 1, "stream", term, new Struct("Input stream should be opened."));
        }
        return inputStream;
    }

    private OutputStream find_output_stream(Term term) throws PrologError {
        boolean bl = false;
        OutputStream outputStream = null;
        term = term.getTerm();
        Struct struct = (Struct)term;
        String string = struct.getName();
        if (term instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        block0: for (Map.Entry<OutputStream, Hashtable<String, Term>> entry : this.outputStreams.entrySet()) {
            block1: for (Map.Entry<String, Term> entry2 : entry.getValue().entrySet()) {
                if (entry.getKey().toString().equals(string)) {
                    outputStream = entry.getKey();
                    bl = true;
                    continue block0;
                }
                if (entry2.getKey().equals("file_name")) {
                    if (!term.equals(entry2.getValue())) continue;
                    outputStream = entry.getKey();
                    bl = true;
                    continue block0;
                }
                if (!entry2.getKey().equals("alias")) continue;
                Struct struct2 = (Struct)entry2.getValue();
                int n = struct2.getArity();
                if (n > 1) {
                    for (int i = 0; i < struct2.getArity(); ++i) {
                        if (!struct2.getArg(i).equals(term)) continue;
                        outputStream = entry.getKey();
                        bl = true;
                        continue block1;
                    }
                    continue;
                }
                if (!struct2.getName().equals(string)) continue;
                outputStream = entry.getKey();
                bl = true;
                continue block0;
            }
        }
        if (string.contains("Input") || string.equals("stdin")) {
            throw PrologError.permission_error(this.engine.getEngineManager(), "input", "stream", term, new Struct("S_or_a is an input stream."));
        }
        if (!bl) {
            throw PrologError.existence_error(this.engine.getEngineManager(), 1, "stream", term, new Struct("Output stream should be opened."));
        }
        return outputStream;
    }

    private String get_output_name(OutputStream outputStream) {
        Term term = null;
        for (Map.Entry<OutputStream, Hashtable<String, Term>> entry : this.outputStreams.entrySet()) {
            if (!entry.getKey().toString().equals(outputStream.toString())) continue;
            Hashtable<String, Term> hashtable = entry.getValue();
            term = hashtable.get("file_name");
            break;
        }
        Struct struct = (Struct)term;
        return struct.getName();
    }

    private String get_input_name(InputStream inputStream) {
        Term term = null;
        for (Map.Entry<InputStream, Hashtable<String, Term>> entry : this.inputStreams.entrySet()) {
            if (!entry.getKey().toString().equals(inputStream.toString())) continue;
            inputStream = entry.getKey();
            Hashtable<String, Term> hashtable = entry.getValue();
            term = hashtable.get("file_name");
            break;
        }
        Struct struct = (Struct)term;
        return struct.getName();
    }

    public boolean set_write_flag_1(Term term) throws PrologError {
        Number number = (Number)term;
        if (number.intValue() == 1) {
            this.write_flag = 1;
            return true;
        }
        if (number.intValue() == 0) {
            this.write_flag = 0;
            return true;
        }
        throw PrologError.domain_error(this.engine.getEngineManager(), 1, "0-1", term);
    }
}

