/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Double;
import alice.tuprolog.Float;
import alice.tuprolog.Int;
import alice.tuprolog.Library;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.PrologError;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;

public class ISOLibrary
extends Library {
    public boolean atom_length_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        Struct struct = (Struct)term;
        return this.unify(term2, new Int(struct.getName().length()));
    }

    public boolean atom_chars_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        term2 = term2.getTerm();
        if (term instanceof Var) {
            if (!term2.isList()) {
                throw PrologError.type_error(this.engine.getEngineManager(), 2, "list", term2);
            }
            Struct struct = (Struct)term2;
            if (struct.isEmptyList()) {
                return this.unify(term, new Struct(""));
            }
            String string = "";
            while (!struct.isEmptyList()) {
                String string2 = struct.getTerm(0).toString();
                try {
                    if (string2.startsWith("'") && string2.endsWith("'")) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = string.concat(string2);
                struct = (Struct)struct.getTerm(1);
            }
            return this.unify(term, new Struct(string));
        }
        if (!term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        String string = ((Struct)term).getName();
        Term[] termArray = new Term[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            termArray[i] = new Struct(new String(new char[]{string.charAt(i)}));
        }
        Struct struct = new Struct(termArray);
        return this.unify(term2, struct);
    }

    public boolean char_code_2(Term term, Term term2) throws PrologError {
        term = term.getTerm();
        if ((term2 = term2.getTerm()) instanceof Var) {
            if (term.isAtom()) {
                String string = ((Struct)term).getName();
                if (string.length() <= 1) {
                    return this.unify(term2, new Int(string.charAt(0)));
                }
                throw PrologError.type_error(this.engine.getEngineManager(), 1, "character", term);
            }
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "character", term);
        }
        if (term2 instanceof Int || term2 instanceof Long) {
            char c = (char)((Number)term2).intValue();
            return this.unify(term, new Struct("" + c));
        }
        throw PrologError.type_error(this.engine.getEngineManager(), 2, "integer", term2);
    }

    public Term sin_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double(Math.sin(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term cos_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double(Math.cos(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term exp_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double(Math.exp(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term atan_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double(Math.atan(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term log_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double(Math.log(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term sqrt_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double(Math.sqrt(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term abs_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Int || term2 instanceof Long) {
            return new Int(Math.abs(((Number)term2).intValue()));
        }
        if (term2 instanceof Double || term2 instanceof Float) {
            return new Double(Math.abs(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term sign_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Int || term2 instanceof Long) {
            return new Double(((Number)term2).intValue() > 0 ? 1.0 : -1.0);
        }
        if (term2 instanceof Double || term2 instanceof Float) {
            return new Double(((Number)term2).doubleValue() > 0.0 ? 1.0 : -1.0);
        }
        return null;
    }

    public Term float_integer_part_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double((long)Math.rint(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term float_fractional_part_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            double d = ((Number)term2).doubleValue();
            return new Double(Math.abs(d - Math.rint(d)));
        }
        return null;
    }

    public Term float_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Double(((Number)term2).doubleValue());
        }
        return null;
    }

    public Term floor_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Int((int)Math.floor(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term round_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Long(Math.round(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term truncate_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Int((int)Math.rint(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term ceiling_1(Term term) {
        Term term2 = null;
        try {
            term2 = this.evalExpression(term);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term2 instanceof Number) {
            return new Int((int)Math.ceil(((Number)term2).doubleValue()));
        }
        return null;
    }

    public Term div_2(Term term, Term term2) throws PrologError {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 instanceof Number && term4 instanceof Number) {
            return new Int(((Number)term3).intValue() / ((Number)term4).intValue());
        }
        return null;
    }

    public Term mod_2(Term term, Term term2) throws PrologError {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 instanceof Number && term4 instanceof Number) {
            int n = ((Number)term3).intValue();
            int n2 = ((Number)term4).intValue();
            int n3 = new java.lang.Double(Math.floor((double)n / (double)n2)).intValue();
            return new Int(n - n3 * n2);
        }
        return null;
    }

    public Term rem_2(Term term, Term term2) {
        Term term3 = null;
        Term term4 = null;
        try {
            term3 = this.evalExpression(term);
            term4 = this.evalExpression(term2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (term3 instanceof Number && term4 instanceof Number) {
            return new Double(Math.IEEEremainder(((Number)term3).doubleValue(), ((Number)term4).doubleValue()));
        }
        return null;
    }

    @Override
    public String getTheory() {
        return ":- op(  300, yfx,  'div'). \n:- op(  400, yfx,  'mod'). \n:- op(  400, yfx,  'rem'). \n:- op(  200, fx,   'sin'). \n:- op(  200, fx,   'cos'). \n:- op(  200, fx,   'sqrt'). \n:- op(  200, fx,   'atan'). \n:- op(  200, fx,   'exp'). \n:- op(  200, fx,   'log'). \n:- flag(bounded, [true,false], true, false).\n:- flag(max_integer, [" + new Integer(Integer.MAX_VALUE).toString() + "], " + new Integer(Integer.MAX_VALUE).toString() + ",false).\n" + ":- flag(min_integer, [" + new Integer(Integer.MIN_VALUE).toString() + "], " + new Integer(Integer.MIN_VALUE).toString() + ",false).\n" + ":- flag(integer_rounding_function, [up,down], down, false).\n" + ":- flag(char_conversion,[on,off],off,false).\n" + ":- flag(debug,[on,off],off,false).\n" + ":- flag(max_arity, [" + new Integer(Integer.MAX_VALUE).toString() + "], " + new Integer(Integer.MAX_VALUE).toString() + ",false).\n" + ":- flag(undefined_predicate, [error,fail,warning], fail, false).\n" + ":- flag(double_quotes, [atom,chars,codes], atom, false).\n" + "bound(X):-ground(X).\n                                                                                  " + "unbound(X):-not(ground(X)).\n                                                                          " + "atom_concat(F,S,R) :- catch(atom_concat0(F,S,R), Error, false).\n" + "atom_concat0(F,S,R) :- var(R), !,(atom_chars(S,SL),append(FL,SL,RS),atom_chars(F,FL),atom_chars(R,RS)).  \n" + "atom_concat0(F,S,R) :-(atom_chars(R,RS), append(FL,SL,RS),atom_chars(F,FL),atom_chars(S,SL)).\n" + "atom_codes(A,L):- catch(atom_codes0(A,L), Error, false).\n" + "atom_codes0(A,L):-nonvar(A),atom_chars(A,L1),!,chars_codes(L1,L).\n" + "atom_codes0(A,L):-nonvar(L), list(L), !,chars_codes(L1,L),atom_chars(A,L1).\n" + "chars_codes([],[]).\n" + "chars_codes([X|L1],[Y|L2]):-char_code(X,Y),chars_codes(L1,L2).\n" + "sub_atom(Atom,B,L,A,Sub):- sub_atom_guard(Atom,B,L,A,Sub), sub_atom0(Atom,B,L,A,Sub).\n" + "sub_atom0(Atom,B,L,A,Sub):-atom_chars(Atom,L1),sub_list(L2,L1,B),atom_chars(Sub,L2),length(L2,L), length(L1,Len), A is Len-(B+L).\n" + "sub_list([],_,0).\n" + "sub_list([X|L1],[X|L2],0):- sub_list_seq(L1,L2).\n" + "sub_list(L1,[_|L2],N):- sub_list(L1,L2,M), N is M + 1.\n" + "sub_list_seq([],L).\n" + "sub_list_seq([X|L1],[X|L2]):-sub_list_seq(L1,L2).\n" + "number_chars(Number,List):-catch(number_chars0(Number,List), Error, false).\n" + "number_chars0(Number,List):-nonvar(Number),!,num_atom(Number,Struct),atom_chars(Struct,List).\n" + "number_chars0(Number,List):-atom_chars(Struct,List),num_atom(Number,Struct).\n" + "number_codes(Number,List):-catch(number_codes0(Number,List), Error, false).\n" + "number_codes0(Number,List):-nonvar(Number),!,num_atom(Number,Struct),atom_codes(Struct,List).\n" + "number_codes0(Number,List):-atom_codes(Struct,List),num_atom(Number,Struct).\n";
    }

    public boolean sub_atom_guard_5(Term term, Term term2, Term term3, Term term4, Term term5) throws PrologError {
        if (!(term = term.getTerm()).isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom", term);
        }
        return true;
    }
}

