/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Double;
import alice.tuprolog.Float;
import alice.tuprolog.Int;
import alice.tuprolog.JavaException;
import alice.tuprolog.Library;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.tuprolog.lib.ClassLoader;
import alice.tuprolog.lib.InvalidObjectIdException;
import alice.tuprolog.lib.Signature;
import alice.util.DynamicURLClassLoader;
import alice.util.InspectionUtils;
import alice.util.Tools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class JavaLibrary
extends Library {
    private HashMap<String, Object> currentObjects = new HashMap();
    private IdentityHashMap<Object, Struct> currentObjects_inverse = new IdentityHashMap();
    private HashMap<String, Object> staticObjects = new HashMap();
    private IdentityHashMap<Object, Struct> staticObjects_inverse = new IdentityHashMap();
    private int id = 0;
    private DynamicURLClassLoader classLoader = new DynamicURLClassLoader(new URL[0], this.getClass().getClassLoader());

    @Override
    public String getTheory() {
        return ":- op(800,xfx,'<-').\n:- op(850,xfx,'returns').\n:- op(200,xfx,'as').\n:- op(600,xfx,'.'). \njava_object_bt(ClassName,Args,Id):- java_object(ClassName,Args,Id).\njava_object_bt(ClassName,Args,Id):- destroy_object(Id).\nObj <- What :- java_call(Obj,What,Res), Res \\== false.\nObj <- What returns Res :- java_call(Obj,What,Res).\njava_array_set(Array,Index,Object):- class('java.lang.reflect.Array') <- set(Array as 'java.lang.Object',Index,Object as 'java.lang.Object'), !.\njava_array_set(Array,Index,Object):- java_array_set_primitive(Array,Index,Object).\njava_array_get(Array,Index,Object):- class('java.lang.reflect.Array') <- get(Array as 'java.lang.Object',Index) returns Object,!.\njava_array_get(Array,Index,Object):- java_array_get_primitive(Array,Index,Object).\njava_array_length(Array,Length):- class('java.lang.reflect.Array') <- getLength(Array as 'java.lang.Object') returns Length.\njava_object_string(Object,String):- Object <- toString returns String.    \njava_catch(JavaGoal, List, Finally) :- call(JavaGoal), call(Finally).\n";
    }

    @Override
    public void dismiss() {
        this.currentObjects.clear();
        this.currentObjects_inverse.clear();
    }

    public void dismissAll() {
        this.currentObjects.clear();
        this.currentObjects_inverse.clear();
        this.staticObjects.clear();
        this.staticObjects_inverse.clear();
    }

    @Override
    public void onSolveBegin(Term term) {
        this.currentObjects.clear();
        this.currentObjects_inverse.clear();
        for (Map.Entry<Object, Struct> entry : this.staticObjects_inverse.entrySet()) {
            this.bindDynamicObject(entry.getValue(), entry.getKey());
        }
        this.preregisterObjects();
    }

    @Override
    public void onSolveEnd() {
    }

    protected void preregisterObjects() {
        try {
            this.bindDynamicObject(new Struct("stdout"), System.out);
            this.bindDynamicObject(new Struct("stderr"), System.err);
            this.bindDynamicObject(new Struct("runtime"), Runtime.getRuntime());
            this.bindDynamicObject(new Struct("current_thread"), Thread.currentThread());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean java_object_3(Term term, Term term2, Term term3) throws JavaException {
        term = term.getTerm();
        Struct struct = (Struct)term2.getTerm();
        term3 = term3.getTerm();
        try {
            if (!term.isAtom()) {
                throw new JavaException(new ClassNotFoundException("Java class not found: " + term));
            }
            String string = ((Struct)term).getName();
            if (string.endsWith("[]")) {
                Object[] objectArray = this.getArrayFromList(struct);
                int n = ((Number)objectArray[0]).intValue();
                if (this.java_array(string, n, term3)) {
                    return true;
                }
                throw new JavaException(new Exception());
            }
            Signature signature = this.parseArg(this.getArrayFromList(struct));
            if (signature == null) {
                throw new IllegalArgumentException("Illegal constructor arguments  " + struct);
            }
            try {
                Class<?> clazz = Class.forName(string, true, this.classLoader);
                Object[] objectArray = signature.getValues();
                Constructor<?> constructor = JavaLibrary.lookupConstructor(clazz, signature.getTypes(), objectArray);
                if (constructor == null) {
                    this.getEngine().warn("Constructor not found: class " + string);
                    throw new JavaException(new NoSuchMethodException("Constructor not found: class " + string));
                }
                Object obj = constructor.newInstance(objectArray);
                if (this.bindDynamicObject(term3, obj)) {
                    return true;
                }
                throw new JavaException(new Exception());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.getEngine().warn("Java class not found: " + string);
                throw new JavaException(classNotFoundException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.getEngine().warn("Invalid constructor arguments.");
                throw new JavaException(invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getEngine().warn("Constructor not found: " + signature.getTypes());
                throw new JavaException(noSuchMethodException);
            }
            catch (InstantiationException instantiationException) {
                this.getEngine().warn("Objects of class " + string + " cannot be instantiated");
                throw new JavaException(instantiationException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getEngine().warn("Illegal constructor arguments  " + signature);
                throw new JavaException(illegalArgumentException);
            }
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    public boolean java_object_4(Term term, Term term2, Term term3, Term term4) throws JavaException {
        term4 = term4.getTerm();
        try {
            if (!term4.isList()) {
                throw new IllegalArgumentException();
            }
            String[] stringArray = this.getStringArrayFromStruct((Struct)term4);
            URL[] uRLArray = this.getURLsFromStringArray(stringArray);
            this.classLoader.addURLs(uRLArray);
            boolean bl = this.java_object_3(term, term2, term3);
            this.classLoader.removeURLs(uRLArray);
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getEngine().warn("Illegal list of paths " + term4);
            throw new JavaException(illegalArgumentException);
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    public boolean destroy_object_1(Term term) throws JavaException {
        term = term.getTerm();
        try {
            if (term.isGround()) {
                this.unregisterDynamic((Struct)term);
            }
            return true;
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    public boolean java_class_4(Term term, Term term2, Term term3, Term term4) throws JavaException {
        Struct struct = (Struct)term.getTerm();
        Struct struct2 = (Struct)term2.getTerm();
        Struct struct3 = (Struct)term3.getTerm();
        term4 = term4.getTerm();
        try {
            Object object;
            Object object2;
            String string = Tools.removeApices(struct2.toString());
            String string2 = string.replace('.', '/');
            Iterator<? extends Term> iterator = struct3.listIterator();
            String string3 = "";
            while (iterator.hasNext()) {
                if (string3.length() > 0) {
                    string3 = string3 + ";";
                }
                string3 = string3 + Tools.removeApices(((Struct)iterator.next()).toString());
            }
            if (string3.length() > 0) {
                string3 = " -classpath " + string3;
            }
            String string4 = Tools.removeApices(struct.toString());
            try {
                object2 = new FileWriter(string2 + ".java");
                ((Writer)object2).write(string4);
                ((OutputStreamWriter)object2).close();
            }
            catch (IOException iOException) {
                this.getEngine().warn("Compilation of java sources failed");
                this.getEngine().warn("(creation of " + string2 + ".java fail failed)");
                throw new JavaException(iOException);
            }
            object2 = "javac " + string3 + " " + string2 + ".java";
            try {
                object = Runtime.getRuntime().exec((String)object2);
                int n = ((Process)object).waitFor();
                if (n != 0) {
                    this.getEngine().warn("Compilation of java sources failed");
                    this.getEngine().warn("(java compiler (javac) has stopped with errors)");
                    throw new IOException("Compilation of java sources failed");
                }
            }
            catch (IOException iOException) {
                this.getEngine().warn("Compilation of java sources failed");
                this.getEngine().warn("(java compiler (javac) invocation failed)");
                throw new JavaException(iOException);
            }
            try {
                object = Class.forName(string, true, new ClassLoader());
                if (this.bindDynamicObject(term4, object)) {
                    return true;
                }
                throw new JavaException(new Exception());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.getEngine().warn("Compilation of java sources failed");
                this.getEngine().warn("(Java Class compiled, but not created: " + string + " )");
                throw new JavaException(classNotFoundException);
            }
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean java_call_3(Term term, Term term2, Term term3) throws JavaException {
        term = term.getTerm();
        term3 = term3.getTerm();
        Struct struct = (Struct)term2.getTerm();
        Object object = null;
        Signature signature = null;
        String string = null;
        try {
            Object object2;
            string = struct.getName();
            if (!term.isAtom()) {
                if (term instanceof Var) {
                    throw new JavaException(new IllegalArgumentException(term.toString()));
                }
                object2 = (Struct)term;
                if (((Struct)object2).getName().equals(".") && ((Struct)object2).getArity() == 2 && struct.getArity() == 1) {
                    if (string.equals("set")) {
                        return this.java_set(((Struct)object2).getTerm(0), ((Struct)object2).getTerm(1), struct.getTerm(0));
                    }
                    if (string.equals("get")) {
                        return this.java_get(((Struct)object2).getTerm(0), ((Struct)object2).getTerm(1), struct.getTerm(0));
                    }
                }
            }
            signature = this.parseArg(struct);
            if (term instanceof Var) {
                throw new JavaException(new IllegalArgumentException(term.toString()));
            }
            if (signature == null) {
                throw new JavaException(new IllegalArgumentException());
            }
            object2 = Tools.removeApices(term.toString());
            object = this.staticObjects.containsKey(object2) ? this.staticObjects.get(object2) : this.currentObjects.get(object2);
            Object object3 = null;
            if (object != null) {
                Class<?> clazz = object.getClass();
                Object[] objectArray = signature.getValues();
                Method method = JavaLibrary.lookupMethod(clazz, string, signature.getTypes(), objectArray);
                if (method == null) {
                    this.getEngine().warn("Method not found: " + string + "( signature: " + signature + " )");
                    throw new JavaException(new NoSuchMethodException("Method not found: " + string + "( signature: " + signature + " )"));
                }
                try {
                    object3 = method.invoke(object, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.getEngine().warn("Method invocation failed: " + string + "( signature: " + signature + " )");
                    throw new JavaException(illegalAccessException);
                }
            }
            if (term.isCompound()) {
                Struct struct2 = (Struct)term;
                if (struct2.getArity() == 1 && struct2.getName().equals("class")) {
                    try {
                        String string2 = Tools.removeApices(struct2.getArg(0).toString());
                        Class<?> clazz = Class.forName(string2, true, this.classLoader);
                        Method method = InspectionUtils.searchForMethod(clazz, string, signature.getTypes());
                        method.setAccessible(true);
                        object3 = method.invoke(null, signature.getValues());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.getEngine().warn("Unknown class.");
                        throw new JavaException(classNotFoundException);
                    }
                }
                if (struct2.getArity() == 2 && struct2.getName().equals("class")) {
                    String string3 = Tools.removeApices(((Struct)term).getArg(1).toString());
                    Struct struct3 = (Struct)((Struct)term).getArg(0);
                    String[] stringArray = this.getStringArrayFromStruct(struct3);
                    this.classLoader.addURLs(this.getURLsFromStringArray(stringArray));
                    try {
                        Class<?> clazz = Class.forName(string3, true, this.classLoader);
                        Method method = InspectionUtils.searchForMethod(clazz, string, signature.getTypes());
                        method.setAccessible(true);
                        object3 = method.invoke(null, signature.getValues());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.getEngine().warn("Unknown class.");
                        throw new JavaException(classNotFoundException);
                    }
                    finally {
                        this.classLoader.removeURLs(this.getURLsFromStringArray(stringArray));
                    }
                } else {
                    Method method = String.class.getMethod(string, signature.getTypes());
                    method.setAccessible(true);
                    object3 = method.invoke(object2, signature.getValues());
                }
            } else {
                Method method = String.class.getMethod(string, signature.getTypes());
                method.setAccessible(true);
                object3 = method.invoke(object2, signature.getValues());
            }
            if (this.parseResult(term3, object3)) {
                return true;
            }
            throw new JavaException(new Exception());
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getEngine().warn("Method failed: " + string + " - ( signature: " + signature + " ) - Original Exception: " + invocationTargetException.getTargetException());
            throw new JavaException(new IllegalArgumentException());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.getEngine().warn("Method not found: " + string + " - ( signature: " + signature + " )");
            throw new JavaException(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getEngine().warn("Invalid arguments " + signature + " - ( method: " + string + " )");
            throw new JavaException(illegalArgumentException);
        }
        catch (Exception exception) {
            this.getEngine().warn("Generic error in method invocation " + string);
            throw new JavaException(exception);
        }
    }

    public boolean set_classpath_1(Term term) throws JavaException {
        try {
            term = term.getTerm();
            if (!term.isList()) {
                throw new IllegalArgumentException();
            }
            String[] stringArray = this.getStringArrayFromStruct((Struct)term);
            this.classLoader.removeAllURLs();
            this.classLoader.addURLs(this.getURLsFromStringArray(stringArray));
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getEngine().warn("Illegal list of paths " + term);
            throw new JavaException(illegalArgumentException);
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    public boolean get_classpath_1(Term term) throws JavaException {
        try {
            term = term.getTerm();
            if (!(term instanceof Var)) {
                throw new IllegalArgumentException();
            }
            URL[] uRLArray = this.classLoader.getURLs();
            String string = null;
            Term term2 = null;
            if (uRLArray.length > 0) {
                string = "[";
                for (URL uRL : uRLArray) {
                    File file = new File(URLDecoder.decode(uRL.getFile(), "UTF-8"));
                    string = string + "'" + file.getPath() + "',";
                }
                string = string.substring(0, string.length() - 1);
                string = string + "]";
            } else {
                string = "[]";
            }
            term2 = Term.createTerm(string);
            return this.unify(term, term2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.getEngine().warn("Illegal list of paths " + term);
            throw new JavaException(illegalArgumentException);
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean java_set(Term term, Term term2, Term term3) {
        term3 = term3.getTerm();
        if (!term2.isAtom()) return false;
        if (term3 instanceof Var) {
            return false;
        }
        String string = ((Struct)term2).getName();
        Object object = null;
        try {
            Object object2;
            Object object3;
            Object object4;
            Class<?> clazz = null;
            if (term.isCompound() && ((Struct)term).getName().equals("class")) {
                object4 = null;
                object3 = null;
                if (((Struct)term).getArity() == 1) {
                    object4 = Tools.removeApices(((Struct)term).getArg(0).toString());
                } else if (((Struct)term).getArity() == 2) {
                    object4 = Tools.removeApices(((Struct)term).getArg(1).toString());
                    object2 = (Struct)((Struct)term).getArg(0);
                    object3 = this.getStringArrayFromStruct((Struct)object2);
                    this.classLoader.addURLs(this.getURLsFromStringArray((String[])object3));
                }
                if (object4 != null) {
                    try {
                        clazz = Class.forName((String)object4, true, this.classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.getEngine().warn("Java class not found: " + (String)object4);
                        boolean bl = false;
                        return bl;
                    }
                    catch (Exception exception) {
                        this.getEngine().warn("Static field " + string + " not found in class " + Tools.removeApices(((Struct)term).getArg(0).toString()));
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (((Struct)term).getArity() == 2) {
                            this.classLoader.removeURLs(this.getURLsFromStringArray((String[])object3));
                        }
                    }
                }
            } else {
                object4 = Tools.removeApices(term.toString());
                object = this.currentObjects.get(object4);
                if (object == null) return false;
                clazz = object.getClass();
            }
            object4 = clazz.getField(string);
            if (term3 instanceof Number) {
                object3 = (Number)term3;
                if (object3 instanceof Int) {
                    ((Field)object4).setInt(object, object3.intValue());
                    return true;
                }
                if (object3 instanceof Double) {
                    ((Field)object4).setDouble(object, object3.doubleValue());
                    return true;
                }
                if (object3 instanceof Long) {
                    ((Field)object4).setLong(object, object3.longValue());
                    return true;
                }
                if (!(object3 instanceof Float)) return false;
                ((Field)object4).setFloat(object, object3.floatValue());
                return true;
            }
            object3 = Tools.removeApices(term3.toString());
            object2 = this.currentObjects.get(object3);
            if (object2 != null) {
                ((Field)object4).set(object, object2);
                return true;
            }
            ((Field)object4).set(object, object3);
            return true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.getEngine().warn("Field " + string + " not found in class " + term);
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean java_get(Term var1_1, Term var2_2, Term var3_3) {
        if (!var2_2.isAtom()) {
            return false;
        }
        var4_4 = ((Struct)var2_2).getName();
        var5_5 = null;
        try {
            var6_6 = null;
            if (var1_1.isCompound() && ((Struct)var1_1).getName().equals("class")) {
                var7_9 = null;
                var8_10 = null;
                if (((Struct)var1_1).getArity() == 1) {
                    var7_9 = Tools.removeApices(((Struct)var1_1).getArg(0).toString());
                } else if (((Struct)var1_1).getArity() == 2) {
                    var7_9 = Tools.removeApices(((Struct)var1_1).getArg(1).toString());
                    var9_11 = (Struct)((Struct)var1_1).getArg(0);
                    var8_10 = this.getStringArrayFromStruct((Struct)var9_11);
                    this.classLoader.addURLs(this.getURLsFromStringArray(var8_10));
                }
                if (var7_9 != null) {
                    try {
                        var6_6 = Class.forName((String)var7_9, true, this.classLoader);
                        ** if (((Struct)var1_1).getArity() != 2) goto lbl-1000
                    }
                    catch (ClassNotFoundException var9_12) {
                        block24: {
                            this.getEngine().warn("Java class not found: " + (String)var7_9);
                            var10_18 = false;
                            if (((Struct)var1_1).getArity() != 2) break block24;
                            {
                                catch (Throwable var11_20) {
                                    if (((Struct)var1_1).getArity() == 2) {
                                        this.classLoader.removeURLs(this.getURLsFromStringArray(var8_10));
                                    }
                                    throw var11_20;
                                }
                            }
                            this.classLoader.removeURLs(this.getURLsFromStringArray(var8_10));
                        }
                        return var10_18;
                        catch (Exception var9_13) {
                            block25: {
                                this.getEngine().warn("Static field " + var4_4 + " not found in class " + Tools.removeApices(((Struct)var1_1).getArg(0).toString()));
                                var10_19 = false;
                                if (((Struct)var1_1).getArity() != 2) break block25;
                                this.classLoader.removeURLs(this.getURLsFromStringArray(var8_10));
                            }
                            return var10_19;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.classLoader.removeURLs(this.getURLsFromStringArray(var8_10));
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            } else {
                var7_9 = Tools.removeApices(var1_1.toString());
                var5_5 = this.currentObjects.get(var7_9);
                if (var5_5 == null) {
                    return false;
                }
                var6_6 = var5_5.getClass();
            }
            var7_9 = var6_6.getField(var4_4);
            var8_10 = var7_9.getType();
            var7_9.setAccessible(true);
            if (var8_10.equals(Integer.TYPE) || var8_10.equals(Byte.TYPE)) {
                var9_14 = var7_9.getInt(var5_5);
                return this.unify(var3_3, new Int(var9_14));
            }
            if (var8_10.equals(java.lang.Long.TYPE)) {
                var9_15 = var7_9.getLong(var5_5);
                return this.unify(var3_3, new Long(var9_15));
            }
            if (var8_10.equals(java.lang.Float.TYPE)) {
                var9_16 = var7_9.getFloat(var5_5);
                return this.unify(var3_3, new Float(var9_16));
            }
            if (var8_10.equals(java.lang.Double.TYPE)) {
                var9_17 = var7_9.getDouble(var5_5);
                return this.unify(var3_3, new Double(var9_17));
            }
            var9_11 = var7_9.get(var5_5);
            return this.bindDynamicObject(var3_3, var9_11);
        }
        catch (NoSuchFieldException var6_7) {
            this.getEngine().warn("Field " + var4_4 + " not found in class " + var1_1);
            return false;
        }
        catch (Exception var6_8) {
            this.getEngine().warn("Generic error in accessing the field");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean java_array_set_primitive_3(Term term, Term term2, Term term3) throws JavaException {
        Struct struct = (Struct)term.getTerm();
        Number number = (Number)term2.getTerm();
        term3 = term3.getTerm();
        Object object = null;
        if (!number.isInteger()) {
            throw new JavaException(new IllegalArgumentException(number.toString()));
        }
        try {
            Class<?> clazz = null;
            String string = Tools.removeApices(struct.toString());
            object = this.currentObjects.get(string);
            if (object == null) {
                throw new JavaException(new IllegalArgumentException(struct.toString()));
            }
            clazz = object.getClass();
            if (!clazz.isArray()) {
                throw new JavaException(new IllegalArgumentException(struct.toString()));
            }
            String string2 = clazz.toString();
            if (string2.equals("class [I")) {
                if (!(term3 instanceof Number)) {
                    throw new JavaException(new IllegalArgumentException(term3.toString()));
                }
                byte by = (byte)((Number)term3).intValue();
                Array.setInt(object, number.intValue(), by);
                return true;
            } else if (string2.equals("class [D")) {
                if (!(term3 instanceof Number)) {
                    throw new JavaException(new IllegalArgumentException(term3.toString()));
                }
                double d = ((Number)term3).doubleValue();
                Array.setDouble(object, number.intValue(), d);
                return true;
            } else if (string2.equals("class [F")) {
                if (!(term3 instanceof Number)) {
                    throw new JavaException(new IllegalArgumentException(term3.toString()));
                }
                float f = ((Number)term3).floatValue();
                Array.setFloat(object, number.intValue(), f);
                return true;
            } else if (string2.equals("class [L")) {
                if (!(term3 instanceof Number)) {
                    throw new JavaException(new IllegalArgumentException(term3.toString()));
                }
                long l = ((Number)term3).longValue();
                Array.setFloat(object, number.intValue(), l);
                return true;
            } else if (string2.equals("class [C")) {
                String string3 = term3.toString();
                Array.setChar(object, number.intValue(), string3.charAt(0));
                return true;
            } else if (string2.equals("class [Z")) {
                String string4 = term3.toString();
                if (string4.equals("true")) {
                    Array.setBoolean(object, number.intValue(), true);
                    return true;
                } else {
                    if (!string4.equals("false")) throw new JavaException(new IllegalArgumentException(term3.toString()));
                    Array.setBoolean(object, number.intValue(), false);
                }
                return true;
            } else if (string2.equals("class [B")) {
                if (!(term3 instanceof Number)) {
                    throw new JavaException(new IllegalArgumentException(term3.toString()));
                }
                int n = ((Number)term3).intValue();
                Array.setByte(object, number.intValue(), (byte)n);
                return true;
            } else {
                if (!string2.equals("class [S")) throw new JavaException(new Exception());
                if (!(term3 instanceof Number)) {
                    throw new JavaException(new IllegalArgumentException(term3.toString()));
                }
                short s = (short)((Number)term3).intValue();
                Array.setShort(object, number.intValue(), s);
            }
            return true;
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    public boolean java_array_get_primitive_3(Term term, Term term2, Term term3) throws JavaException {
        Struct struct = (Struct)term.getTerm();
        Number number = (Number)term2.getTerm();
        term3 = term3.getTerm();
        Object object = null;
        if (!number.isInteger()) {
            throw new JavaException(new IllegalArgumentException(number.toString()));
        }
        try {
            Class<?> clazz = null;
            String string = Tools.removeApices(struct.toString());
            object = this.currentObjects.get(string);
            if (object == null) {
                throw new JavaException(new IllegalArgumentException(struct.toString()));
            }
            clazz = object.getClass();
            if (!clazz.isArray()) {
                throw new JavaException(new IllegalArgumentException(struct.toString()));
            }
            String string2 = clazz.toString();
            if (string2.equals("class [I")) {
                Int intVal = new Int(Array.getInt(object, number.intValue()));
                if (this.unify(term3, intVal)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            if (string2.equals("class [D")) {
                Double double_ = new Double(Array.getDouble(object, number.intValue()));
                if (this.unify(term3, double_)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            if (string2.equals("class [F")) {
                Float float_ = new Float(Array.getFloat(object, number.intValue()));
                if (this.unify(term3, float_)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            if (string2.equals("class [L")) {
                Long longVal = new Long(Array.getLong(object, number.intValue()));
                if (this.unify(term3, longVal)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            if (string2.equals("class [C")) {
                Struct struct2 = new Struct("" + Array.getChar(object, number.intValue()));
                if (this.unify(term3, struct2)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            if (string2.equals("class [Z")) {
                boolean bl = Array.getBoolean(object, number.intValue());
                if (bl) {
                    if (this.unify(term3, Term.TRUE)) {
                        return true;
                    }
                    throw new JavaException(new IllegalArgumentException(term3.toString()));
                }
                if (this.unify(term3, Term.FALSE)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            if (string2.equals("class [B")) {
                Int intVal = new Int(Array.getByte(object, number.intValue()));
                if (this.unify(term3, intVal)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            if (string2.equals("class [S")) {
                Int intVal = new Int(Array.getInt(object, number.intValue()));
                if (this.unify(term3, intVal)) {
                    return true;
                }
                throw new JavaException(new IllegalArgumentException(term3.toString()));
            }
            throw new JavaException(new Exception());
        }
        catch (Exception exception) {
            throw new JavaException(exception);
        }
    }

    private boolean java_array(String string, int n, Term term) {
        try {
            Object object = null;
            String string2 = string.substring(0, string.length() - 2);
            if (string2.equals("boolean")) {
                object = new boolean[n];
            } else if (string2.equals("byte")) {
                object = new byte[n];
            } else if (string2.equals("char")) {
                object = new char[n];
            } else if (string2.equals("short")) {
                object = new short[n];
            } else if (string2.equals("int")) {
                object = new int[n];
            } else if (string2.equals("long")) {
                object = new long[n];
            } else if (string2.equals("float")) {
                object = new float[n];
            } else if (string2.equals("double")) {
                object = new double[n];
            } else {
                Class<?> clazz = Class.forName(string2, true, this.classLoader);
                object = Array.newInstance(clazz, n);
            }
            return this.bindDynamicObject(term, object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private URL[] getURLsFromStringArray(String[] stringArray) throws MalformedURLException {
        URL[] uRLArray = null;
        if (stringArray != null) {
            uRLArray = new URL[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                if (stringArray[i].contains("http") || stringArray[i].contains("https") || stringArray[i].contains("ftp")) {
                    uRLArray[i] = new URL(stringArray[i]);
                    continue;
                }
                File file = new File(stringArray[i]);
                uRLArray[i] = file.toURI().toURL();
            }
        }
        return uRLArray;
    }

    private String[] getStringArrayFromStruct(Struct struct) {
        String[] stringArray = new String[struct.listSize()];
        Iterator<? extends Term> iterator = struct.listIterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = Tools.removeApices(iterator.next().toString());
            stringArray[n++] = string;
        }
        return stringArray;
    }

    private Signature parseArg(Struct struct) {
        Object[] objectArray = new Object[struct.getArity()];
        Class[] classArray = new Class[struct.getArity()];
        for (int i = 0; i < struct.getArity(); ++i) {
            if (this.parse_arg(objectArray, classArray, i, struct.getTerm(i))) continue;
            return null;
        }
        return new Signature(objectArray, classArray);
    }

    private Signature parseArg(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.parse_arg(objectArray2, classArray, i, (Term)objectArray[i])) continue;
            return null;
        }
        return new Signature(objectArray2, classArray);
    }

    private boolean parse_arg(Object[] objectArray, Class<?>[] classArray, int n, Term term) {
        block19: {
            try {
                if (term == null) {
                    objectArray[n] = null;
                    classArray[n] = null;
                    break block19;
                }
                if (term.isAtom()) {
                    String string = Tools.removeApices(term.toString());
                    if (string.equals("true")) {
                        objectArray[n] = Boolean.TRUE;
                        classArray[n] = Boolean.TYPE;
                    } else if (string.equals("false")) {
                        objectArray[n] = Boolean.FALSE;
                        classArray[n] = Boolean.TYPE;
                    } else {
                        Object object = this.currentObjects.get(string);
                        objectArray[n] = object == null ? string : object;
                        classArray[n] = objectArray[n].getClass();
                    }
                    break block19;
                }
                if (term instanceof Number) {
                    Number number = (Number)term;
                    if (number instanceof Int) {
                        objectArray[n] = new Integer(number.intValue());
                        classArray[n] = Integer.TYPE;
                    } else if (number instanceof Double) {
                        objectArray[n] = new java.lang.Double(number.doubleValue());
                        classArray[n] = java.lang.Double.TYPE;
                    } else if (number instanceof Long) {
                        objectArray[n] = new java.lang.Long(number.longValue());
                        classArray[n] = java.lang.Long.TYPE;
                    } else if (number instanceof Float) {
                        objectArray[n] = new java.lang.Float(number.floatValue());
                        classArray[n] = java.lang.Float.TYPE;
                    }
                    break block19;
                }
                if (term instanceof Struct) {
                    Struct struct = (Struct)term;
                    if (struct.getName().equals("as")) {
                        return this.parse_as(objectArray, classArray, n, struct.getTerm(0), struct.getTerm(1));
                    }
                    Object object = this.currentObjects.get(Tools.removeApices(struct.toString()));
                    objectArray[n] = object == null ? Tools.removeApices(struct.toString()) : object;
                    classArray[n] = objectArray[n].getClass();
                    break block19;
                }
                if (term instanceof Var && !((Var)term).isBound()) {
                    objectArray[n] = null;
                    classArray[n] = Object.class;
                    break block19;
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private boolean parse_as(Object[] objectArray, Class<?>[] classArray, int n, Term term, Term term2) {
        block31: {
            try {
                if (!(term instanceof Number)) {
                    String string = Tools.removeApices(((Struct)term2).getName());
                    String string2 = Tools.removeApices(term.getTerm().toString());
                    if (string.equals("java.lang.String") && string2.equals("true")) {
                        objectArray[n] = "true";
                        classArray[n] = String.class;
                        return true;
                    }
                    if (string.equals("java.lang.String") && string2.equals("false")) {
                        objectArray[n] = "false";
                        classArray[n] = String.class;
                        return true;
                    }
                    if (string.endsWith("[]")) {
                        string = string.equals("boolean[]") ? "[Z" : (string.equals("byte[]") ? "[B" : (string.equals("short[]") ? "[S" : (string.equals("char[]") ? "[C" : (string.equals("int[]") ? "[I" : (string.equals("long[]") ? "[L" : (string.equals("float[]") ? "[F" : (string.equals("double[]") ? "[D" : "[L" + string.substring(0, string.length() - 2) + ";")))))));
                    }
                    if (!string2.equals("null")) {
                        Object object = this.currentObjects.get(string2);
                        if (object == null) {
                            if (string.equals("boolean")) {
                                if (string2.equals("true")) {
                                    objectArray[n] = new Boolean(true);
                                } else if (string2.equals("false")) {
                                    objectArray[n] = new Boolean(false);
                                } else {
                                    return false;
                                }
                                classArray[n] = Boolean.TYPE;
                                break block31;
                            }
                            return false;
                        }
                        objectArray[n] = object;
                        try {
                            classArray[n] = Class.forName(string, true, this.classLoader);
                            break block31;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.getEngine().warn("Java class not found: " + string);
                            return false;
                        }
                    }
                    objectArray[n] = null;
                    if (string.equals("byte")) {
                        classArray[n] = Byte.TYPE;
                        break block31;
                    }
                    if (string.equals("short")) {
                        classArray[n] = Short.TYPE;
                        break block31;
                    }
                    if (string.equals("char")) {
                        classArray[n] = Character.TYPE;
                        break block31;
                    }
                    if (string.equals("int")) {
                        classArray[n] = Integer.TYPE;
                        break block31;
                    }
                    if (string.equals("long")) {
                        classArray[n] = java.lang.Long.TYPE;
                        break block31;
                    }
                    if (string.equals("float")) {
                        classArray[n] = java.lang.Float.TYPE;
                        break block31;
                    }
                    if (string.equals("double")) {
                        classArray[n] = java.lang.Double.TYPE;
                        break block31;
                    }
                    if (string.equals("boolean")) {
                        classArray[n] = Boolean.TYPE;
                        break block31;
                    }
                    try {
                        classArray[n] = Class.forName(string, true, this.classLoader);
                        break block31;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.getEngine().warn("Java class not found: " + string);
                        return false;
                    }
                }
                Number number = (Number)term;
                String string = ((Struct)term2).getName();
                if (string.equals("byte")) {
                    objectArray[n] = new Byte((byte)number.intValue());
                    classArray[n] = Byte.TYPE;
                    break block31;
                }
                if (string.equals("short")) {
                    objectArray[n] = new Short((short)number.intValue());
                    classArray[n] = Short.TYPE;
                    break block31;
                }
                if (string.equals("int")) {
                    objectArray[n] = new Integer(number.intValue());
                    classArray[n] = Integer.TYPE;
                    break block31;
                }
                if (string.equals("long")) {
                    objectArray[n] = new java.lang.Long(number.longValue());
                    classArray[n] = java.lang.Long.TYPE;
                    break block31;
                }
                if (string.equals("float")) {
                    objectArray[n] = new java.lang.Float(number.floatValue());
                    classArray[n] = java.lang.Float.TYPE;
                    break block31;
                }
                if (string.equals("double")) {
                    objectArray[n] = new java.lang.Double(number.doubleValue());
                    classArray[n] = java.lang.Double.TYPE;
                    break block31;
                }
                return false;
            }
            catch (Exception exception) {
                this.getEngine().warn("Casting " + term + " to " + term2 + " failed");
                return false;
            }
        }
        return true;
    }

    private boolean parseResult(Term term, Object object) {
        if (object == null) {
            return this.unify(term, new Var());
        }
        try {
            if (Boolean.class.isInstance(object)) {
                if (((Boolean)object).booleanValue()) {
                    return this.unify(term, Term.TRUE);
                }
                return this.unify(term, Term.FALSE);
            }
            if (Byte.class.isInstance(object)) {
                return this.unify(term, new Int(((Byte)object).intValue()));
            }
            if (Short.class.isInstance(object)) {
                return this.unify(term, new Int(((Short)object).intValue()));
            }
            if (Integer.class.isInstance(object)) {
                return this.unify(term, new Int((Integer)object));
            }
            if (java.lang.Long.class.isInstance(object)) {
                return this.unify(term, new Long((java.lang.Long)object));
            }
            if (java.lang.Float.class.isInstance(object)) {
                return this.unify(term, new Float(((java.lang.Float)object).floatValue()));
            }
            if (java.lang.Double.class.isInstance(object)) {
                return this.unify(term, new Double((java.lang.Double)object));
            }
            if (String.class.isInstance(object)) {
                return this.unify(term, new Struct((String)object));
            }
            if (Character.class.isInstance(object)) {
                return this.unify(term, new Struct(((Character)object).toString()));
            }
            return this.bindDynamicObject(term, object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Object[] getArrayFromList(Struct struct) {
        Object[] objectArray = new Object[struct.listSize()];
        Iterator<? extends Term> iterator = struct.listIterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n++] = iterator.next();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(Struct struct, Object object) throws InvalidObjectIdException {
        if (!struct.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap<String, Object> hashMap = this.staticObjects;
        synchronized (hashMap) {
            Struct struct2 = this.staticObjects_inverse.get(object);
            if (struct2 != null) {
                return false;
            }
            String string = Tools.removeApices(struct.getTerm().toString());
            this.staticObjects.put(string, object);
            this.staticObjects_inverse.put(object, struct);
            return true;
        }
    }

    public boolean register_1(Term term) throws JavaException {
        term = term.getTerm();
        Object object = null;
        try {
            object = this.getRegisteredDynamicObject((Struct)term);
            return this.register((Struct)term, object);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            this.getEngine().warn("Illegal object id " + term.toString());
            throw new JavaException(invalidObjectIdException);
        }
    }

    public boolean unregister_1(Term term) throws JavaException {
        term = term.getTerm();
        try {
            return this.unregister((Struct)term);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            this.getEngine().warn("Illegal object id " + term.toString());
            throw new JavaException(invalidObjectIdException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Struct register(Object object) {
        HashMap<String, Object> hashMap = this.staticObjects;
        synchronized (hashMap) {
            Struct struct = this.staticObjects_inverse.get(object);
            if (struct != null) {
                return struct;
            }
            Struct struct2 = this.generateFreshId();
            this.staticObjects.put(struct2.getName(), object);
            this.staticObjects_inverse.put(object, struct2);
            return struct2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRegisteredObject(Struct struct) throws InvalidObjectIdException {
        if (!struct.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap<String, Object> hashMap = this.staticObjects;
        synchronized (hashMap) {
            return this.staticObjects.get(Tools.removeApices(struct.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(Struct struct) throws InvalidObjectIdException {
        if (!struct.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap<String, Object> hashMap = this.staticObjects;
        synchronized (hashMap) {
            String string = Tools.removeApices(struct.toString());
            Object object = this.staticObjects.remove(string);
            if (object != null) {
                this.staticObjects_inverse.remove(object);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDynamic(Struct struct, Object object) {
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            String string = Tools.removeApices(struct.toString());
            this.currentObjects.put(string, object);
            this.currentObjects_inverse.put(object, struct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Struct registerDynamic(Object object) {
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            Struct struct = this.currentObjects_inverse.get(object);
            if (struct != null) {
                return struct;
            }
            Struct struct2 = this.generateFreshId();
            this.currentObjects.put(struct2.getName(), object);
            this.currentObjects_inverse.put(object, struct2);
            return struct2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRegisteredDynamicObject(Struct struct) throws InvalidObjectIdException {
        if (!struct.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            return this.currentObjects.get(Tools.removeApices(struct.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterDynamic(Struct struct) {
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            String string = Tools.removeApices(struct.toString());
            Object object = this.currentObjects.remove(string);
            if (object != null) {
                this.currentObjects_inverse.remove(object);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean bindDynamicObject(Term term, Object object) {
        if (object == null) {
            return this.unify(term, new Var());
        }
        HashMap<String, Object> hashMap = this.currentObjects;
        synchronized (hashMap) {
            Struct struct = this.currentObjects_inverse.get(object);
            if (struct != null) {
                return this.unify(term, struct);
            }
            if (term instanceof Var) {
                Struct struct2 = this.generateFreshId();
                this.unify(term, struct2);
                this.registerDynamic(struct2, object);
                return true;
            }
            String string = Tools.removeApices(term.getTerm().toString());
            Object object2 = this.currentObjects.get(string);
            if (object2 == null) {
                this.registerDynamic((Struct)term.getTerm(), object);
                return true;
            }
            return object == object2;
        }
    }

    protected Struct generateFreshId() {
        return new Struct("$obj_" + this.id++);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        HashMap<String, Object> hashMap = this.currentObjects;
        IdentityHashMap<Object, Struct> identityHashMap = this.currentObjects_inverse;
        try {
            this.currentObjects = null;
            this.currentObjects_inverse = null;
            objectOutputStream.defaultWriteObject();
        }
        catch (IOException iOException) {
            this.currentObjects = hashMap;
            this.currentObjects_inverse = identityHashMap;
            throw new IOException();
        }
        this.currentObjects = hashMap;
        this.currentObjects_inverse = identityHashMap;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.currentObjects = new HashMap();
        this.currentObjects_inverse = new IdentityHashMap();
        this.preregisterObjects();
    }

    private static Method lookupMethod(Class<?> clazz, String string, Class<?>[] classArray, Object[] objectArray) throws NoSuchMethodException {
        try {
            Method method = clazz.getMethod(string, classArray);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            int n;
            if (classArray.length == 0) {
                return null;
            }
            Method[] methodArray = clazz.getMethods();
            Vector<Method> vector = new Vector<Method>();
            for (n = 0; n != methodArray.length; ++n) {
                if (!string.equals(methodArray[n].getName()) || !JavaLibrary.matchClasses(methodArray[n].getParameterTypes(), classArray)) continue;
                vector.addElement(methodArray[n]);
            }
            switch (vector.size()) {
                case 0: {
                    for (n = 0; n != methodArray.length; ++n) {
                        Class<?>[] classArray2;
                        Object[] objectArray2;
                        if (!string.equals(methodArray[n].getName()) || (objectArray2 = JavaLibrary.matchClasses(classArray2 = methodArray[n].getParameterTypes(), classArray, objectArray)) == null) continue;
                        for (int i = 0; i < classArray2.length; ++i) {
                            classArray[i] = classArray2[i];
                            objectArray[i] = objectArray2[i];
                        }
                        return methodArray[n];
                    }
                    return null;
                }
                case 1: {
                    return (Method)vector.firstElement();
                }
            }
            return JavaLibrary.mostSpecificMethod(vector);
        }
    }

    private static Constructor<?> lookupConstructor(Class<?> clazz, Class<?>[] classArray, Object[] objectArray) throws NoSuchMethodException {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            int n;
            if (classArray.length == 0) {
                return null;
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Vector vector = new Vector();
            for (n = 0; n != constructorArray.length; ++n) {
                if (!JavaLibrary.matchClasses(constructorArray[n].getParameterTypes(), classArray)) continue;
                vector.addElement(constructorArray[n]);
            }
            switch (vector.size()) {
                case 0: {
                    for (n = 0; n != constructorArray.length; ++n) {
                        Class<?>[] classArray2 = constructorArray[n].getParameterTypes();
                        Object[] objectArray2 = JavaLibrary.matchClasses(classArray2, classArray, objectArray);
                        if (objectArray2 == null) continue;
                        for (int i = 0; i < classArray2.length; ++i) {
                            classArray[i] = classArray2[i];
                            objectArray[i] = objectArray2[i];
                        }
                        return constructorArray[n];
                    }
                    return null;
                }
                case 1: {
                    return (Constructor)vector.firstElement();
                }
            }
            return JavaLibrary.mostSpecificConstructor(vector);
        }
    }

    private static boolean matchClasses(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length == classArray2.length) {
            for (int i = 0; i != classArray.length; ++i) {
                if (JavaLibrary.matchClass(classArray[i], classArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean matchClass(Class<?> clazz, Class<?> clazz2) {
        boolean bl = clazz.isAssignableFrom(clazz2);
        if (bl) {
            return true;
        }
        return clazz.equals(java.lang.Long.TYPE) && clazz2.equals(Integer.TYPE);
    }

    private static Method mostSpecificMethod(Vector<Method> vector) throws NoSuchMethodException {
        for (int i = 0; i != vector.size(); ++i) {
            for (int j = 0; j != vector.size(); ++j) {
                if (i == j || !JavaLibrary.moreSpecific(vector.elementAt(i), vector.elementAt(j))) continue;
                vector.removeElementAt(j);
                if (i > j) {
                    --i;
                }
                --j;
            }
        }
        if (vector.size() == 1) {
            return vector.elementAt(0);
        }
        throw new NoSuchMethodException(">1 most specific method");
    }

    private static boolean moreSpecific(Method method, Method method2) {
        Class<?>[] classArray = method.getParameterTypes();
        Class<?>[] classArray2 = method2.getParameterTypes();
        int n = classArray.length;
        for (int i = 0; i != n; ++i) {
            if (JavaLibrary.matchClass(classArray2[i], classArray[i])) continue;
            return false;
        }
        return true;
    }

    private static Constructor<?> mostSpecificConstructor(Vector<Constructor<?>> vector) throws NoSuchMethodException {
        for (int i = 0; i != vector.size(); ++i) {
            for (int j = 0; j != vector.size(); ++j) {
                if (i == j || !JavaLibrary.moreSpecific(vector.elementAt(i), vector.elementAt(j))) continue;
                vector.removeElementAt(j);
                if (i > j) {
                    --i;
                }
                --j;
            }
        }
        if (vector.size() == 1) {
            return vector.elementAt(0);
        }
        throw new NoSuchMethodException(">1 most specific constructor");
    }

    private static boolean moreSpecific(Constructor<?> constructor, Constructor<?> constructor2) {
        Class<?>[] classArray = constructor.getParameterTypes();
        Class<?>[] classArray2 = constructor2.getParameterTypes();
        int n = classArray.length;
        for (int i = 0; i != n; ++i) {
            if (JavaLibrary.matchClass(classArray2[i], classArray[i])) continue;
            return false;
        }
        return true;
    }

    private static Object[] matchClasses(Class<?>[] classArray, Class<?>[] classArray2, Object[] objectArray) {
        if (classArray.length == classArray2.length) {
            Object[] objectArray2 = new Object[classArray.length];
            for (int i = 0; i != classArray.length; ++i) {
                boolean bl = classArray[i].isAssignableFrom(classArray2[i]);
                if (bl || classArray[i].equals(java.lang.Long.TYPE) && classArray2[i].equals(Integer.TYPE)) {
                    objectArray2[i] = objectArray[i];
                    continue;
                }
                if (classArray[i].equals(java.lang.Float.TYPE) && classArray2[i].equals(java.lang.Double.TYPE)) {
                    objectArray2[i] = new java.lang.Float(((java.lang.Double)objectArray[i]).floatValue());
                    continue;
                }
                if (classArray[i].equals(java.lang.Float.TYPE) && classArray2[i].equals(Integer.TYPE)) {
                    objectArray2[i] = new java.lang.Float(((Integer)objectArray[i]).intValue());
                    continue;
                }
                if (classArray[i].equals(java.lang.Double.TYPE) && classArray2[i].equals(Integer.TYPE)) {
                    objectArray2[i] = new java.lang.Double(((Integer)objectArray[i]).doubleValue());
                    continue;
                }
                if (objectArray[i] == null && !classArray[i].isPrimitive()) {
                    objectArray2[i] = null;
                    continue;
                }
                return null;
            }
            return objectArray2;
        }
        return null;
    }
}

