/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.AbstractSocket;
import alice.tuprolog.Client_Socket;
import alice.tuprolog.Datagram_Socket;
import alice.tuprolog.Int;
import alice.tuprolog.Library;
import alice.tuprolog.Prolog;
import alice.tuprolog.PrologError;
import alice.tuprolog.Server_Socket;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.tuprolog.interfaces.ISocketLib;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;

public class SocketLibrary
extends Library
implements ISocketLib {
    private String addrRegex = "[\\. :]";
    private LinkedList<ThreadReader> readers = new LinkedList();
    private LinkedList<ServerSocket> serverSockets = new LinkedList();
    private LinkedList<Socket> clientSockets = new LinkedList();

    @Override
    public String getTheory() {
        return "";
    }

    @Override
    public boolean udp_socket_open_2(Struct struct, Term term) throws PrologError {
        if (!(term.getTerm() instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        byte[] byArray = new byte[4];
        Pattern pattern = Pattern.compile(this.addrRegex);
        String[] stringArray = pattern.split(struct.getName());
        if (stringArray.length != 5) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i]);
        }
        int n = Integer.parseInt(stringArray[stringArray.length - 1]);
        try {
            DatagramSocket datagramSocket = new DatagramSocket(n, InetAddress.getByAddress(byArray));
            term.unify(this.getEngine(), new Datagram_Socket(datagramSocket));
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        return true;
    }

    @Override
    public boolean udp_send_3(Term term, Term term2, Struct struct) throws PrologError {
        if (!(term.getTerm() instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        byte[] byArray = new byte[4];
        Pattern pattern = Pattern.compile(this.addrRegex);
        String[] stringArray = pattern.split(struct.getName());
        if (stringArray.length != 5) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i]);
        }
        int n = Integer.parseInt(stringArray[stringArray.length - 1]);
        DatagramSocket datagramSocket = ((Datagram_Socket)term.getTerm()).getSocket();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(term2);
            objectOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, n);
            datagramSocket.send(datagramPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean udp_socket_close_1(Term term) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!((Server_Socket)term.getTerm()).isDatagramSocket()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        DatagramSocket datagramSocket = ((Datagram_Socket)term.getTerm()).getSocket();
        datagramSocket.close();
        return true;
    }

    @Override
    public boolean udp_receive(Term term, Term term2, Struct struct, Struct struct2) throws PrologError {
        if (!(term.getTerm() instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        byte[] byArray = new byte[4];
        Pattern pattern = Pattern.compile(this.addrRegex);
        String[] stringArray = pattern.split(struct.getName());
        if (stringArray.length != 5) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i]);
        }
        int n = Integer.parseInt(stringArray[stringArray.length - 1]);
        DatagramSocket datagramSocket = ((Datagram_Socket)term.getTerm()).getSocket();
        byte[] byArray2 = new byte[100000];
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length);
        try {
            datagramSocket.receive(datagramPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        LinkedList<Term> linkedList = this.StructToList(struct2);
        for (Term term3 : linkedList) {
            int n2;
            if (((Struct)term3).getName().equals("timeout")) {
                n2 = Integer.parseInt(((Struct)term3).getArg(0).toString());
                try {
                    datagramSocket.setSoTimeout(n2);
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                }
            }
            if (!((Struct)term3).getName().equals("size")) continue;
            n2 = Integer.parseInt(((Struct)term3).getArg(0).toString());
            datagramPacket.setLength(n2);
        }
        return true;
    }

    @Override
    public boolean tcp_socket_server_open_3(Struct struct, Term term, Struct struct2) throws PrologError {
        int n = 0;
        if (!(term.getTerm() instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        byte[] byArray = new byte[4];
        Pattern pattern = Pattern.compile(this.addrRegex);
        String[] stringArray = pattern.split(struct.getName());
        if (stringArray.length != 5) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i]);
        }
        int n2 = Integer.parseInt(stringArray[stringArray.length - 1]);
        LinkedList<Term> linkedList = this.StructToList(struct2);
        for (Term term2 : linkedList) {
            if (!((Struct)term2).getName().equals("backlog")) continue;
            n = Integer.parseInt(((Struct)term2).getArg(0).toString());
        }
        try {
            ServerSocket serverSocket = new ServerSocket(n2, n, InetAddress.getByAddress(byArray));
            this.addServerSocket(serverSocket);
            term.unify(this.getEngine(), new Server_Socket(serverSocket));
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        return true;
    }

    private void addServerSocket(ServerSocket serverSocket) {
        for (ServerSocket serverSocket2 : this.serverSockets) {
            if (!serverSocket2.equals(serverSocket)) continue;
            return;
        }
        this.serverSockets.add(serverSocket);
    }

    private void addClientSocket(Socket socket) {
        for (Socket socket2 : this.clientSockets) {
            if (!socket2.equals(socket)) continue;
            return;
        }
        this.clientSockets.add(socket);
    }

    @Override
    public boolean tcp_socket_server_accept_3(Term term, Term term2, Term term3) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        AbstractSocket abstractSocket = (AbstractSocket)term.getTerm();
        if (!abstractSocket.isServerSocket()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        ServerSocket serverSocket = ((Server_Socket)term.getTerm()).getSocket();
        try {
            Socket socket = serverSocket.accept();
            term2.unify(this.getEngine(), new Struct(socket.getInetAddress().getHostAddress() + ":" + socket.getPort()));
            term3.unify(this.getEngine(), new Client_Socket(socket));
            this.addClientSocket(socket);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean tcp_socket_client_open_2(Struct struct, Term term) throws PrologError {
        if (!(term.getTerm() instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        byte[] byArray = new byte[4];
        Pattern pattern = Pattern.compile(this.addrRegex);
        String[] stringArray = pattern.split(struct.getName());
        if (stringArray.length != 5) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            byArray[i] = Byte.parseByte(stringArray[i]);
        }
        int n = Integer.parseInt(stringArray[stringArray.length - 1]);
        try {
            Socket socket = new Socket(InetAddress.getByAddress(byArray), n);
            term.unify(this.getEngine(), new Client_Socket(socket));
            this.addClientSocket(socket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean tcp_socket_server_close_1(Term term) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!((Server_Socket)term.getTerm()).isServerSocket()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        try {
            ServerSocket serverSocket = ((Server_Socket)term.getTerm()).getSocket();
            serverSocket.close();
            for (int i = 0; i < this.serverSockets.size(); ++i) {
                if (!this.serverSockets.get(i).equals(serverSocket)) continue;
                this.serverSockets.remove(i);
                return true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean write_to_socket_2(Term term, Term term2) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (((AbstractSocket)term.getTerm()).isServerSocket()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (term2.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        Socket socket = ((Client_Socket)term.getTerm()).getSocket();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(term2);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean read_from_socket_3(Term term, Term term2, Struct struct) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!(term2.getTerm() instanceof Var)) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 2);
        }
        if (!((AbstractSocket)term.getTerm()).isClientSocket()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        Socket socket = ((Client_Socket)term.getTerm()).getSocket();
        ThreadReader threadReader = this.readerExist(socket);
        if (threadReader != null && threadReader.started()) {
            return false;
        }
        LinkedList<Term> linkedList = this.StructToList(struct);
        for (Term term3 : linkedList) {
            if (!((Struct)term3).getName().equals("timeout")) continue;
            int n = Integer.parseInt(((Struct)term3).getArg(0).toString());
            try {
                socket.setSoTimeout(n);
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
                return false;
            }
        }
        try {
            Term term3;
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            term3 = (Term)objectInputStream.readObject();
            term2.unify(this.getEngine(), term3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean aread_from_socket_2(Term term, Struct struct) throws PrologError {
        Serializable serializable;
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        if (!((AbstractSocket)term.getTerm()).isClientSocket()) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        Socket socket = ((Client_Socket)term.getTerm()).getSocket();
        ThreadReader threadReader = this.readerExist(socket);
        if (threadReader == null) {
            serializable = this;
            synchronized (serializable) {
                this.readers.add(new ThreadReader(socket, this.getEngine()));
                threadReader = this.readers.getLast();
            }
        }
        if (threadReader.started()) {
            return true;
        }
        try {
            socket.setSoTimeout(0);
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        serializable = this.StructToList(struct);
        Iterator iterator = ((AbstractSequentialList)((Object)serializable)).iterator();
        while (iterator.hasNext()) {
            Term term2 = (Term)iterator.next();
            if (((Struct)term2).getName().equals("timeout")) {
                int n = Integer.parseInt(((Struct)term2).getArg(0).toString());
                try {
                    socket.setSoTimeout(n);
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                    return false;
                }
            }
            if (!((Struct)term2).getName().equals("assertZ")) continue;
            threadReader.assertZ();
        }
        threadReader.startRead();
        return true;
    }

    private LinkedList<Term> StructToList(Struct struct) {
        LinkedList<Term> linkedList = new LinkedList<Term>();
        Term term = struct;
        while (term.getName().equals(".")) {
            linkedList.add(term.getArg(0));
            term = term.getArg(1);
        }
        return linkedList;
    }

    private ThreadReader readerExist(Socket socket) {
        for (ThreadReader threadReader : this.readers) {
            if (!threadReader.compareSocket(socket)) continue;
            return threadReader;
        }
        return null;
    }

    @Override
    public void onSolveEnd() {
        for (ServerSocket object : this.serverSockets) {
            try {
                object.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.serverSockets = new LinkedList();
        for (Socket socket : this.clientSockets) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.clientSockets = new LinkedList();
        for (ThreadReader threadReader : this.readers) {
            threadReader.stopRead();
        }
    }

    @Override
    public void onSolveHalt() {
        this.onSolveEnd();
    }

    public boolean getAddress_2(Term term, Term term2) throws PrologError {
        if (term.getTerm() instanceof Var) {
            throw PrologError.instantiation_error(this.engine.getEngineManager(), 1);
        }
        AbstractSocket abstractSocket = (AbstractSocket)term.getTerm();
        if (abstractSocket.isClientSocket()) {
            Socket socket = ((Client_Socket)term.getTerm()).getSocket();
            term2.unify(this.getEngine(), new Struct(socket.getInetAddress().toString(), (Term)new Struct(new Int(socket.getLocalPort()).toString())));
            return true;
        }
        if (abstractSocket.isServerSocket()) {
            ServerSocket serverSocket = ((Server_Socket)term.getTerm()).getSocket();
            term2.unify(this.getEngine(), new Struct(serverSocket.getInetAddress().toString(), (Term)new Struct(new Int(serverSocket.getLocalPort()).toString())));
            return true;
        }
        if (abstractSocket.isDatagramSocket()) {
            DatagramSocket datagramSocket = ((Datagram_Socket)term.getTerm()).getSocket();
            term2.unify(this.getEngine(), new Struct(datagramSocket.getInetAddress().toString(), (Term)new Struct(new Int(datagramSocket.getLocalPort()).toString())));
            return true;
        }
        return true;
    }

    private class ThreadReader
    extends Thread {
        private Socket socket;
        private Prolog mainEngine;
        private boolean assertA;
        private volatile boolean started;
        private Semaphore sem;

        protected ThreadReader(Socket socket, Prolog prolog) {
            this.socket = socket;
            this.mainEngine = prolog;
            this.assertA = true;
            this.started = false;
            this.sem = new Semaphore(0);
            this.start();
        }

        protected synchronized void startRead() {
            if (this.started) {
                return;
            }
            this.started = true;
            this.sem.release();
        }

        protected boolean started() {
            return this.started;
        }

        protected synchronized void stopRead() {
            this.interrupt();
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected synchronized void assertZ() {
            this.assertA = false;
        }

        protected boolean compareSocket(Socket socket) {
            return socket.equals(this.socket);
        }

        @Override
        public void run() {
            while (true) {
                if (!this.started) {
                    try {
                        this.sem.acquire();
                        if (!this.isInterrupted()) continue;
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
                    if (this.isInterrupted()) {
                        return;
                    }
                    Term term = (Term)objectInputStream.readObject();
                    if (this.isInterrupted()) {
                        return;
                    }
                    Struct struct = (Struct)Term.createTerm(term.getTerm().toString());
                    if (this.assertA) {
                        this.mainEngine.getTheoryManager().assertA(struct, true, "", false);
                    } else {
                        this.mainEngine.getTheoryManager().assertZ(struct, true, "", false);
                    }
                    this.assertA = true;
                    this.started = false;
                }
                catch (IOException iOException) {
                    this.started = false;
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    this.started = false;
                    return;
                }
            }
        }
    }
}

