/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.EngineManager;
import alice.tuprolog.Int;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Library;
import alice.tuprolog.NoSolutionException;
import alice.tuprolog.Prolog;
import alice.tuprolog.PrologError;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Term;

public class ThreadLibrary
extends Library {
    protected EngineManager engineManager;

    @Override
    public void setEngine(Prolog prolog) {
        this.engine = prolog;
        this.engineManager = prolog.getEngineManager();
    }

    public boolean thread_id_1(Term term) throws PrologError {
        int n = this.engineManager.runnerId();
        this.unify(term, new Int(n));
        return true;
    }

    public boolean thread_create_2(Term term, Term term2) {
        return this.engineManager.threadCreate(term, term2);
    }

    public boolean thread_join_2(Term term, Term term2) throws PrologError {
        Term term3;
        if (!((term = term.getTerm()) instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        SolveInfo solveInfo = this.engineManager.join(((Int)term).intValue());
        if (solveInfo == null) {
            return false;
        }
        try {
            term3 = solveInfo.getSolution();
        }
        catch (NoSolutionException noSolutionException) {
            return false;
        }
        try {
            this.unify(term2, term3);
        }
        catch (InvalidTermException invalidTermException) {
            throw PrologError.syntax_error(this.engine.getEngineManager(), -1, invalidTermException.line, invalidTermException.pos, term2);
        }
        return true;
    }

    public boolean thread_read_2(Term term, Term term2) throws PrologError {
        Term term3;
        if (!((term = term.getTerm()) instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        SolveInfo solveInfo = this.engineManager.read(((Int)term).intValue());
        if (solveInfo == null) {
            return false;
        }
        try {
            term3 = solveInfo.getSolution();
        }
        catch (NoSolutionException noSolutionException) {
            return false;
        }
        try {
            this.unify(term2, term3);
        }
        catch (InvalidTermException invalidTermException) {
            throw PrologError.syntax_error(this.engine.getEngineManager(), -1, invalidTermException.line, invalidTermException.pos, term2);
        }
        return true;
    }

    public boolean thread_has_next_1(Term term) throws PrologError {
        if (!((term = term.getTerm()) instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        return this.engineManager.hasNext(((Int)term).intValue());
    }

    public boolean thread_next_sol_1(Term term) throws PrologError {
        if (!((term = term.getTerm()) instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        return this.engineManager.nextSolution(((Int)term).intValue());
    }

    public boolean thread_detach_1(Term term) throws PrologError {
        if (!((term = term.getTerm()) instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        this.engineManager.detach(((Int)term).intValue());
        return true;
    }

    public boolean thread_sleep_1(Term term) throws PrologError {
        if (!((term = term.getTerm()) instanceof Int)) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "integer", term);
        }
        long l = ((Int)term).intValue();
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("ERRORE SLEEP");
            return false;
        }
        return true;
    }

    public boolean thread_send_msg_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Int) {
            return this.engineManager.sendMsg(((Int)term).intValue(), term2);
        }
        if (!term.isAtomic() || !term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom, atomic or integer", term);
        }
        return this.engineManager.sendMsg(term.toString(), term2);
    }

    public boolean thread_get_msg_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Int) {
            return this.engineManager.getMsg(((Int)term).intValue(), term2);
        }
        if (!term.isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom, atomic or integer", term);
        }
        return this.engineManager.getMsg(term.toString(), term2);
    }

    public boolean thread_peek_msg_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Int) {
            return this.engineManager.peekMsg(((Int)term).intValue(), term2);
        }
        if (!term.isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom, atomic or integer", term);
        }
        return this.engineManager.peekMsg(term.toString(), term2);
    }

    public boolean thread_wait_msg_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Int) {
            return this.engineManager.waitMsg(((Int)term).intValue(), term2);
        }
        if (!term.isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom, atomic or integer", term);
        }
        return this.engineManager.waitMsg(term.toString(), term2);
    }

    public boolean thread_remove_msg_2(Term term, Term term2) throws PrologError {
        if ((term = term.getTerm()) instanceof Int) {
            return this.engineManager.removeMsg(((Int)term).intValue(), term2);
        }
        if (!term.isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom, atomic or integer", term);
        }
        return this.engineManager.removeMsg(term.toString(), term2);
    }

    public boolean msg_queue_create_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtomic() || !term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        return this.engineManager.createQueue(term.toString());
    }

    public boolean msg_queue_destroy_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtomic() || !term.isAtom()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        this.engineManager.destroyQueue(term.toString());
        return true;
    }

    public boolean msg_queue_size_2(Term term, Term term2) throws PrologError {
        int n;
        if ((term = term.getTerm()) instanceof Int) {
            n = this.engineManager.queueSize(((Int)term).intValue());
        } else {
            if (!term.isAtom() || !term.isAtomic()) {
                throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom, atomic or integer", term);
            }
            n = this.engineManager.queueSize(term.toString());
        }
        if (n < 0) {
            return false;
        }
        return this.unify(term2, new Int(n));
    }

    public boolean mutex_create_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        return this.engineManager.createLock(term.toString());
    }

    public boolean mutex_destroy_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        this.engineManager.destroyLock(term.toString());
        return true;
    }

    public boolean mutex_lock_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        return this.engineManager.mutexLock(term.toString());
    }

    public boolean mutex_trylock_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        return this.engineManager.mutexTryLock(term.toString());
    }

    public boolean mutex_unlock_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        return this.engineManager.mutexUnlock(term.toString());
    }

    public boolean mutex_isLocked_1(Term term) throws PrologError {
        if (!(term = term.getTerm()).isAtom() || !term.isAtomic()) {
            throw PrologError.type_error(this.engine.getEngineManager(), 1, "atom or atomic", term);
        }
        return this.engineManager.isLocked(term.toString());
    }

    public boolean mutex_unlock_all_0() {
        this.engineManager.unlockAll();
        return true;
    }

    @Override
    public String getTheory() {
        return "thread_execute(ID, GOAL):- thread_create(ID, GOAL), '$next'(ID). \n'$next'(ID). \n'$next'(ID) :- '$thread_execute2'(ID). \n'$thread_execute2'(ID) :- not thread_has_next(ID),!,false. \n'$thread_execute2'(ID) :- thread_next_sol(ID). \n'$thread_execute2'(ID) :- '$thread_execute2'(ID). \nwith_mutex(MUTEX,GOAL):-mutex_lock(MUTEX), call(GOAL), !, mutex_unlock(MUTEX).\nwith_mutex(MUTEX,GOAL):-mutex_unlock(MUTEX), fail.";
    }
}

