/*
 * Decompiled with CFR 0.152.
 */
package alice.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;

public class DynamicURLClassLoader
extends ClassLoader {
    private ArrayList<URL> listURLs = null;
    private Hashtable<String, Class<?>> classCache = new Hashtable();

    public DynamicURLClassLoader() {
        super(DynamicURLClassLoader.class.getClassLoader());
        this.listURLs = new ArrayList();
    }

    public DynamicURLClassLoader(URL[] uRLArray) {
        super(DynamicURLClassLoader.class.getClassLoader());
        this.listURLs = new ArrayList<URL>(Arrays.asList(uRLArray));
    }

    public DynamicURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        this.listURLs = new ArrayList<URL>(Arrays.asList(uRLArray));
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.findClass(string);
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        String string2 = string.replace(".", File.separator);
        clazz = this.classCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.findSystemClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (URL uRL : this.listURLs) {
                try {
                    InputStream inputStream = null;
                    byte[] byArray = null;
                    if (uRL.toString().endsWith(".jar")) {
                        uRL = new URL("jar", "", uRL + "!/" + string2 + ".class");
                        inputStream = uRL.openConnection().getInputStream();
                    }
                    if (uRL.toString().indexOf("/", uRL.toString().length() - 1) != -1) {
                        uRL = new URL(uRL.toString() + string2 + ".class");
                        inputStream = uRL.openConnection().getInputStream();
                    }
                    byArray = this.getClassData(inputStream);
                    try {
                        clazz = this.defineClass(string, byArray, 0, byArray.length, null);
                        this.classCache.put(string, clazz);
                    }
                    catch (SecurityException securityException) {
                        clazz = super.loadClass(string);
                    }
                    return clazz;
                }
                catch (Exception exception) {
                }
            }
            throw new ClassNotFoundException(string);
        }
    }

    private byte[] getClassData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = inputStream.read();
        while (-1 != n) {
            byteArrayOutputStream.write(n);
            n = inputStream.read();
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void addURLs(URL[] uRLArray) throws MalformedURLException {
        if (uRLArray == null) {
            throw new IllegalArgumentException("Array URLs must not be null.");
        }
        for (URL uRL : uRLArray) {
            if (this.listURLs.contains(uRL)) continue;
            this.listURLs.add(uRL);
        }
    }

    public void removeURL(URL uRL) throws IllegalArgumentException {
        if (!this.listURLs.contains(uRL)) {
            throw new IllegalArgumentException("URL: " + uRL + "not found.");
        }
        this.listURLs.remove(uRL);
    }

    public void removeURLs(URL[] uRLArray) throws IllegalArgumentException {
        if (uRLArray == null) {
            throw new IllegalArgumentException("Array URLs must not be null.");
        }
        for (URL uRL : uRLArray) {
            if (!this.listURLs.contains(uRL)) {
                throw new IllegalArgumentException("URL: " + uRL + "not found.");
            }
            this.listURLs.remove(uRL);
        }
    }

    public void removeAllURLs() {
        if (!this.listURLs.isEmpty()) {
            this.listURLs.clear();
        }
    }

    public URL[] getURLs() {
        URL[] uRLArray = new URL[this.listURLs.size()];
        this.listURLs.toArray(uRLArray);
        return uRLArray;
    }

    public Class<?>[] getLoadedClasses() {
        Class[] classArray = new Class[this.classCache.size()];
        int n = 0;
        Iterator<Class<?>> iterator = this.classCache.values().iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            classArray[n] = clazz = iterator.next();
        }
        return classArray;
    }

    public void clearCache() {
        this.classCache.clear();
    }

    public void removeClassCacheEntry(String string) {
        this.classCache.remove(string);
    }

    public void setClassCacheEntry(Class<?> clazz) {
        if (this.classCache.contains(clazz)) {
            this.classCache.remove(clazz.getName());
        }
        this.classCache.put(clazz.getName(), clazz);
    }
}

