/*
 * Decompiled with CFR 0.152.
 */
package alice.util;

import java.lang.reflect.Method;

public class InspectionUtils {
    public static Method searchForMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray2;
            if (!methodArray[i].getName().equals(string) || (classArray2 = methodArray[i].getParameterTypes()).length != classArray.length || !InspectionUtils.areTypesCompatible(classArray2, classArray)) continue;
            return methodArray[i];
        }
        return null;
    }

    public static boolean areTypesCompatible(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i] == null) continue;
            if (classArray[i].isInterface()) {
                Class<?>[] classArray3;
                for (Class<?> clazz : classArray3 = classArray2[i].getInterfaces()) {
                    if (!classArray[i].equals(clazz)) continue;
                    return true;
                }
            }
            if (InspectionUtils.translateFromPrimitive(classArray[i]).isAssignableFrom(InspectionUtils.translateFromPrimitive(classArray2[i]))) continue;
            return false;
        }
        return true;
    }

    public static Class<?> translateFromPrimitive(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        throw new RuntimeException("Error translating type:" + clazz);
    }
}

