/*
 * Decompiled with CFR 0.152.
 */
package alice.util;

import java.util.List;
import java.util.NoSuchElementException;

public class OneWayList<E> {
    private E head;
    private OneWayList<E> tail;

    public OneWayList(E e, OneWayList<E> oneWayList) {
        this.head = e;
        this.tail = oneWayList;
    }

    public static <T> OneWayList<T> transform(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return new OneWayList<T>(list.remove(0), OneWayList.transform(list));
    }

    public static <T> OneWayList<T> transform2(List<T> list) {
        OneWayList<T> oneWayList = null;
        OneWayList<T> oneWayList2 = null;
        for (T t : list) {
            OneWayList<T> oneWayList3 = new OneWayList<T>(t, null);
            if (oneWayList == null) {
                oneWayList = oneWayList2 = oneWayList3;
                continue;
            }
            oneWayList2.tail = oneWayList3;
            oneWayList2 = oneWayList3;
        }
        return oneWayList;
    }

    public E getHead() {
        return this.head;
    }

    public void setHead(E e) {
        this.head = e;
    }

    public OneWayList<E> getTail() {
        return this.tail;
    }

    public void setTail(OneWayList<E> oneWayList) {
        this.tail = oneWayList;
    }

    public void addLast(OneWayList<E> oneWayList) {
        if (this.tail == null) {
            this.tail = oneWayList;
            return;
        }
        this.tail.addLast(oneWayList);
    }

    public OneWayList<E> get(int n) {
        if (this.tail == null) {
            throw new NoSuchElementException();
        }
        if (n <= 0) {
            return this;
        }
        return this.tail.get(n - 1);
    }

    public String toString() {
        String string = this.head == null ? "null" : this.head.toString();
        if (this.tail == null) {
            return "[" + string + "]";
        }
        return "[" + super.toString(string) + "]";
    }

    private String toString(String string) {
        String string2 = this.head == null ? "null" : this.head.toString();
        if (this.tail == null) {
            return string + "," + string2;
        }
        return string + "," + super.toString(string2);
    }
}

