/*
 * Decompiled with CFR 0.152.
 */
package alice.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ReadOnlyLinkedList<E>
implements List<E> {
    protected LinkedList<E> list;

    public ReadOnlyLinkedList() {
        this.list = new LinkedList();
    }

    public ReadOnlyLinkedList(LinkedList<E> linkedList) {
        this.list = linkedList != null ? linkedList : new LinkedList();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return new ListItr(this.list, 0);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public E get(int n) {
        return this.list.get(n);
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException("This is a read-only list");
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(this.list, 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListItr(this.list, n);
    }

    @Override
    public List<E> subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    public LinkedList<E> getEditableCopy() {
        return new LinkedList<E>(this.list);
    }

    private class ListItr
    implements ListIterator<E> {
        private ListIterator<E> it;

        public ListItr(LinkedList<E> linkedList, int n) {
            this.it = linkedList.listIterator(n);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public E previous() {
            return this.it.previous();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException("This is a read-only list");
        }
    }
}

