OsmAnd (OSM Automated Navigation Directions)
------------
<p>This project aims at providing comfortable map viewing and navigation (routing) application for mobile devices. Particluar stress lies with complete offline features (via pre-loaded offline map data) or economic internet usage.
To get started, continue with the basic description below, then find more detail on our Welcome Wiki Pages, the Project Homepage, or the OpenStreetMap OsmAnd Wiki Page.
You are welcome to discuss any question regarding the project at the google group OsmAnd. Please do not use comments on wiki pages because it is rather difficult to find them.
</p>

[![tip for next commit](http://tip4commit.com/projects/33.svg)](http://tip4commit.com/projects/33)

Functionality
-------------
**OsmAnd (OSM Automated Navigation Directions)** is a map and navigation application with access to the free, worldwide, and high-quality OpenStreetMap (OSM) data. All map data can be stored on your device's memory card for offline use. Via your device's GPS, OsmAnd offers routing, with optical and voice guidance, for car, bike, and pedestrian. All the main functionalities work both online and offline (no internet needed).

##Some of the main features:

#### Navigation
 * Works online (fast) or offline (no roaming charges when you are abroad)
 * Turn-by-turn voice guidance (recorded and synthesized voices)
 * Optional lane guidance, street name display, and estimated time of arrival
 * Supports intermediate points on your itinerary
 * Automatic re-routing whenever you deviate from the route
 * Search for places by address, by type (e.g. restaurant, hotel, gas station, museum), or by geographical coordinates

#### Map Viewing
 * Display your position and orientation on the map
 * Optionally align the map according to compass or your direction of motion
 * Save your most important places as Favorites
 * Display POIs (point of interests) around you
 * Can display specialized online tile maps
 * Can display satellite view (from Bing)
 * Can display different overlays like touring/navigation GPX tracks and additional maps with customizable transparency
 * Optionally display place names in English, local, or phonetic spelling

#### Use OpenStreetMap and Wikipedia Data
 * High quality information from the best collaborative projects of the world
 * Global maps from OpenStreetMap, available per country or region
 * Wikipedia POIs, great for sightseeing (not available in free version)
 * Unlimited free download, directly from the app (download limit 16 map files in free version)
 * Always up-to-date maps (updated at least once a month)
 * Compact offline vector maps
 * Select between complete map data and just road network (Example: All of Japan is 700 MB, or 200 MB for the road network only)
 * Also supports online or cached tile maps

#### Safety Features
 * Optional automated day/night view switching
 * Optional speed limit display, with reminder if you exceed it
 * Optional speed-dependent map zooming
 * Share your location so that your friends can find you

#### Bicycle and Pedestrian Features
 * The maps include foot, hiking, and bike paths, great for outdoor activities
 * Special routing and display modes for bike and pedestrian
 * Optional public transport stops (bus, tram, train) including line names
 * Optional trip recording to local GPX file or online service
 * Optional speed and altitude display
 * Display of contour lines and hill-shading (via additional plugin)

#### Directly Contribute to OpenStreetMap
 * Report map bugs
 * Upload GPX tracks to OSM directly from the app
 * Add POIs and directly upload them to OSM (or later if offline)
 * Optional trip recording also in background mode (while device is in sleep mode)

<p>OsmAnd is open source and actively being developed. Everyone can contribute to the application by reporting bugs, improving translations, or coding new features. The project is in a lively state of continuous improvement by all these forms of developer and user interaction. The project progress also relies on financial contributions to fund the development, coding, and testing of new functionalities. By buying OsmAnd+ you help the application to be even more awesome! It is also possible to fund specific new features, or to make a general donation on http://osmand.net. </p>


####  Approximate map coverage and quality:
 * Western Europe: ++++
 * Eastern Europe: +++
 * Russia: +++
 * North America: +++
 * South America: ++
 * Asia: ++
 * Japan &amp; Korea: +++
 * Middle East: ++
 * Africa: ++
 * Antarctica: +

<p>
List of countries supported (basically world wide!):
Afghanistan, Albania, Algeria, Andorra, Angola, Anguilla, Antigua and Barbuda, Argentina, Armenia, Aruba, Australia, Austria, Azerbaijan, Bahamas, Bahrain, Bangladesh, Barbados, Belarus, Belgium, Belize, Benin, Bermuda, Bhutan, Bolivia, Bonaire, Bosnia and Herzegovina, Botswana, Brazil, British Virgin Islands, Brunei, Bulgaria, Burkina Faso, Burundi, Cambodia, Cameroon, Canada, Cape Verde, Central African Republic, Chad, Chile, China, Colombia, Comoros, Congo, Costa Rica, Ivory Coast, Croatia, Cuba, Curaçao, Cyprus, Czech Republic, Denmark, Djibouti, Dominica, Dominican Republic, Ecuador, Egypt, El Salvador, Equatorial Guinea, Eritrea, Estonia, Ethiopia, Fiji, Finland, France, French Guiana, French Polynesia, Gabon, Gambia, Georgia, Germany, Ghana, Gibraltar, Greece, Greenland, Grenada, Guadeloupe, Guam, Guatemala, Guernsey, Guinea, Guinea-Bissau, Guyana, Haiti, Vatican, Honduras, Hong Kong, Hungary, Iceland, India, Indonesia, Iran, Iraq, Ireland, Isle of Man, Israel, Italy, Jamaica, Japan, Jersey, Jordan, Kazakhstan, Kenya, Kiribati, North Korea and South Korea, Kuwait, Kyrgyzstan, Laos, Latvia, Lebanon, Lesotho, Liberia, Libya, Liechtenstein, Lithuania, Luxembourg, Macao, Macedonia, Madagascar, Malawi, Malaysia, Maldives, Mali, Malta, Martinique, Mauritania, Mauritius, Mayotte, Mexico, Micronesia, Moldova, Monaco, Mongolia, Montenegro, Montserrat, Morocco, Mozambique, Myanmar, Namibia, Nauru, Nepal, Netherlands, Netherlands Antilles, New Caledonia, New Zealand, Nicaragua, Niger, Nigeria, Norway, Oman, Pakistan, Palau, Palestinian Territory, Panama, Papua New Guinea, Paraguay, Peru, Philippines, Poland, Portugal, Puerto Rico, Qatar, Romania, Russia, Rwanda, Saint Barthelemy, Saint Helena, Saint Kitts and Nevis, Saint Lucia, Saint Martin, Saint Pierre and Miquelon, Saint Vincent and the Grenadines, Samoa, San Marino, Saudi Arabia, Senegal, Serbia, Seychelles, Sierra Leone, Singapore, Slovakia, Slovenia, Somalia, South Africa, South Georgia, South Sudan, Spain, Sri Lanka, Sudan, Suriname, Swaziland, Sweden, Switzerland, Syria, Taiwan, Tajikistan, Tanzania, Thailand, Timor-Leste, Togo, Tokelau, Tonga, Trinidad and Tobago, Tunisia, Turkey, Turkmenistan, Tuvalu, Uganda, Ukraine, United Arab Emirates, United Kingdom (UK), United States of America (USA), Uruguay, Uzbekistan, Vanuatu, Venezuela, Vietnam, Wallis and Futuna, Western Sahara, Yemen, Zambia, Zimbabwe.
</p>
