package net.rocrail.androc.activities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.rocrail.androc.R;
import net.rocrail.androc.interfaces.Mobile;
import net.rocrail.androc.objects.Car;
import net.rocrail.androc.objects.Loco;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class LocoExpListAdapter extends BaseExpandableListAdapter {
  Context m_Context = null;
  List<Mobile> m_MobileList     = null;
  List<Mobile> m_SteamList    = new ArrayList<Mobile>();
  List<Mobile> m_DieselList   = new ArrayList<Mobile>();
  List<Mobile> m_ElectricList = new ArrayList<Mobile>();
  List<Mobile> m_TrainsetList = new ArrayList<Mobile>();
  List<Mobile> m_SpecialList  = new ArrayList<Mobile>();
  List<Mobile> m_CarList      = new ArrayList<Mobile>();
  List<Mobile>[] m_Lists      = new ArrayList[6];
  boolean sortbyaddr = false;

  public LocoExpListAdapter(Context context, List<Mobile> locoList) {
    m_Context = context;
    m_MobileList = locoList;
    m_Lists[0] = m_SteamList;
    m_Lists[1] = m_DieselList;
    m_Lists[2] = m_ElectricList;
    m_Lists[3] = m_TrainsetList;
    m_Lists[4] = m_SpecialList;
    m_Lists[5] = m_CarList;
    Iterator<Mobile> it = m_MobileList.iterator();
    while( it.hasNext() ) {
      Mobile mobile = it.next();
      if( mobile instanceof Loco ) {
        Loco loco = (Loco)mobile;
        if( loco.isShow() ) {
          if( loco.Cargo.equals("commuter") || loco.Commuter )
            m_TrainsetList.add(loco);
          else if( loco.Cargo.equals("post") || loco.Cargo.equals("cleaning") )
            m_SpecialList.add(loco);
          else if( loco.Engine.equals("steam"))
            m_SteamList.add(loco);
          else if( loco.Engine.equals("diesel"))
            m_DieselList.add(loco);
          else if( loco.Engine.equals("electric"))
            m_ElectricList.add(loco);
          else
            m_SpecialList.add(loco);
        }
      }
      else if(mobile instanceof Car) {
        Car car = (Car)mobile;
        m_CarList.add(car);
      }
      
    }

  }
  
  @Override
  public Object getChild(int group, int child) {
    List<Mobile> list = m_Lists[group];
    if( list.size() >= child )
      return list.get(child).getID();
    return null;
  }

  @Override
  public long getChildId(int group, int child) {
    return group * 1000 + child;
  }

  @Override
  public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
    return getCustomChildView(groupPosition, childPosition, convertView, parent);
  }

  @Override
  public int getChildrenCount(int group) {
    switch(group) {
    case 0: return m_SteamList.size();
    case 1: return m_DieselList.size();
    case 2: return m_ElectricList.size();
    case 3: return m_TrainsetList.size();
    case 4: return m_SpecialList.size();
    case 5: return m_CarList.size();
    }
    return 0;
  }

  @Override
  public Object getGroup(int group) {
    switch(group) {
    case 0: return m_Context.getText(R.string.Steam).toString();
    case 1: return m_Context.getText(R.string.Diesel).toString();
    case 2: return m_Context.getText(R.string.Electric).toString();
    case 3: return m_Context.getText(R.string.Trainset).toString();
    case 4: return m_Context.getText(R.string.Special).toString();
    case 5: return m_Context.getText(R.string.Car).toString();
    }
    return null;
  }

  @Override
  public int getGroupCount() {
    return m_Lists.length;
  }

  @Override
  public long getGroupId(int group) {
    return group;
  }

  @Override
  public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
    return getCustomGroupView(groupPosition, convertView, parent);
  }

  @Override
  public boolean hasStableIds() {
    // TODO Auto-generated method stub
    return false;
  }

  @Override
  public boolean isChildSelectable(int arg0, int arg1) {
    return true;
  }
  
  
  public static class ViewHolder {
    public TextView text;
    public TextView text2;
    public TextView addr;
    public ImageView icon;
}

  public View getCustomGroupView(int position, View convertView, ViewGroup parent) {
    View row = convertView;
    ViewHolder holder;

    if (row == null) {
      LayoutInflater inflater = (LayoutInflater) m_Context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
      row = inflater.inflate(R.layout.lococatitem, parent, false);

      holder = new ViewHolder();

      holder.text = (TextView) row.findViewById(R.id.locoCatText);
      holder.icon = (ImageView) row.findViewById(R.id.folderImage);
      holder.icon.setFocusable(false);
      row.setTag(holder);
    } 
    else {
      holder = (ViewHolder) row.getTag();
    }

    
    switch(position) {
    case 0: holder.text.setText("Steam"); break;
    case 1: holder.text.setText("Diesel"); break;
    case 2: holder.text.setText("Electric"); break;
    case 3: holder.text.setText("Trainset"); break;
    case 4: holder.text.setText("Special"); break;
    case 5: holder.text.setText("Car"); break;
    }
  
    return row;
  }
  
  
  public int getRealPosition(int group, int position) {
    
    List<Mobile> list = m_Lists[group];
    Mobile loco = list.get(position);
    
    for( int i = 0; i < m_MobileList.size(); i++ ) {
      if( loco == m_MobileList.get(i) ) {
        return i;
      }
    }
    return 0;
  }
  

  public View getCustomChildView(int groupposition, int position, View convertView, ViewGroup parent) {
    View row = convertView;
    ViewHolder holder;

    if (row == null) {
      LayoutInflater inflater = (LayoutInflater) m_Context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
      row = inflater.inflate(R.layout.locorow, parent, false);

      holder = new ViewHolder();

      holder.text = (TextView) row.findViewById(R.id.locoRowText);
      holder.addr = (TextView) row.findViewById(R.id.locoRowAddr);
      holder.icon = (ImageView) row.findViewById(R.id.locoRowImage);
      //holder.icon.setClickable(true);
      holder.icon.setFocusable(false);
      row.setTag(holder);
    } 
    else {
      holder = (ViewHolder) row.getTag();
    }

    List<Mobile> list = m_Lists[groupposition];
    
    if( list != null && position < list.size() ) {
      Mobile loco = list.get(position);
      if( sortbyaddr ) {
        holder.text.setText(""+loco.getAddr());
        holder.addr.setText(loco.getID());
      }
      else {
        holder.text.setText(loco.getID());
        holder.addr.setText(""+loco.getAddr());
      }
  
      Bitmap img = loco.getBmp(loco.getImageView());
      if( img != null )
        holder.icon.setImageBitmap(img);
      else
        holder.icon.setImageResource(R.drawable.noimg);
    }
    else {
      holder.text.setText("?");
      holder.icon.setImageResource(R.drawable.noimg);
    }
  
    return row;
  }


}
