package net.sourceforge.wifiremoteplay;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

public class FileBrowserActivity extends Activity {
	private static final String TAG = "FileBrowserActivity";
	private String current_url = null;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		if( MyDebug.LOG )
			Log.d(TAG, "onCreate");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_filebrowser);

        WebView webView = (WebView)findViewById(R.id.webview);
        webView.setWebViewClient(new WebViewClient() {
        	@Override
        	public boolean shouldOverrideUrlLoading(WebView view, String url) {
                //view.loadUrl(url);
        		current_url = url;
        	    new OnLoadTask().execute(url);

        		if( MyDebug.LOG )
        			Log.d(TAG, "Load: " + url);
        	    Toast.makeText(getApplicationContext(), "Loading...", Toast.LENGTH_SHORT).show();
        	    return true;
        	}
        });
        webView.getSettings().setBuiltInZoomControls(true);

        if( savedInstanceState != null ) {
    		if( MyDebug.LOG )
    			Log.d(TAG, "have savedInstanceState");
    	    current_url = savedInstanceState.getString("current_url");
    	    if( current_url != null ) {
    			if( MyDebug.LOG )
    				Log.d(TAG, "found current_url: " + current_url);
        	    new OnLoadTask().execute(current_url);
        	    return;
    	    }
        }

        int player = MainApp.getPlayer(this);
        int port = 0;
        if( player == MainApp.PLAYER_MPC ) {
            port = MainApp.getMPCPort(this);
        }
        else if( player == MainApp.PLAYER_VLC ) {
            port = MainApp.getVLCPort(this);
        }
        String url_string = "http://" + MainApp.getIPAddress(this) + ":" + port + "/browser.html";
		if( MyDebug.LOG )
			Log.d(TAG, "load: " + url_string);
        //webView.loadUrl(url_string);
	    new OnLoadTask().execute(url_string);
	}

	private class OnLoadTask extends AsyncTask<String, Integer, Void> {
        // We do some hackery here, to replace the ".." used to indicate the parent directory link. Firstly, ".."
        // is not very user friendly. Secondly, it means that the link is very small, and difficult to select on
        // a phone.
	    protected Void doInBackground(String... urls) {
            // only care about 1st parameter
	    	final String url_string = urls[0];
			if( MyDebug.LOG )
				Log.d(TAG, "OnLoadTask: " + url_string);
	        String data = "";
	        HttpURLConnection urlConnection = null;
	        try {
	        	URL url = new URL(url_string);
	        	urlConnection = (HttpURLConnection)url.openConnection();
	        	InputStream in = new BufferedInputStream(urlConnection.getInputStream());
	        	BufferedReader rd = new BufferedReader(new InputStreamReader(in), 4096);
	        	String line;

	        	while( (line = rd.readLine()) != null ) {
	        		data += line + "\n";
	        	}
	        	rd.close();

	        }
	        catch(MalformedURLException e) {
	    		if( MyDebug.LOG )
	    			Log.d(TAG, "MalformedURLException");
	        	e.printStackTrace();
	        }
	        catch(IOException e) {
	    		if( MyDebug.LOG )
	    			Log.d(TAG, "IOException");
	            e.printStackTrace();
	        }
	        finally {
	        	if( urlConnection != null ) {
	        		urlConnection.disconnect();
	        	}
	        }

            // Theoretically searching for ".." should find the link for parent directory, but there's a risk
            // of this breaking if it's changed in future Media Player Classic versions, which would result in
            // problems if any filenames had ".." in the title! So we use these search terms to narrow down where
            // we want to look.
            int index_parent = data.indexOf(">..</a>");
    		if( MyDebug.LOG )
    			Log.d(TAG, "index_parent = " + index_parent);
            if( index_parent != -1 ) {
                index_parent++;
                StringBuffer data_sb = new StringBuffer(data);
        		if( MyDebug.LOG )
        			Log.d(TAG, "replace .. to parent directory at " + index_parent);
                data_sb.replace(index_parent, index_parent+2, "Parent Directory");
                data = data_sb.toString();
            }

    		/*if( MyDebug.LOG )
    			Log.d(TAG, "final html data:\n" + data);*/

	        final String final_data = data;
			runOnUiThread(new Runnable() {
			    public void run() {
			        WebView webView = (WebView)findViewById(R.id.webview);
			        //webView.loadData(final_data, "text/html", "utf-8");
			        webView.loadDataWithBaseURL(url_string, final_data, "text/html", "utf-8", null);
			    }
			});

	        return null;
	    }
	}

	@Override
	protected void onSaveInstanceState(Bundle state) {
		if( MyDebug.LOG )
			Log.d(TAG, "onSaveInstanceState");
	    super.onSaveInstanceState(state);
	    if( current_url != null ) {
			if( MyDebug.LOG )
				Log.d(TAG, "save current_url: " + current_url);
	    	state.putString("current_url", current_url);
	    }
	}
}
