/*
 * Decompiled with CFR 0.152.
 */
package org.androidsoft.utils.credits;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.util.ArrayList;
import java.util.List;
import org.androidsoft.utils.credits.AbstractTextItem;
import org.androidsoft.utils.credits.Category;
import org.androidsoft.utils.credits.CreditsItem;
import org.androidsoft.utils.credits.CreditsParams;
import org.androidsoft.utils.credits.Person;

public class CreditsView
extends SurfaceView
implements SurfaceHolder.Callback {
    private SurfaceHolder mHolder;
    private Bitmap mBackground;
    private Bitmap mBackgroundLandscape;
    private int mBackgroundResId;
    private int mBackgroundLandscapeResId;
    private int mWidth;
    private int mHeight;
    private int period;
    private Rect mbgIn;
    private Paint mBgPaint = new Paint();
    private CreditsThread mThread;
    private Handler mHandler = new Handler();
    private List<CreditsItem> credits = new ArrayList<CreditsItem>();
    private float mPreviousX;
    private float mPreviousY;
    private int mDY;
    private boolean mTouch;
    private final Runnable mDrawFrames = new Runnable(){

        @Override
        public void run() {
            CreditsView.this.drawFrame();
        }
    };

    public CreditsView(Context context, CreditsParams params) {
        super(context);
        this.mHolder = this.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.init(context, params);
    }

    private void init(Context context, CreditsParams p) {
        Paint paintPerson = new Paint();
        paintPerson.setAntiAlias(true);
        paintPerson.setStrokeWidth(5.0f);
        paintPerson.setStrokeCap(Paint.Cap.ROUND);
        paintPerson.setTextSize((float)p.getTextSizeDefault());
        paintPerson.setTypeface(p.getTypefaceDefault());
        paintPerson.setColor(p.getColorDefault());
        paintPerson.setTextAlign(Paint.Align.CENTER);
        Person.setPaint(paintPerson);
        Person.setSpacings(p.getSpacingBeforeDefault(), p.getSpacingAfterDefault());
        Paint paintCategory = new Paint();
        paintCategory.setAntiAlias(true);
        paintCategory.setStrokeWidth(5.0f);
        paintCategory.setStrokeCap(Paint.Cap.ROUND);
        paintCategory.setTextSize((float)p.getTextSizeCategory());
        paintCategory.setTypeface(p.getTypefaceCategory());
        paintCategory.setColor(p.getColorCategory());
        paintCategory.setTextAlign(Paint.Align.CENTER);
        Category.setPaint(paintCategory);
        Category.setSpacings(p.getSpacingBeforeCategory(), p.getSpacingAfterCategory());
        this.credits.add(new Person(context.getString(p.getAppNameRes())));
        this.credits.add(new Category(context.getString(p.getAppVersionRes())));
        this.loadFromResources(this.credits, p.getArrayCreditsRes());
        this.mBackgroundResId = p.getBitmapBackgroundRes();
        this.mBackgroundLandscapeResId = p.getBitmapBackgroundLandscapeRes();
    }

    private void calculatedItemSpacing(List<CreditsItem> list, int height) {
        int offset = height + 30;
        for (CreditsItem item : list) {
            item.setOffset(offset += item.getBeforeSpacing());
            offset += item.getAfterSpacing();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mThread = new CreditsThread();
        this.mThread.start();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Bitmap bitmap;
        this.mHandler.removeCallbacks(this.mDrawFrames);
        this.mWidth = width;
        this.mHeight = height;
        this.mbgIn = null;
        this.calculatedItemSpacing(this.credits, this.mHeight);
        if (this.mWidth < this.mHeight) {
            bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mBackgroundResId);
            this.mBackground = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mWidth, (int)this.mHeight, (boolean)true);
        } else {
            bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mBackgroundLandscapeResId);
            this.mBackgroundLandscape = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mWidth, (int)this.mHeight, (boolean)true);
        }
        this.mThread.alive = false;
        while (this.mThread.isAlive()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.mThread = new CreditsThread();
        this.mThread.start();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mHandler.removeCallbacks(this.mDrawFrames);
        if (this.mThread != null) {
            this.mThread.alive = false;
        }
    }

    private void loadFromResources(List<CreditsItem> list, int resArray) {
        Resources res = this.getResources();
        TypedArray entries = res.obtainTypedArray(resArray);
        for (int i = 0; i < entries.length(); ++i) {
            AbstractTextItem item = null;
            String entry = entries.getString(i);
            item = entry.startsWith("*") ? new Category(entry.substring(1)) : new Person(entry);
            list.add(item);
        }
    }

    public void onSurfaceChanged() {
    }

    private synchronized void prepareFrame(long ellapsed) {
        CreditsItem last;
        if (this.credits.size() > 0 && (last = this.credits.get(this.credits.size() - 1)).getOffset() < 0) {
            this.calculatedItemSpacing(this.credits, this.mHeight);
        }
        this.mDY = this.mTouch ? 0 : this.mDY / 3 - 1;
        for (CreditsItem item : this.credits) {
            item.prepare(ellapsed, this.mWidth, this.mHeight, this.mDY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void drawFrame() {
        if (this.mThread != null) {
            this.mThread.cont = false;
        }
        Canvas canvas = null;
        try {
            canvas = this.mHolder.lockCanvas(null);
            if (canvas != null) {
                this.drawBackground(canvas);
                for (CreditsItem item : this.credits) {
                    item.draw(canvas);
                }
            }
        }
        finally {
            if (canvas != null) {
                this.mHolder.unlockCanvasAndPost(canvas);
            }
        }
    }

    void drawBackground(Canvas c) {
        if (this.mbgIn == null) {
            this.mbgIn = new Rect(0, 0, this.mWidth, this.mHeight);
        }
        if (this.mWidth < this.mHeight) {
            c.drawBitmap(this.mBackground, this.mbgIn, this.mbgIn, this.mBgPaint);
        } else {
            c.drawBitmap(this.mBackgroundLandscape, this.mbgIn, this.mbgIn, this.mBgPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent e) {
        float x = e.getX();
        float y = e.getY();
        switch (e.getAction()) {
            case 0: {
                this.mPreviousX = x;
                this.mPreviousY = y;
                this.mTouch = true;
                break;
            }
            case 2: {
                float dx = x - this.mPreviousX;
                float dy = y - this.mPreviousY;
                this.mDY = (int)dy;
                this.mPreviousX = x;
                this.mPreviousY = y;
            }
            case 1: {
                this.mTouch = false;
            }
        }
        return true;
    }

    private class CreditsThread
    extends Thread {
        public boolean cont = true;
        public boolean alive = true;
        private long lastTime;
        private long current;
        private long ellapsed;

        public CreditsThread() {
            this.setName("Credits");
            this.lastTime = System.currentTimeMillis();
        }

        @Override
        public void run() {
            while (this.alive) {
                this.current = System.currentTimeMillis();
                this.ellapsed = this.current - this.lastTime;
                this.lastTime = this.current;
                CreditsView.this.prepareFrame(this.ellapsed);
                this.cont = true;
                CreditsView.this.mHandler.postDelayed(CreditsView.this.mDrawFrames, (long)CreditsView.this.period - this.ellapsed);
                while (this.cont && this.alive) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

