/* Copyright (c) 2010-2012 Pierre LEVY androidsoft.org
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.androidsoft.app.permission.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Permission Group Object
 * @author Pierre Levy
 */
public class PermissionGroup
{
    private String name;
    private String label;
    private String description;
    private List<Permission> listPermissions = new ArrayList<Permission>();

    /**
     * @return the description
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @param description the description to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * @return the listPermissions
     */
    public List<Permission> getListPermissions()
    {
        return listPermissions;
    }

    /**
     * @param listPermissions the listPermissions to set
     */
    public void setListPermissions(List<Permission> listPermissions)
    {
        this.listPermissions = listPermissions;
    }
    
    /**
     * 
     * @param permission
     */
    public void addPermission( Permission permission )
    {
        this.listPermissions.add(permission);
    }

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the label
     */
    public String getLabel()
    {
        return label;
    }

    /**
     * @param label the label to set
     */
    public void setLabel(String label)
    {
        this.label = label;
    }
}
