/**

Buddha Quotes
Copyright (C) 2021  BanDev

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

 */

package org.bandev.buddhaquotes.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import org.bandev.buddhaquotes.databinding.CardListsFragmentBinding
import org.bandev.buddhaquotes.fragments.ListsFragment
import org.bandev.buddhaquotes.items.ListItem

/**
 * Recycler adapter for the [RecyclerView] used in the [ListsFragment]
 * activity. This adapter updated for view binding
 * and supports item clicks.
 *
 * @author Fennec
 * @param scrollingLists [List<ListItem>]
 * @param listener [ListsFragment]
 */
class ListRecycler(

    private val scrollingLists: List<ListItem>,
    private val listener: ListsFragment,

    ) : RecyclerView.Adapter<ListRecycler.ScrollingViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ScrollingViewHolder {
        val binding = CardListsFragmentBinding.inflate(
            LayoutInflater.from(parent.context),
            parent, false
        )
        return ScrollingViewHolder(binding.root)
    }

    override fun onBindViewHolder(holder: ScrollingViewHolder, position: Int) {
        val currentItem = scrollingLists[position]

        holder.binding.title.text = currentItem.title
        holder.binding.summary.text = currentItem.summary

        if (currentItem.special) {
            holder.binding.bin.visibility = View.GONE
        }
    }

    override fun getItemCount(): Int = scrollingLists.size

    inner class ScrollingViewHolder(itemView: View) :
        RecyclerView.ViewHolder(itemView),
        View.OnClickListener,
        View.OnLongClickListener {
        val binding: CardListsFragmentBinding = CardListsFragmentBinding.bind(itemView)

        init {
            itemView.setOnClickListener {
                val position = bindingAdapterPosition
                if (position != RecyclerView.NO_POSITION) {
                    listener.onCardClick(position)
                }
            }

            binding.bin.setOnClickListener {
                val position = bindingAdapterPosition
                if (position != RecyclerView.NO_POSITION) {
                    listener.onBinClick(position, binding.title.text.toString())
                }
            }
        }

        override fun onClick(v: View?) {
            val position = bindingAdapterPosition
            if (position != RecyclerView.NO_POSITION) {
                listener.onLikeClick(position, binding.title.toString())
            }
        }

        override fun onLongClick(view: View): Boolean {
            val position = bindingAdapterPosition
            if (position != RecyclerView.NO_POSITION) {
                listener.onLikeClick(position, binding.title.toString())
            }
            // Return true to indicate the click was handled
            return true
        }
    }
}
