/*
 * Copyright (c) 2012,2013 Stefan Völkel <bd@bc-bd.org>
 *
 * Released under the GPL v2. See file License for details.
 *
 * */

package org.bc_bd.mrwhite;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManager.LayoutParams;

public class MrWhiteActivity extends Activity {
	private final static String TAG = "MrWhiteActivity";

	private static final int step = 10;
	private int brightness = 100;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		requestWindowFeature(Window.FEATURE_NO_TITLE);

		View view = new View(this);
		view.setBackgroundColor(Color.WHITE);
		view.setKeepScreenOn(true);
		setContentView(view);
	}

	@Override
	public void onStart() {
		super.onStart();

		applySettings();
	}

	public void applySettings() {
		WindowManager.LayoutParams lp = getWindow().getAttributes();
		lp.screenBrightness = brightness / 100f;
		getWindow().setAttributes(lp);

		// for full screen mode
		getWindow().addFlags(LayoutParams.FLAG_FULLSCREEN);
	}

	@Override
	public boolean dispatchKeyEvent(KeyEvent event) {
		int action = event.getAction();
		int keyCode = event.getKeyCode();

		switch (keyCode) {
		case KeyEvent.KEYCODE_VOLUME_UP:
			if (action == KeyEvent.ACTION_UP) {
				brightness = brightness + step < 100 ? brightness + step : 100;
				Log.d(TAG, "brightness up " + brightness);
				applySettings();
			}
			return true;
		case KeyEvent.KEYCODE_VOLUME_DOWN:
			if (action == KeyEvent.ACTION_DOWN) {
				brightness = brightness - step > step ? brightness - step
						: step;
				Log.d(TAG, "brightness down " + brightness);
				applySettings();
			}
			return true;
		default:
			return super.dispatchKeyEvent(event);
		}
	}
}
