/*
 * Decompiled with CFR 0.152.
 */
package org.bostonandroid.timepreference;

import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.DialogPreference;
import android.preference.Preference;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TimePicker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimePreference
extends DialogPreference
implements TimePicker.OnTimeChangedListener {
    private String timeString;
    private String changedValueCanBeNull;

    public TimePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public TimePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected View onCreateDialogView() {
        TimePicker timePicker = new TimePicker(this.getContext());
        timePicker.setIs24HourView(Boolean.valueOf(DateFormat.is24HourFormat((Context)this.getContext())));
        Calendar calendar = this.getTime();
        timePicker.setCurrentHour(Integer.valueOf(calendar.get(11)));
        timePicker.setCurrentMinute(Integer.valueOf(calendar.get(12)));
        timePicker.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)this);
        return timePicker;
    }

    public Calendar getTime() {
        try {
            Date date = TimePreference.formatter().parse(this.defaultValue());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            return TimePreference.defaultCalendar();
        }
    }

    public void setTime(String timeString) {
        this.timeString = timeString;
    }

    public static java.text.DateFormat formatter() {
        return new SimpleDateFormat("HH:mm");
    }

    public static java.text.DateFormat summaryFormatter(Context context) {
        return DateFormat.getTimeFormat((Context)context);
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onSetInitialValue(boolean restoreValue, Object def) {
        if (restoreValue) {
            this.timeString = this.getPersistedString(this.defaultValue());
            this.setTheTime(this.timeString);
        } else {
            boolean wasNull = this.timeString == null;
            this.setTime((String)def);
            if (!wasNull) {
                this.persistTime(this.timeString);
            }
        }
    }

    protected Parcelable onSaveInstanceState() {
        if (this.isPersistent()) {
            return super.onSaveInstanceState();
        }
        return new SavedState(super.onSaveInstanceState());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            this.setTheTime(((SavedState)state).dateValue);
        } else {
            SavedState s = (SavedState)state;
            super.onRestoreInstanceState(s.getSuperState());
            this.setTheTime(s.dateValue);
        }
    }

    public void onTimeChanged(TimePicker view, int hour, int minute) {
        GregorianCalendar selected = new GregorianCalendar(1970, 0, 1, hour, minute);
        this.changedValueCanBeNull = TimePreference.formatter().format(selected.getTime());
    }

    protected void onDialogClosed(boolean shouldSave) {
        if (shouldSave && this.changedValueCanBeNull != null) {
            this.setTheTime(this.changedValueCanBeNull);
            this.changedValueCanBeNull = null;
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        super.onClick(dialog, which);
        if (this.getDialog().getCurrentFocus() != null) {
            this.getDialog().getCurrentFocus().clearFocus();
        }
    }

    private void setTheTime(String s) {
        this.setTime(s);
        this.persistTime(s);
    }

    private void persistTime(String s) {
        this.persistString(s);
        this.setSummary(TimePreference.summaryFormatter(this.getContext()).format(this.getTime().getTime()));
    }

    public static Calendar defaultCalendar() {
        return new GregorianCalendar(1970, 0, 1, 0, 0);
    }

    public static String defaultCalendarString() {
        return TimePreference.formatter().format(TimePreference.defaultCalendar().getTime());
    }

    private String defaultValue() {
        if (this.timeString == null) {
            this.setTime(TimePreference.defaultCalendarString());
        }
        return this.timeString;
    }

    public static Calendar getTimeFor(SharedPreferences preferences, String field) {
        Date date = TimePreference.stringToDate(preferences.getString(field, TimePreference.defaultCalendarString()));
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static Date stringToDate(String timeString) {
        try {
            return TimePreference.formatter().parse(timeString);
        }
        catch (ParseException e) {
            return TimePreference.defaultCalendar().getTime();
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        String dateValue;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel p) {
            super(p);
            this.dateValue = p.readString();
        }

        public SavedState(Parcelable p) {
            super(p);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.dateValue);
        }
    }
}

